/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ListObservableValue
extends AbstractSWTObservableValue {
    private final List list;
    private boolean updating = false;
    private String currentValue;
    static /* synthetic */ Class class$0;

    public ListObservableValue(List list) {
        super((Widget)list);
        this.list = list;
        this.currentValue = (String)this.doGetValue();
        if ((list.getStyle() & 2) > 0) {
            throw new IllegalArgumentException("SWT.SINGLE support only for a List selection");
        }
        list.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ListObservableValue.this.updating) {
                    String oldValue = ListObservableValue.this.currentValue;
                    ListObservableValue.this.currentValue = (String)ListObservableValue.this.doGetValue();
                    ListObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, ListObservableValue.this.currentValue));
                }
            }
        });
    }

    public void doSetValue(Object value) {
        String oldValue = null;
        if (this.list.getSelection() != null && this.list.getSelection().length > 0) {
            oldValue = this.list.getSelection()[0];
        }
        try {
            this.updating = true;
            String[] items = this.list.getItems();
            int index = -1;
            if (items != null && value != null) {
                int i = 0;
                while (i < items.length) {
                    if (value.equals(items[i])) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.list.select(index);
            }
            this.currentValue = (String)value;
        }
        finally {
            this.updating = false;
        }
        this.fireValueChange(Diffs.createValueDiff(oldValue, value));
    }

    public Object doGetValue() {
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            return this.list.getItem(index);
        }
        return null;
    }

    public Object getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

