/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.AbstractWorkingSetDialog;
import org.eclipse.ui.internal.dialogs.WorkingSetFilter;
import org.eclipse.ui.internal.dialogs.WorkingSetLabelProvider;

class ConfigureWindowWorkingSetsDialog
extends AbstractWorkingSetDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private IWorkbenchWindow window;
    private CheckboxTableViewer viewer;

    protected ConfigureWindowWorkingSetsDialog(IWorkbenchWindow window) {
        super(window.getShell(), null);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.window = window;
        this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title_multiSelect);
        this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message_multiSelect);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite viewerComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        viewerComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 350;
        viewerComposite.setLayoutData((Object)data);
        this.viewer = CheckboxTableViewer.newCheckList(viewerComposite, 2048);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider(new WorkingSetLabelProvider());
        this.viewer.setContentProvider(new ArrayContentProvider());
        this.viewer.addFilter(new WorkingSetFilter(null));
        this.viewer.setInput(this.window.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.viewer.setCheckedElements(this.window.getActivePage().getWorkingSets());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigureWindowWorkingSetsDialog.this.handleSelectionChanged();
            }
        });
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.viewer.getControl().setLayoutData((Object)data);
        this.addModifyButtons(viewerComposite);
        this.addSelectionButtons(composite);
        this.availableWorkingSetsChanged();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        Object[] selection = this.viewer.getCheckedElements();
        IWorkingSet[] workingSets = new IWorkingSet[selection.length];
        System.arraycopy(selection, 0, workingSets, 0, selection.length);
        this.window.getActivePage().setWorkingSets(workingSets);
        super.okPressed();
    }

    protected List getSelectedWorkingSets() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return null;
    }

    protected void availableWorkingSetsChanged() {
        this.viewer.setInput(this.window.getWorkbench().getWorkingSetManager().getWorkingSets());
        super.availableWorkingSetsChanged();
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void selectAllSets() {
        this.viewer.setCheckedElements(this.window.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.updateButtonAvailability();
    }

    protected void deselectAllSets() {
        this.viewer.setCheckedElements(new Object[0]);
        this.updateButtonAvailability();
    }
}

