/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.IEvaluationReference;
import org.eclipse.ui.internal.services.IEvaluationService;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.menus.UIElement;

public final class HandlerProxy
extends AbstractHandler
implements IElementUpdater {
    private static final String PROP_ENABLED = "enabled";
    private IConfigurationElement configurationElement;
    private final Expression enabledWhenExpression;
    private IHandler handler = null;
    private final String handlerAttributeName;
    private IHandlerListener handlerListener;
    private IEvaluationService evaluationService;
    private IPropertyChangeListener enablementListener;
    private IEvaluationReference enablementRef;
    private boolean proxyEnabled;

    public HandlerProxy(IConfigurationElement configurationElement, String handlerAttributeName) {
        this(configurationElement, handlerAttributeName, null, null);
    }

    public HandlerProxy(IConfigurationElement configurationElement, String handlerAttributeName, Expression enabledWhenExpression, IEvaluationService evaluationService) {
        if (configurationElement == null) {
            throw new NullPointerException("The configuration element backing a handler proxy cannot be null");
        }
        if (handlerAttributeName == null) {
            throw new NullPointerException("The attribute containing the handler class must be known");
        }
        if (enabledWhenExpression != null && evaluationService == null) {
            throw new NullPointerException("We must have a handler service and evaluation service to support the enabledWhen expression");
        }
        this.configurationElement = configurationElement;
        this.handlerAttributeName = handlerAttributeName;
        this.enabledWhenExpression = enabledWhenExpression;
        this.evaluationService = evaluationService;
        if (enabledWhenExpression != null) {
            this.setProxyEnabled(false);
            this.registerEnablement();
        } else {
            this.setProxyEnabled(true);
        }
    }

    private void registerEnablement() {
        this.enablementRef = this.evaluationService.addEvaluationListener(this.enabledWhenExpression, this.getEnablementListener(), PROP_ENABLED, null);
    }

    void setEnabledFor(IEvaluationContext context) throws ExecutionException {
        if (this.enabledWhenExpression != null) {
            try {
                this.setProxyEnabled(this.enabledWhenExpression.evaluate(context) == EvaluationResult.TRUE);
            }
            catch (CoreException e) {
                throw new ExecutionException(e.getMessage(), e);
            }
        }
    }

    void setProxyEnabled(boolean enabled) {
        this.proxyEnabled = enabled;
    }

    boolean getProxyEnabled() {
        return this.proxyEnabled;
    }

    private IPropertyChangeListener getEnablementListener() {
        if (this.enablementListener == null) {
            this.enablementListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty() == HandlerProxy.PROP_ENABLED) {
                        HandlerProxy.this.setProxyEnabled(event.getNewValue() == null ? false : (Boolean)event.getNewValue());
                        HandlerProxy.this.fireHandlerChanged(new HandlerEvent(HandlerProxy.this, true, false));
                    }
                }
            };
        }
        return this.enablementListener;
    }

    public final void dispose() {
        if (this.handler != null) {
            if (this.handlerListener != null) {
                this.handler.removeHandlerListener(this.handlerListener);
                this.handlerListener = null;
            }
            this.handler.dispose();
            this.handler = null;
        }
        if (this.enablementListener != null) {
            this.evaluationService.removeEvaluationListener(this.enablementRef);
            this.enablementRef = null;
            this.enablementListener = null;
        }
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.loadHandler()) {
            return this.handler.execute(event);
        }
        return null;
    }

    public final boolean isEnabled() {
        if (this.enabledWhenExpression != null) {
            if (!this.getProxyEnabled()) {
                return false;
            }
            if (this.isOkToLoad() && this.loadHandler()) {
                return this.handler.isEnabled();
            }
            return true;
        }
        if (this.isOkToLoad() && this.loadHandler()) {
            return this.handler.isEnabled();
        }
        return true;
    }

    public final boolean isHandled() {
        if (this.configurationElement != null) {
            return true;
        }
        if (this.isOkToLoad() && this.loadHandler()) {
            return this.handler.isHandled();
        }
        return false;
    }

    private final boolean loadHandler() {
        if (this.handler == null) {
            try {
                if (this.configurationElement != null) {
                    this.handler = (IHandler)this.configurationElement.createExecutableExtension(this.handlerAttributeName);
                    this.configurationElement = null;
                    this.handler.addHandlerListener(this.getHandlerListener());
                    return true;
                }
            }
            catch (ClassCastException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied handler was the wrong class", e);
                WorkbenchPlugin.log("The proxied handler was the wrong class", status);
                this.configurationElement = null;
            }
            catch (CoreException e) {
                String message = "The proxied handler for '" + this.configurationElement.getAttribute(this.handlerAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, e);
                WorkbenchPlugin.log(message, status);
                this.configurationElement = null;
            }
            return false;
        }
        return true;
    }

    private IHandlerListener getHandlerListener() {
        if (this.handlerListener == null) {
            this.handlerListener = new IHandlerListener(){

                public void handlerChanged(HandlerEvent handlerEvent) {
                    HandlerProxy.this.fireHandlerChanged(new HandlerEvent(HandlerProxy.this, handlerEvent.isEnabledChanged(), handlerEvent.isHandledChanged()));
                }
            };
        }
        return this.handlerListener;
    }

    public final String toString() {
        if (this.handler == null) {
            if (this.configurationElement != null) {
                return this.configurationElement.getAttribute(this.handlerAttributeName);
            }
            return "HandlerProxy()";
        }
        return this.handler.toString();
    }

    private boolean isOkToLoad() {
        if (this.configurationElement != null) {
            String bundleId = this.configurationElement.getContributor().getName();
            return BundleUtility.isActive(bundleId);
        }
        return true;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (this.handler != null && this.handler instanceof IElementUpdater) {
            ((IElementUpdater)((Object)this.handler)).updateElement(element, parameters);
        }
    }
}

