/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.BundleGroupProperties;
import org.eclipse.ui.internal.ProductProperties;

public final class AboutInfo {
    private ProductProperties productProperties;
    private BundleGroupProperties bundleGroupProperties;
    private Long featureImageCRC;
    private boolean calculatedImageCRC = false;

    public AboutInfo(IProduct product) {
        this.productProperties = new ProductProperties(product);
    }

    public AboutInfo(IBundleGroup bundleGroup) {
        this.bundleGroupProperties = new BundleGroupProperties(bundleGroup);
    }

    public static AboutInfo readFeatureInfo(String featureId, String versionId) {
        Assert.isNotNull(featureId);
        Assert.isNotNull(versionId);
        IProduct product = Platform.getProduct();
        if (product != null && featureId.equals(ProductProperties.getProductId(product))) {
            return new AboutInfo(product);
        }
        IBundleGroup bundleGroup = AboutInfo.getBundleGroup(featureId, versionId);
        if (bundleGroup != null) {
            return new AboutInfo(bundleGroup);
        }
        return null;
    }

    private static IBundleGroup getBundleGroup(String id, String versionId) {
        if (id == null || versionId == null) {
            return null;
        }
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        int p = 0;
        while (p < providers.length) {
            IBundleGroup[] groups = providers[p].getBundleGroups();
            int g = 0;
            while (g < groups.length) {
                if (id.equals(groups[g].getIdentifier()) && versionId.equals(groups[g].getVersion())) {
                    return groups[g];
                }
                ++g;
            }
            ++p;
        }
        return null;
    }

    public ImageDescriptor getAboutImage() {
        return this.productProperties == null ? null : this.productProperties.getAboutImage();
    }

    public ImageDescriptor getFeatureImage() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getFeatureImage();
    }

    public String getFeatureImageName() {
        if (this.bundleGroupProperties == null) {
            return null;
        }
        URL url = this.bundleGroupProperties.getFeatureImageUrl();
        return url == null ? null : new Path(url.getPath()).lastSegment();
    }

    public Long getFeatureImageCRC() {
        if (this.bundleGroupProperties == null) {
            return null;
        }
        if (!this.calculatedImageCRC) {
            this.featureImageCRC = AboutInfo.calculateImageCRC(this.bundleGroupProperties.getFeatureImageUrl());
            this.calculatedImageCRC = this.featureImageCRC != null;
        }
        return this.featureImageCRC;
    }

    /*
     * Loose catch block
     */
    private static Long calculateImageCRC(URL url) {
        Long l;
        InputStream in;
        block13: {
            if (url == null) {
                return null;
            }
            in = null;
            CRC32 checksum = new CRC32();
            in = new CheckedInputStream(url.openStream(), checksum);
            byte[] sink = new byte[2048];
            while (in.read(sink) > 0) {
            }
            l = new Long(checksum.getValue());
            if (in == null) break block13;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return l;
        catch (IOException iOException) {
            block14: {
                try {
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public String getFeatureLabel() {
        if (this.productProperties != null) {
            return this.productProperties.getProductName();
        }
        if (this.bundleGroupProperties != null) {
            return this.bundleGroupProperties.getFeatureLabel();
        }
        return null;
    }

    public String getFeatureId() {
        String id = null;
        if (this.productProperties != null) {
            id = this.productProperties.getProductId();
        } else if (this.bundleGroupProperties != null) {
            id = this.bundleGroupProperties.getFeatureId();
        }
        return id != null ? id : "";
    }

    public String getAboutText() {
        return this.productProperties == null ? null : this.productProperties.getAboutText();
    }

    public String getAppName() {
        return this.productProperties == null ? null : this.productProperties.getAppName();
    }

    public String getProductName() {
        return this.productProperties == null ? null : this.productProperties.getProductName();
    }

    public String getProviderName() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getProviderName();
    }

    public String getVersionId() {
        return this.bundleGroupProperties == null ? "" : this.bundleGroupProperties.getFeatureVersion();
    }

    public URL getWelcomePageURL() {
        if (this.productProperties != null) {
            return this.productProperties.getWelcomePageUrl();
        }
        if (this.bundleGroupProperties != null) {
            return this.bundleGroupProperties.getWelcomePageUrl();
        }
        return null;
    }

    public String getWelcomePerspectiveId() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getWelcomePerspective();
    }

    public String getTipsAndTricksHref() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getTipsAndTricksHref();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.productProperties == null ? null : this.productProperties.getWindowImages();
    }
}

