/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;

public class ArchiveFileManipulations {
    private static ZipLeveledStructureProvider zipProviderCache;
    private static TarLeveledStructureProvider tarProviderCache;

    public static boolean isTarFile(String fileName) {
        if (fileName.length() == 0) {
            return false;
        }
        try {
            new TarFile(fileName);
        }
        catch (TarException tarException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean isZipFile(String fileName) {
        if (fileName.length() == 0) {
            return false;
        }
        try {
            new ZipFile(fileName);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void clearProviderCache(Shell shell) {
        if (zipProviderCache != null) {
            ArchiveFileManipulations.closeZipFile(zipProviderCache.getZipFile(), shell);
            zipProviderCache = null;
        }
        tarProviderCache = null;
    }

    public static ZipLeveledStructureProvider getZipStructureProvider(ZipFile targetZip, Shell shell) {
        if (zipProviderCache == null) {
            zipProviderCache = new ZipLeveledStructureProvider(targetZip);
        } else if (!zipProviderCache.getZipFile().getName().equals(targetZip.getName())) {
            ArchiveFileManipulations.clearProviderCache(shell);
            zipProviderCache = new ZipLeveledStructureProvider(targetZip);
        } else if (!zipProviderCache.getZipFile().equals(targetZip)) {
            zipProviderCache = new ZipLeveledStructureProvider(targetZip);
        }
        return zipProviderCache;
    }

    public static boolean closeZipFile(ZipFile file, Shell shell) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            ArchiveFileManipulations.displayErrorDialog(DataTransferMessages.ZipImport_couldNotClose, shell);
            return false;
        }
        return true;
    }

    public static TarLeveledStructureProvider getTarStructureProvider(TarFile targetTar, Shell shell) {
        if (tarProviderCache == null) {
            tarProviderCache = new TarLeveledStructureProvider(targetTar);
        } else if (!tarProviderCache.getTarFile().getName().equals(targetTar.getName())) {
            ArchiveFileManipulations.clearProviderCache(shell);
            tarProviderCache = new TarLeveledStructureProvider(targetTar);
        }
        return tarProviderCache;
    }

    protected static void displayErrorDialog(String message, Shell shell) {
        MessageDialog.openError(shell, ArchiveFileManipulations.getErrorDialogTitle(), message);
    }

    protected static String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }
}

