/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;

public class WizardPreferencesImportPage1
extends WizardPreferencesPage {
    protected WizardPreferencesImportPage1(String pageName) {
        super(pageName);
        this.setTitle(PreferencesMessages.WizardPreferencesImportPage1_importTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesImportPage1_importDescription);
    }

    public WizardPreferencesImportPage1() {
        this("preferencesImportPage1");
    }

    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesImportPage1_all;
    }

    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesImportPage1_choose;
    }

    protected PreferenceTransferElement[] getTransfers() {
        if (this.validFromFile()) {
            FileInputStream fis;
            try {
                fis = new FileInputStream(this.getDestinationValue());
            }
            catch (FileNotFoundException e) {
                WorkbenchPlugin.log(e.getMessage(), e);
                return new PreferenceTransferElement[0];
            }
            IPreferencesService service = Platform.getPreferencesService();
            try {
                IExportedPreferences prefs = service.readPreferences(fis);
                PreferenceTransferElement[] transfers = super.getTransfers();
                IPreferenceFilter[] filters = new IPreferenceFilter[transfers.length];
                int i = 0;
                while (i < transfers.length) {
                    PreferenceTransferElement transfer = transfers[i];
                    filters[i] = transfer.getFilter();
                    ++i;
                }
                IPreferenceFilter[] matches = service.matches(prefs, filters);
                PreferenceTransferElement[] returnTransfers = new PreferenceTransferElement[matches.length];
                int index = 0;
                int i2 = 0;
                while (i2 < matches.length) {
                    IPreferenceFilter filter = matches[i2];
                    int j = 0;
                    while (j < transfers.length) {
                        PreferenceTransferElement element = transfers[j];
                        if (element.getFilter().equals(filter)) {
                            returnTransfers[index++] = element;
                        }
                        ++j;
                    }
                    ++i2;
                }
                PreferenceTransferElement[] destTransfers = new PreferenceTransferElement[index];
                System.arraycopy(returnTransfers, 0, destTransfers, 0, index);
                PreferenceTransferElement[] preferenceTransferElementArray = destTransfers;
                return preferenceTransferElementArray;
            }
            catch (CoreException coreException) {
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    WorkbenchPlugin.log(e.getMessage(), e);
                }
            }
        }
        return new PreferenceTransferElement[0];
    }

    private boolean validFromFile() {
        File fromFile = new File(this.getDestinationValue());
        return fromFile.exists() && !fromFile.isDirectory();
    }

    protected void setPreferenceTransfers() {
        super.setPreferenceTransfers();
        if (this.validFromFile() && this.transfersTable.getItemCount() == 0) {
            this.text.setText(PreferencesMessages.WizardPreferences_noSpecificPreferenceDescription);
        } else {
            this.text.setText("");
        }
    }

    protected void createTransferArea(Composite composite) {
        this.createDestinationGroup(composite);
        this.createTransfersList(composite);
    }

    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesImportPage1_file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean transfer(IPreferenceFilter[] filters) {
        File importFile = new File(this.getDestinationValue());
        FileInputStream fis = null;
        try {
            if (filters.length <= 0) return true;
            try {
                fis = new FileInputStream(importFile);
            }
            catch (FileNotFoundException e) {
                WorkbenchPlugin.log(e.getMessage(), e);
                MessageDialog.openError(this.getControl().getShell(), new String(), e.getLocalizedMessage());
                return false;
            }
            IPreferencesService service = Platform.getPreferencesService();
            try {
                IExportedPreferences prefs = service.readPreferences(fis);
                service.applyPreferences(prefs, filters);
                return true;
            }
            catch (CoreException e) {
                WorkbenchPlugin.log(e.getMessage(), e);
                MessageDialog.openError(this.getControl().getShell(), new String(), e.getLocalizedMessage());
                return false;
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    WorkbenchPlugin.log(e.getMessage(), e);
                    MessageDialog.openError(this.getControl().getShell(), new String(), e.getLocalizedMessage());
                }
            }
        }
    }

    public void handleEvent(Event e) {
        if (e.widget == this.destinationNameField) {
            this.setPreferenceTransfers();
        }
        super.handleEvent(e);
    }

    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesImportPage1_title;
    }

    protected int getFileDialogStyle() {
        return 4096;
    }

    protected boolean validDestination() {
        return super.validDestination() && this.validFromFile();
    }

    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesImportPage1_invalidPrefFile;
    }
}

