/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ResourceTransfer
extends ByteArrayTransfer {
    private static final ResourceTransfer instance = new ResourceTransfer();
    private static final String TYPE_NAME = "resource-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = ResourceTransfer.registerType((String)TYPE_NAME);
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();

    private ResourceTransfer() {
    }

    public static ResourceTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IResource[])) {
            return;
        }
        IResource[] resources = (IResource[])data;
        int resourceCount = resources.length;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(resourceCount);
            int i = 0;
            while (i < resources.length) {
                this.writeResource(dataOut, resources[i]);
                ++i;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IResource[] results = new IResource[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readResource(in);
                ++i;
            }
            return results;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IResource readResource(DataInputStream dataIn) throws IOException {
        int type = dataIn.readInt();
        String path = dataIn.readUTF();
        switch (type) {
            case 2: {
                return this.workspace.getRoot().getFolder(new Path(path));
            }
            case 1: {
                return this.workspace.getRoot().getFile(new Path(path));
            }
            case 4: {
                return this.workspace.getRoot().getProject(path);
            }
        }
        throw new IllegalArgumentException("Unknown resource type in ResourceTransfer.readResource");
    }

    private void writeResource(DataOutputStream dataOut, IResource resource) throws IOException {
        dataOut.writeInt(resource.getType());
        dataOut.writeUTF(resource.getFullPath().toString());
    }
}

