/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.bookmarkexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.bookmarkexplorer.BookmarkMessages;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkAction;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkNavigator;
import org.eclipse.ui.views.bookmarkexplorer.BookmarkPropertiesDialog;

class EditBookmarkAction
extends BookmarkAction {
    private IMarker marker;

    protected EditBookmarkAction(BookmarkNavigator view) {
        super(view, BookmarkMessages.Properties_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.bookmark_properties_action_context");
        this.setEnabled(false);
    }

    public void run() {
        if (this.marker != null) {
            this.editBookmark();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.marker = null;
        this.setEnabled(false);
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (!(o instanceof IMarker)) {
            return;
        }
        IMarker selectedMarker = (IMarker)o;
        IResource resource = selectedMarker.getResource();
        if (resource instanceof IFile) {
            this.marker = selectedMarker;
            this.setEnabled(true);
        }
    }

    private void editBookmark() {
        BookmarkPropertiesDialog dialog = new BookmarkPropertiesDialog(this.getView().getSite().getShell());
        dialog.setMarker(this.marker);
        dialog.open();
    }
}

