/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ViewPreferencesAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.FiltersAction;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAdapter;
import org.eclipse.ui.views.markers.internal.MarkerTreeContentProvider;
import org.eclipse.ui.views.markers.internal.MarkerViewLabelProvider;
import org.eclipse.ui.views.markers.internal.TableComparator;
import org.eclipse.ui.views.markers.internal.TableSortAction;
import org.eclipse.ui.views.markers.internal.TableSortDialog;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class TableView
extends ViewPart {
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private static final String TAG_COLUMN_ORDER = "columnOrder";
    private static final String TAG_COLUMN_ORDER_INDEX = "columnOrderIndex";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private TreeViewer viewer;
    private IMemento memento;
    private IAction sortAction;
    private IAction filtersAction;
    private IAction preferencesAction;
    private MarkerTreeContentProvider contentProvider;
    private ISelectionProvider selectionProvider = new MarkerSelectionProviderAdapter();
    static /* synthetic */ Class class$0;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected abstract void viewerSelectionChanged(IStructuredSelection var1);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.createTree(parent));
        this.createColumns(this.viewer.getTree());
        this.viewer.setComparator(this.buildComparator());
        this.setSortIndicators();
        this.contentProvider = new MarkerTreeContentProvider();
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableView.this.viewerSelectionChanged(selection);
            }
        });
        this.createActions();
        this.viewer.setInput(this.createViewerInput());
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        if (bar != null) {
            bar.setSelection(this.restoreVerticalScrollBarPosition(this.memento));
        }
        if ((bar = scrollable.getHorizontalBar()) != null) {
            bar.setSelection(this.restoreHorizontalScrollBarPosition(this.memento));
        }
        MenuManager mgr = this.initContextMenu();
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mgr, this.selectionProvider);
        this.getSite().setSelectionProvider(this.selectionProvider);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.initMenu(actionBars.getMenuManager());
        this.initToolBar(actionBars.getToolBarManager());
        this.registerGlobalActions(this.getViewSite().getActionBars());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TableView.this.handleOpenEvent(event);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableView.this.handleKeyPressed(e);
            }
        });
    }

    abstract Object createViewerInput();

    void setComparator(TableComparator comparator) {
        this.viewer.setComparator(comparator);
        this.updateForNewComparator(comparator);
    }

    void updateForNewComparator(TableComparator comparator) {
        comparator.saveState(this.getDialogSettings());
        this.viewer.refresh();
        this.setSortIndicators();
    }

    protected Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setLinesVisible(true);
        return tree;
    }

    public ColumnPixelData[] getSavedColumnData() {
        ColumnPixelData[] defaultData = this.getDefaultColumnLayouts();
        ColumnPixelData[] result = new ColumnPixelData[defaultData.length];
        int i = 0;
        while (i < defaultData.length) {
            Integer widthInt;
            ColumnPixelData defaultPixelData = defaultData[i];
            boolean addTrim = defaultPixelData.addTrim;
            int width = defaultPixelData.width;
            if (defaultPixelData.resizable && this.memento != null && (widthInt = this.memento.getInteger(TAG_COLUMN_WIDTH + i)) != null && widthInt > 0) {
                width = widthInt;
                addTrim = false;
            }
            result[i] = new ColumnPixelData(width, defaultPixelData.resizable, addTrim);
            ++i;
        }
        return result;
    }

    public ColumnPixelData[] getColumnData() {
        ColumnPixelData[] defaultData = this.getSavedColumnData();
        Tree tree = this.getTree();
        if (tree != null && (tree.isDisposed() || tree.getBounds().width == 0)) {
            tree = null;
        }
        TreeColumn[] column = null;
        if (tree != null) {
            column = tree.getColumns();
        }
        ColumnPixelData[] result = new ColumnPixelData[defaultData.length];
        int i = 0;
        while (i < defaultData.length) {
            TreeColumn col;
            ColumnPixelData defaultPixelData = defaultData[i];
            int width = defaultData[i].width;
            if (column != null && i < column.length && (col = column[i]).getWidth() > 0) {
                width = col.getWidth();
            }
            result[i] = new ColumnPixelData(width, defaultPixelData.resizable, defaultPixelData.addTrim);
            ++i;
        }
        return result;
    }

    protected void createColumns(Tree tree) {
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        IField[] fields = this.getAllFields();
        ColumnPixelData[] columnWidths = this.getSavedColumnData();
        int i = 0;
        while (i < fields.length) {
            layout.addColumnData(columnWidths[i]);
            TreeColumn tc = new TreeColumn(tree, 0, i);
            IField field = fields[i];
            tc.setText(field.getColumnHeaderText());
            tc.setImage(field.getColumnHeaderImage());
            tc.setResizable(columnWidths[i].resizable);
            tc.setMoveable(true);
            tc.addSelectionListener(this.getHeaderListener());
            tc.setData((Object)field);
            TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, tc);
            viewerColumn.setLabelProvider(new MarkerViewLabelProvider(field));
            ++i;
        }
        int[] order = this.restoreColumnOrder(this.memento);
        if (order != null && order.length == fields.length) {
            tree.setColumnOrder(order);
        }
    }

    protected void createActions() {
        if (this.getSortDialog() != null) {
            this.sortAction = new TableSortAction(this, this.getSortDialog());
        }
    }

    protected MenuManager initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableView.this.getViewer().cancelEditing();
                TableView.this.fillContextMenu(mgr);
            }
        });
        return mgr;
    }

    protected abstract void initToolBar(IToolBarManager var1);

    protected void initMenu(IMenuManager menu) {
        if (this.sortAction != null) {
            menu.add(this.sortAction);
        }
        this.addDropDownContributions(menu);
        if (this.filtersAction != null) {
            menu.add(this.filtersAction);
        }
        if (this.preferencesAction != null) {
            menu.add(this.preferencesAction);
        }
    }

    void addDropDownContributions(IMenuManager menu) {
    }

    protected abstract void registerGlobalActions(IActionBars var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    public void setFocus() {
        TreeViewer viewer = this.getViewer();
        if (viewer != null && !((Viewer)viewer).getControl().isDisposed()) {
            ((Viewer)viewer).getControl().setFocus();
        }
    }

    protected ViewerComparator buildComparator() {
        return this.createTableComparator();
    }

    TableComparator createTableComparator() {
        TableComparator sorter = TableComparator.createTableSorter(this.getSortingFields());
        sorter.restoreState(this.getDialogSettings());
        return sorter;
    }

    protected abstract IField[] getSortingFields();

    protected abstract IField[] getAllFields();

    protected abstract IDialogSettings getDialogSettings();

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    protected Tree getTree() {
        return this.getViewer().getTree();
    }

    protected SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.widget;
                IField field = (IField)column.getData();
                try {
                    IWorkbenchSiteProgressService progressService = TableView.this.getProgressService();
                    if (progressService == null) {
                        BusyIndicator.showWhile((Display)TableView.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(this, column, field){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ TreeColumn val$column;
                            private final /* synthetic */ IField val$field;
                            {
                                this.this$1 = var1_1;
                                this.val$column = treeColumn;
                                this.val$field = iField;
                            }

                            public void run() {
                                5.access$0(this.this$1, this.val$column, this.val$field, new NullProgressMonitor());
                            }
                        });
                    } else {
                        TableView.this.getProgressService().busyCursorWhile(new IRunnableWithProgress(this, column, field){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ TreeColumn val$column;
                            private final /* synthetic */ IField val$field;
                            {
                                this.this$1 = var1_1;
                                this.val$column = treeColumn;
                                this.val$field = iField;
                            }

                            public void run(IProgressMonitor monitor) {
                                5.access$0(this.this$1, this.val$column, this.val$field, monitor);
                            }
                        });
                    }
                }
                catch (InvocationTargetException e1) {
                    IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(e1));
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            private void resortTable(TreeColumn column, IField field, IProgressMonitor monitor) {
                TableComparator sorter = TableView.this.getTableSorter();
                monitor.beginTask(MarkerMessages.sortDialog_title, 100);
                monitor.worked(10);
                if (field.equals(sorter.getTopField())) {
                    sorter.reverseTopPriority();
                } else {
                    sorter.setTopPriority(field);
                }
                monitor.worked(15);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this, column){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ TreeColumn val$column;
                    {
                        this.this$1 = var1_1;
                        this.val$column = treeColumn;
                    }

                    public void run() {
                        TableView.access$0(5.access$1(this.this$1)).refresh();
                        5.access$1(this.this$1).updateDirectionIndicator(this.val$column);
                    }
                });
                monitor.done();
            }

            static /* synthetic */ void access$0(5 var0, TreeColumn treeColumn, IField iField, IProgressMonitor iProgressMonitor) {
                var0.resortTable(treeColumn, iField, iProgressMonitor);
            }

            static /* synthetic */ TableView access$1(5 var0) {
                return var0.TableView.this;
            }
        };
    }

    protected ColumnPixelData[] getDefaultColumnLayouts() {
        IField[] fields = this.getAllFields();
        ColumnPixelData[] datas = new ColumnPixelData[fields.length];
        int i = 0;
        while (i < fields.length) {
            int width = this.getWidth(fields[i]);
            boolean resizable = width > 0;
            datas[i] = new ColumnPixelData(width, resizable, resizable);
            ++i;
        }
        return datas;
    }

    private int getWidth(IField field) {
        if (!field.isShowing()) {
            return 0;
        }
        return field.getPreferredWidth();
    }

    protected TableSortDialog getSortDialog() {
        return new TableSortDialog(this.getSite(), this.getTableSorter());
    }

    TableComparator getTableSorter() {
        return (TableComparator)this.viewer.getComparator();
    }

    protected abstract void handleKeyPressed(KeyEvent var1);

    protected abstract void handleOpenEvent(OpenEvent var1);

    public void saveState(IMemento memento) {
        super.saveState(memento);
        ColumnPixelData[] data = this.getColumnData();
        int i = 0;
        while (i < data.length) {
            ColumnPixelData data2 = data[i];
            memento.putInteger(TAG_COLUMN_WIDTH + i, data2.width);
            ++i;
        }
        Tree tree = this.getTree();
        int[] columnOrder = tree.getColumnOrder();
        int i2 = 0;
        while (i2 < columnOrder.length) {
            IMemento child = memento.createChild(TAG_COLUMN_ORDER);
            child.putInteger(TAG_COLUMN_ORDER_INDEX, columnOrder[i2]);
            ++i2;
        }
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_VERTICAL_POSITION, position);
        bar = scrollable.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_HORIZONTAL_POSITION, position);
    }

    private int[] restoreColumnOrder(IMemento memento) {
        if (memento == null) {
            return null;
        }
        IMemento[] children = memento.getChildren(TAG_COLUMN_ORDER);
        if (children != null) {
            int n = children.length;
            int[] values = new int[n];
            int i = 0;
            while (i < n) {
                Integer val = children[i].getInteger(TAG_COLUMN_ORDER_INDEX);
                if (val == null) {
                    return null;
                }
                values[i] = val;
                ++i;
            }
            return values;
        }
        return null;
    }

    private int restoreVerticalScrollBarPosition(IMemento memento) {
        if (memento == null) {
            return 0;
        }
        Integer position = memento.getInteger(TAG_VERTICAL_POSITION);
        return position == null ? 0 : position;
    }

    private int restoreHorizontalScrollBarPosition(IMemento memento) {
        if (memento == null) {
            return 0;
        }
        Integer position = memento.getInteger(TAG_HORIZONTAL_POSITION);
        return position == null ? 0 : position;
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchSiteProgressService service = null;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter(clazz)) != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    void setFilterAction(FiltersAction action) {
        this.filtersAction = action;
    }

    IAction getFilterAction() {
        return this.filtersAction;
    }

    IAction getPreferencesAction() {
        return this.preferencesAction;
    }

    void setPreferencesAction(ViewPreferencesAction preferencesAction) {
        this.preferencesAction = preferencesAction;
    }

    MarkerTreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public Object getViewerInput() {
        return this.getViewer().getInput();
    }

    void setSortIndicators() {
        IField top = this.getTableSorter().getTopField();
        TreeColumn[] columns = this.getViewer().getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn column = columns[i];
            if (column.getData().equals(top)) {
                this.updateDirectionIndicator(column);
                return;
            }
            ++i;
        }
    }

    void updateDirectionIndicator(TreeColumn column) {
        this.getViewer().getTree().setSortColumn(column);
        if (this.getTableSorter().getTopPriorityDirection() == 1) {
            this.getViewer().getTree().setSortDirection(128);
        } else {
            this.getViewer().getTree().setSortDirection(1024);
        }
    }

    protected void setSelection(IStructuredSelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    static /* synthetic */ TreeViewer access$0(TableView tableView) {
        return tableView.viewer;
    }
}

