/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class MarkCompletedAction
extends TaskAction {
    protected MarkCompletedAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.mark_completed_action_context");
    }

    public void run() {
        ISelection selectedMarkers = this.getTaskList().getSelection();
        if (selectedMarkers instanceof IStructuredSelection) {
            Iterator selections = ((IStructuredSelection)selectedMarkers).iterator();
            ArrayList markers = new ArrayList();
            while (selections.hasNext()) {
                Object marker = selections.next();
                if (!(marker instanceof IMarker)) continue;
                markers.add(marker);
            }
            HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
            attrs.put("done", Boolean.TRUE);
            UpdateMarkersOperation op = new UpdateMarkersOperation(markers.toArray(new IMarker[markers.size()]), attrs, this.getText(), true);
            this.execute(op, this.getText(), null, null);
        }
    }

    public boolean shouldEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            IMarker marker = (IMarker)i.next();
            if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker") && !MarkerUtil.isComplete(marker) && MarkerUtil.isEditable(marker)) continue;
            return false;
        }
        return true;
    }
}

