/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public final class SiteTypeFactory {
    public static final String SIMPLE_EXTENSION_ID = "siteTypes";
    private static SiteTypeFactory inst;
    private Map factories;

    private SiteTypeFactory() {
    }

    public static SiteTypeFactory getInstance() {
        if (inst == null) {
            inst = new SiteTypeFactory();
        }
        return inst;
    }

    public ISiteFactory getFactory(String type) throws CoreException {
        Object instance = this.getFactories().get(type);
        if (instance == null) {
            instance = this.createFactoryFor(type);
            this.getFactories().put(type, instance);
        }
        return (ISiteFactory)instance;
    }

    private ISiteFactory createFactoryFor(String type) throws CoreException {
        ISiteFactory result = null;
        String pluginID = UpdateCore.getPlugin().getBundle().getSymbolicName();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(pluginID, SIMPLE_EXTENSION_ID, type);
        if (elements == null || elements.length == 0) {
            throw Utilities.newCoreException(NLS.bind(Messages.SiteTypeFactory_UnableToFindSiteFactory, new String[]{type}), null);
        }
        IConfigurationElement element = elements[0];
        result = (ISiteFactory)element.createExecutableExtension("class");
        return result;
    }

    private Map getFactories() {
        if (this.factories == null) {
            this.factories = new HashMap();
        }
        return this.factories;
    }
}

