/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.views.ConfigurationView;
import org.eclipse.update.ui.UpdateJob;

public class ConfigurationManagerWindow
extends ApplicationWindow {
    private ConfigurationView view;
    private GlobalAction propertiesAction;
    private IAction propertiesActionHandler;
    private IJobChangeListener jobListener;
    private Hashtable jobNames;

    public ConfigurationManagerWindow(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.addMenuBar();
        this.addActions();
        this.addToolBar(0x800000);
        this.addStatusLine();
    }

    public boolean isProgressCanceled() {
        return this.getStatusLineManager().getProgressMonitor().isCanceled();
    }

    private void addActions() {
        MenuManager menuBar = this.getMenuBarManager();
        MenuManager fileMenu = new MenuManager(UpdateUIMessages.ConfigurationManagerWindow_fileMenu);
        menuBar.add(fileMenu);
        this.propertiesAction = new GlobalAction();
        this.propertiesAction.setText(UpdateUIMessages.ConfigurationManagerWindow_properties);
        this.propertiesAction.setEnabled(false);
        fileMenu.add(this.propertiesAction);
        fileMenu.add(new Separator());
        Action closeAction = new Action(){

            public void run() {
                ConfigurationManagerWindow.this.close();
            }
        };
        closeAction.setText(UpdateUIMessages.ConfigurationManagerWindow_close);
        fileMenu.add(closeAction);
    }

    private void hookGlobalActions() {
        if (this.propertiesActionHandler != null) {
            this.propertiesAction.setActionHandler(this.propertiesActionHandler);
        }
    }

    protected Control createContents(Composite parent) {
        this.view = new ConfigurationView(this);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        this.addSeparator(container);
        this.view.createPartControl(container);
        Control viewControl = this.view.getControl();
        GridData gd = new GridData(1808);
        viewControl.setLayoutData((Object)gd);
        this.addSeparator(container);
        this.hookGlobalActions();
        this.updateActionBars();
        UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
        this.getShell().setImage(provider.get(UpdateUIImages.DESC_CONFIGS_VIEW, 0));
        return container;
    }

    public void updateStatusLine(String message, Image image) {
        this.getStatusLineManager().setMessage(image, message);
        this.getStatusLineManager().update(true);
    }

    public void trackUpdateJob(Job job, String name) {
        if (this.jobListener == null) {
            this.jobNames = new Hashtable();
            this.jobListener = new IJobChangeListener(){

                public void aboutToRun(IJobChangeEvent event) {
                }

                public void awake(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    Job job = event.getJob();
                    if (job.belongsTo(UpdateJob.FAMILY)) {
                        Job[] remaining = Job.getJobManager().find(UpdateJob.FAMILY);
                        ConfigurationManagerWindow.this.updateProgress(false, remaining);
                        ConfigurationManagerWindow.this.jobNames.remove(job);
                    }
                }

                public void running(IJobChangeEvent event) {
                    Job job = event.getJob();
                    if (job.belongsTo(UpdateJob.FAMILY)) {
                        Job[] existing = Job.getJobManager().find(UpdateJob.FAMILY);
                        ConfigurationManagerWindow.this.updateProgress(true, existing);
                    }
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void sleeping(IJobChangeEvent event) {
                }
            };
            Job.getJobManager().addJobChangeListener(this.jobListener);
        }
        this.jobNames.put(job, name);
    }

    private void updateProgress(final boolean begin, final Job[] jobs) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IProgressMonitor monitor = ConfigurationManagerWindow.this.getStatusLineManager().getProgressMonitor();
                if (begin) {
                    if (jobs.length == 1) {
                        monitor.beginTask("", -1);
                    }
                    ConfigurationManagerWindow.this.updateTaskName(monitor, jobs);
                    ConfigurationManagerWindow.this.getStatusLineManager().setCancelEnabled(true);
                } else if (jobs.length == 0) {
                    ConfigurationManagerWindow.this.getStatusLineManager().setCancelEnabled(false);
                    monitor.done();
                } else {
                    ConfigurationManagerWindow.this.updateTaskName(monitor, jobs);
                }
                ConfigurationManagerWindow.this.getStatusLineManager().update(true);
            }
        });
    }

    private void updateTaskName(IProgressMonitor monitor, Job[] jobs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < jobs.length) {
            String name = (String)this.jobNames.get(jobs[i]);
            if (name != null) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(name);
            }
            ++i;
        }
        monitor.subTask(NLS.bind(UpdateUIMessages.ConfigurationManagerWindow_searchTaskName, buf.toString()));
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(256);
        gd.heightHint = 1;
        separator.setLayoutData((Object)gd);
    }

    private void updateActionBars() {
        this.getMenuBarManager().updateAll(false);
        this.getToolBarManager().update(false);
        this.getStatusLineManager().update(false);
    }

    public boolean close() {
        if (this.jobListener != null) {
            Job.getJobManager().removeJobChangeListener(this.jobListener);
        }
        if (this.view != null) {
            this.view.dispose();
        }
        return super.close();
    }

    public void create() {
        super.create();
        this.getShell().setText(UpdateUIMessages.ConfigurationManagerAction_title);
        this.getShell().setSize(800, 600);
    }

    public int open() {
        this.updateActionBars();
        return super.open();
    }

    public void setPropertiesActionHandler(IAction handler) {
        this.propertiesActionHandler = handler;
    }

    class GlobalAction
    extends Action
    implements IPropertyChangeListener {
        private IAction handler;

        public void setActionHandler(IAction action) {
            if (this.handler != null) {
                this.handler.removePropertyChangeListener(this);
                this.handler = null;
            }
            if (action != null) {
                this.handler = action;
                action.addPropertyChangeListener(this);
            }
            if (this.handler != null) {
                this.setEnabled(this.handler.isEnabled());
                this.setChecked(this.handler.isChecked());
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setEnabled(bool);
            } else if (event.getProperty().equals("checked")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setChecked(bool);
            }
        }

        public void run() {
            if (this.handler != null) {
                this.handler.run();
            }
        }
    }
}

