/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.operations.OperationsManager;

public class NewExtensionLocationAction
extends Action {
    private Shell shell;

    public NewExtensionLocationAction(Shell shell, String text, ImageDescriptor desc) {
        super(text, desc);
        this.shell = shell;
    }

    public void run() {
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            ErrorDialog.openError(this.shell, null, null, status);
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.shell, 65536);
        dialog.setMessage(UpdateUIMessages.NewExtensionLocationAction_selectExtLocation);
        String dir = dialog.open();
        while (dir != null) {
            File dirFile = NewExtensionLocationAction.getExtensionSite(new File(dir));
            if (dirFile != null) {
                if (this.addExtensionLocation(dirFile)) {
                    return;
                }
                dialog.setFilterPath(dir);
                dir = dialog.open();
                continue;
            }
            MessageDialog.openInformation(this.shell, UpdateUIMessages.NewExtensionLocationAction_extInfoTitle, UpdateUIMessages.NewExtensionLocationAction_extInfoMessage);
            dialog.setFilterPath(dir);
            dir = dialog.open();
        }
    }

    static File getExtensionSite(File directory) {
        File site;
        if (directory.getName().equals("eclipse") && (site = NewExtensionLocationAction.getExtensionSite(directory.getParentFile())) != null) {
            return directory;
        }
        File eclipse = new File(directory, "eclipse");
        if (!eclipse.exists() || !eclipse.isDirectory()) {
            return null;
        }
        File marker = new File(eclipse, ".eclipseextension");
        if (!marker.exists() || marker.isDirectory()) {
            return null;
        }
        return eclipse;
    }

    private boolean addExtensionLocation(File dir) {
        try {
            IInstallConfiguration config = SiteManager.getLocalSite().getCurrentConfiguration();
            IConfiguredSite csite = config.createLinkedConfiguredSite(dir);
            csite.verifyUpdatableStatus();
            config.addConfiguredSite(csite);
            boolean restartNeeded = SiteManager.getLocalSite().save();
            UpdateUI.requestRestart(restartNeeded);
            return true;
        }
        catch (CoreException e) {
            String title = UpdateUIMessages.InstallWizard_TargetPage_location_error_title;
            ErrorDialog.openError(this.shell, title, null, e.getStatus());
            UpdateUI.logException(e, false);
            return false;
        }
    }
}

