/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.savvytestnature;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.ISavvytestWizardPage;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DefaultSavvytestWizardPage
extends WizardPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.savvytestnature.DefaultSavvytestWizardPage.";
    public static final String DEFAULT_PAGE_DESCRIPTION = DefaultSavvytestWizardPage.getClassString("defaultpagedescription");
    private IProject project = null;
    private String savvytestName = null;
    private String savvytestAlias = null;
    private String savvytestDescription = null;
    private ListViewer projectViewer = null;
    private Text savvytestNameText = null;
    private Text savvytestAliasText = null;
    private Text savvytestDescText = null;
    private boolean hideProject = false;
    private ISavvytestWizardPage savvytestpage = null;

    protected static String getString(String key) {
        return Savvytest.getString(key, new Object[0]);
    }

    private static String getClassString(String key) {
        return DefaultSavvytestWizardPage.getString(TRANSLATION_PREFIX + key);
    }

    public static void displayFileCreationErrorMessage(Shell shell) {
        MessageBox box = new MessageBox(shell, 33);
        box.setMessage(DefaultSavvytestWizardPage.getClassString("error.filecreationmsg"));
        box.setText(DefaultSavvytestWizardPage.getClassString("error.filecreationtitle"));
        box.open();
    }

    public DefaultSavvytestWizardPage(String pageName) {
        super(pageName);
    }

    @Override
    public void createControl(Composite parent) {
        IWizardPage page;
        final WizardPageValidator validator = new WizardPageValidator(this){

            @Override
            protected String internalValidate() {
                if (DefaultSavvytestWizardPage.this.savvytestName == null || DefaultSavvytestWizardPage.this.savvytestName.length() == 0) {
                    return DefaultSavvytestWizardPage.getClassString("error.name");
                }
                if (DefaultSavvytestWizardPage.this.project == null) {
                    return DefaultSavvytestWizardPage.getClassString("error.project");
                }
                return null;
            }
        };
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        Group nameGroup = new Group(main, 16);
        nameGroup.setText(DefaultSavvytestWizardPage.getClassString("namegroup"));
        nameGroup.setLayout((Layout)new FillLayout());
        nameGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        nameGroup.setFont(font);
        Group aliasGroup = new Group(main, 16);
        aliasGroup.setText(DefaultSavvytestWizardPage.getClassString("aliasgroup"));
        aliasGroup.setLayout((Layout)new FillLayout());
        aliasGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        aliasGroup.setFont(font);
        Group descGroup = new Group(main, 16);
        descGroup.setText(DefaultSavvytestWizardPage.getClassString("descgroup"));
        descGroup.setLayout((Layout)new FillLayout());
        descGroup.setLayoutData((Object)GridDataCreator.fill());
        descGroup.setFont(font);
        Group projectGroup = null;
        if (!this.hideProject) {
            projectGroup = new Group(main, 16);
            projectGroup.setText(DefaultSavvytestWizardPage.getClassString("projectgroup"));
            projectGroup.setLayout((Layout)new FillLayout());
            projectGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
            projectGroup.setFont(font);
        }
        this.savvytestNameText = new Text((Composite)nameGroup, 2052);
        this.savvytestNameText.setFont(font);
        this.savvytestNameText.setForeground(color);
        if (this.savvytestName != null) {
            this.savvytestNameText.setText(this.savvytestName);
        }
        this.savvytestNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String oldName = DefaultSavvytestWizardPage.this.savvytestName;
                DefaultSavvytestWizardPage.this.savvytestName = DefaultSavvytestWizardPage.this.savvytestNameText.getText();
                validator.validate();
                DefaultSavvytestWizardPage.this.nameChanged(DefaultSavvytestWizardPage.this.savvytestName, oldName);
            }
        });
        this.savvytestAliasText = new Text((Composite)aliasGroup, 2052);
        this.savvytestAliasText.setFont(font);
        this.savvytestAliasText.setForeground(color);
        if (this.savvytestAlias != null) {
            this.savvytestAliasText.setText(this.savvytestAlias);
        }
        this.savvytestAliasText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DefaultSavvytestWizardPage.this.savvytestAlias = DefaultSavvytestWizardPage.this.savvytestAliasText.getText();
            }
        });
        this.savvytestDescText = new Text((Composite)descGroup, 2626);
        this.savvytestDescText.setFont(font);
        this.savvytestDescText.setForeground(color);
        if (this.savvytestDescription != null) {
            this.savvytestDescText.setText(this.savvytestDescription);
        }
        this.savvytestDescText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DefaultSavvytestWizardPage.this.savvytestDescription = DefaultSavvytestWizardPage.this.savvytestDescText.getText();
            }
        });
        ((GridData)descGroup.getLayoutData()).heightHint = this.savvytestDescText.computeSize((int)-1, (int)-1).y * 4;
        if (!this.hideProject) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IProject> savvyProjects = new ArrayList<IProject>(projects.length);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (proj.isAccessible() && Savvytest.hasSavvytestNature(proj)) {
                    savvyProjects.add(proj);
                }
                ++n2;
            }
            this.projectViewer = new ListViewer((Composite)projectGroup);
            this.projectViewer.getList().setFont(font);
            this.projectViewer.getList().setForeground(color);
            this.projectViewer.setLabelProvider(new LabelProvider(){

                @Override
                public String getText(Object element) {
                    return ((IProject)element).getName();
                }
            });
            this.projectViewer.setContentProvider(new ArrayContentProvider());
            this.projectViewer.setComparator(new ViewerComparator());
            this.projectViewer.setInput(savvyProjects);
            this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                @Override
                public void selectionChanged(SelectionChangedEvent event) {
                    IProject oldProject = DefaultSavvytestWizardPage.this.project;
                    if (!event.getSelection().isEmpty()) {
                        StructuredSelection sel = (StructuredSelection)event.getSelection();
                        DefaultSavvytestWizardPage.this.project = (IProject)sel.getFirstElement();
                    } else {
                        DefaultSavvytestWizardPage.this.project = null;
                    }
                    validator.validate();
                    DefaultSavvytestWizardPage.this.projectChanged(DefaultSavvytestWizardPage.this.project, oldProject);
                }
            });
        }
        if ((page = this.getNextPage()) instanceof ISavvytestWizardPage) {
            this.savvytestpage = (ISavvytestWizardPage)((Object)page);
        }
        main.pack();
        this.setControl((Control)main);
        validator.validate();
        validator.setDisplayError(true);
    }

    public void setProject(IProject project) {
        IProject oldProject = project;
        this.project = project;
        if (this.savvytestpage != null) {
            this.savvytestpage.updateProject(project);
            this.projectChanged(project, oldProject);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setSavvytestName(String savvytestName) {
        String oldName = savvytestName;
        this.savvytestName = savvytestName;
        if (savvytestName == null) {
            this.savvytestName = "";
        }
        if (this.savvytestNameText != null) {
            this.savvytestNameText.setText(savvytestName);
            this.nameChanged(savvytestName, oldName);
        }
    }

    public String getSavvytestName() {
        return this.savvytestName;
    }

    public void setSavvytestAlias(String savvytestAlias) {
        this.savvytestAlias = savvytestAlias;
        if (savvytestAlias == null) {
            this.savvytestAlias = "";
        }
        if (this.savvytestAliasText != null) {
            this.savvytestAliasText.setText(this.savvytestAlias);
        }
    }

    public String getSavvytestAlias() {
        return this.savvytestAlias;
    }

    public void setSavvytestDescription(String savvytestDescription) {
        this.savvytestDescription = savvytestDescription;
        if (savvytestDescription == null) {
            this.savvytestDescription = "";
        }
        if (this.savvytestDescText != null) {
            this.savvytestDescText.setText(this.savvytestDescription);
        }
    }

    public String getSavvytestDescription() {
        return this.savvytestDescription;
    }

    public void setHideProject(boolean hideProject) {
        this.hideProject = hideProject;
    }

    public boolean isHideProject() {
        return this.hideProject;
    }

    protected void projectChanged(IProject project, IProject oldProject) {
        if (this.savvytestpage != null) {
            this.savvytestpage.updateProject(project);
        }
    }

    protected void nameChanged(String name, String oldName) {
        if (this.savvytestpage != null) {
            this.savvytestpage.updateName(name);
        }
    }
}

