/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;

class ChangeManager {
    ListenerList[] listenerLists = null;
    Object[] listenerTypes = null;
    private Realm realm;

    ChangeManager(Realm realm) {
        Assert.isNotNull(realm);
        this.realm = realm;
    }

    protected void addListener(Object listenerType, IObservablesListener listener) {
        int listenerTypeIndex = this.findListenerTypeIndex(listenerType);
        if (listenerTypeIndex == -1) {
            int length;
            if (this.listenerTypes == null) {
                length = 0;
                this.listenerTypes = new Object[1];
                this.listenerLists = new ListenerList[1];
            } else {
                length = this.listenerTypes.length;
                this.listenerTypes = new Object[length + 1];
                System.arraycopy(this.listenerTypes, 0, this.listenerTypes, 0, length);
                this.listenerLists = new ListenerList[length + 1];
                System.arraycopy(this.listenerLists, 0, this.listenerLists, 0, length);
            }
            this.listenerTypes[length] = listenerType;
            this.listenerLists[length] = new ListenerList();
            boolean hadListeners = this.hasListeners();
            this.listenerLists[length].add(listener);
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        ListenerList listenerList = this.listenerLists[listenerTypeIndex];
        boolean hadListeners = true;
        if (listenerList.size() == 0) {
            hadListeners = this.hasListeners();
        }
        listenerList.add(listener);
        if (!hadListeners) {
            this.firstListenerAdded();
        }
    }

    protected void removeListener(Object listenerType, IObservablesListener listener) {
        int listenerTypeIndex = this.findListenerTypeIndex(listenerType);
        if (listenerTypeIndex != -1) {
            this.listenerLists[listenerTypeIndex].remove(listener);
            if (this.listenerLists[listenerTypeIndex].size() == 0 && !this.hasListeners()) {
                this.lastListenerRemoved();
            }
        }
    }

    protected boolean hasListeners() {
        if (this.listenerTypes == null) {
            return false;
        }
        int i = 0;
        while (i < this.listenerTypes.length) {
            if (this.listenerLists[i].size() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findListenerTypeIndex(Object listenerType) {
        if (this.listenerTypes != null) {
            int i = 0;
            while (i < this.listenerTypes.length) {
                if (this.listenerTypes[i] == listenerType) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void fireEvent(ObservableEvent event) {
        Object listenerType = event.getListenerType();
        int listenerTypeIndex = this.findListenerTypeIndex(listenerType);
        if (listenerTypeIndex != -1) {
            Object[] listeners = this.listenerLists[listenerTypeIndex].getListeners();
            int i = 0;
            while (i < listeners.length) {
                event.dispatch((IObservablesListener)listeners[i]);
                ++i;
            }
        }
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public void dispose() {
        this.listenerLists = null;
        this.listenerTypes = null;
        this.realm = null;
    }

    public Realm getRealm() {
        return this.realm;
    }
}

