/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;

public class OpenPerspectiveDialogAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public OpenPerspectiveDialogAction(IWorkbenchWindow window) {
        Assert.isNotNull(window);
        this.workbenchWindow = window;
        this.setText(WorkbenchMessages.OpenPerspectiveDialogAction_text);
        this.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE"));
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(this.workbenchWindow.getShell(), this.workbenchWindow.getWorkbench().getPerspectiveRegistry());
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor desc = dlg.getSelection();
        if (desc != null) {
            try {
                IWorkbench workbench = this.workbenchWindow.getWorkbench();
                IAdaptable input = ((Workbench)workbench).getDefaultPageInput();
                this.workbenchWindow.openPage(desc.getId(), input);
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log("Error opening perspective ", e);
            }
        }
    }

    public void dispose() {
        this.workbenchWindow = null;
    }
}

