/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutFeaturesButtonManager;
import org.eclipse.ui.internal.dialogs.AboutFeaturesDialog;
import org.eclipse.ui.internal.dialogs.AboutPluginsDialog;
import org.eclipse.ui.internal.dialogs.AboutSystemDialog;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;

public class AboutDialog
extends ProductInfoDialog {
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private static final int FEATURES_ID = 1025;
    private static final int PLUGINS_ID = 1026;
    private static final int INFO_ID = 1027;
    private String productName;
    private IProduct product;
    private AboutBundleGroupData[] bundleGroupInfos;
    private ArrayList images = new ArrayList();
    private AboutFeaturesButtonManager buttonManager = new AboutFeaturesButtonManager();
    private StyledText text;

    public AboutDialog(Shell parentShell) {
        super(parentShell);
        this.product = Platform.getProduct();
        if (this.product != null) {
            this.productName = this.product.getName();
        }
        if (this.productName == null) {
            this.productName = WorkbenchMessages.AboutDialog_defaultProductName;
        }
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupData> groups = new LinkedList<AboutBundleGroupData>();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                int j = 0;
                while (j < bundleGroups.length) {
                    groups.add(new AboutBundleGroupData(bundleGroups[j]));
                    ++j;
                }
                ++i;
            }
        }
        this.bundleGroupInfos = groups.toArray(new AboutBundleGroupData[0]);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                new AboutFeaturesDialog(this.getShell(), this.productName, this.bundleGroupInfos).open();
                break;
            }
            case 1026: {
                new AboutPluginsDialog(this.getShell(), this.productName).open();
                break;
            }
            case 1027: {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    public void run() {
                        new AboutSystemDialog(AboutDialog.this.getShell()).open();
                    }
                });
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    public boolean close() {
        int i = 0;
        while (i < this.images.size()) {
            Image image = (Image)this.images.get(i);
            image.dispose();
            ++i;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind(WorkbenchMessages.AboutDialog_shellTitle, this.productName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        if (this.bundleGroupInfos != null && this.bundleGroupInfos.length > 0) {
            this.createButton(parent, 1025, WorkbenchMessages.AboutDialog_featureInfo, false);
        }
        this.createButton(parent, 1026, WorkbenchMessages.AboutDialog_pluginInfo, false);
        this.createButton(parent, 1027, WorkbenchMessages.AboutDialog_systemInfo, false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        final Cursor hand = new Cursor((Device)parent.getDisplay(), 21);
        final Cursor busy = new Cursor((Device)parent.getDisplay(), 1);
        this.setHandCursor(hand);
        this.setBusyCursor(busy);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AboutDialog.this.setHandCursor(null);
                hand.dispose();
                AboutDialog.this.setBusyCursor(null);
                busy.dispose();
            }
        });
        Image aboutImage = null;
        if (this.product != null) {
            String aboutText;
            ImageDescriptor imageDescriptor = ProductProperties.getAboutImage(this.product);
            if (imageDescriptor != null) {
                aboutImage = imageDescriptor.createImage();
            }
            if ((aboutImage == null || aboutImage.getBounds().width <= 250) && (aboutText = ProductProperties.getAboutText(this.product)) != null) {
                this.setItem(this.scan(aboutText));
            }
            if (aboutImage != null) {
                this.images.add(aboutImage);
            }
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground(parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground(parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = aboutImage == null || this.getItem() == null ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        topContainer.setLayoutData((Object)data);
        if (aboutImage != null) {
            Label imageLabel = new Label(topContainer, 0);
            imageLabel.setBackground(background);
            imageLabel.setForeground(foreground);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(aboutImage);
        }
        if (this.getItem() != null) {
            Composite textContainer = new Composite(topContainer, 0);
            textContainer.setBackground(background);
            textContainer.setForeground(foreground);
            layout = new GridLayout();
            layout.numColumns = 1;
            textContainer.setLayout((Layout)layout);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            textContainer.setLayoutData((Object)data);
            this.text = new StyledText(textContainer, 10);
            this.text.setCaret(null);
            this.text.setFont(parent.getFont());
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            this.text.setText(this.getItem().getText());
            this.text.setLayoutData((Object)data);
            this.text.setCursor(null);
            this.text.setBackground(background);
            this.text.setForeground(foreground);
            this.setLinkRanges(this.text, this.getItem().getLinkRanges());
            this.addListeners(this.text);
        }
        Label bar = new Label(workArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite bottom = (Composite)super.createDialogArea(workArea);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(1808));
        this.createFeatureImageButtonRow(bottom);
        bar = new Label(bottom, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return workArea;
    }

    private void createFeatureImageButtonRow(Composite parent) {
        Composite featureContainer = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        featureContainer.setLayout((Layout)rowLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        featureContainer.setLayoutData((Object)data);
        int i = 0;
        while (i < this.bundleGroupInfos.length) {
            this.createFeatureButton(featureContainer, this.bundleGroupInfos[i]);
            ++i;
        }
    }

    private Button createFeatureButton(Composite parent, final AboutBundleGroupData info) {
        if (!this.buttonManager.add(info)) {
            return null;
        }
        ImageDescriptor desc = info.getFeatureImage();
        Image featureImage = null;
        Button button = new Button(parent, 0x800008);
        button.setData((Object)info);
        featureImage = desc.createImage();
        this.images.add(featureImage);
        button.setImage(featureImage);
        button.setToolTipText(info.getProviderName());
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = info.getProviderName();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AboutBundleGroupData[] groupInfos = AboutDialog.this.buttonManager.getRelatedInfos(info);
                AboutBundleGroupData selection = (AboutBundleGroupData)event.widget.getData();
                AboutFeaturesDialog d = new AboutFeaturesDialog(AboutDialog.this.getShell(), AboutDialog.this.productName, groupInfos);
                d.setInitialSelection(selection);
                d.open();
            }
        });
        return button;
    }
}

