/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileExportOperation;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceExportPage1;

public class WizardArchiveFileResourceExportPage1
extends WizardFileSystemResourceExportPage1 {
    protected Button compressContentsCheckbox;
    private Button zipFormatButton;
    private Button targzFormatButton;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardZipFileResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardZipFileResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_COMPRESS_CONTENTS_ID = "WizardZipFileResourceExportPage1.STORE_COMPRESS_CONTENTS_ID";

    protected WizardArchiveFileResourceExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardArchiveFileResourceExportPage1(IStructuredSelection selection) {
        this("zipFileExportPage1", selection);
        this.setTitle(DataTransferMessages.ArchiveExport_exportTitle);
        this.setDescription(DataTransferMessages.ArchiveExport_description);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.zip_file_export_wizard_page");
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        optionsGroup.setLayout((Layout)new GridLayout(2, true));
        Composite left = new Composite((Composite)optionsGroup, 0);
        left.setLayoutData((Object)new GridData(16384, 128, true, false));
        left.setLayout((Layout)new GridLayout(1, true));
        this.createFileFormatOptions(left, font);
        this.compressContentsCheckbox = new Button(left, 16416);
        this.compressContentsCheckbox.setText(DataTransferMessages.ZipExport_compressContents);
        this.compressContentsCheckbox.setFont(font);
        Composite right = new Composite((Composite)optionsGroup, 0);
        right.setLayoutData((Object)new GridData(16384, 128, true, false));
        right.setLayout((Layout)new GridLayout(1, true));
        this.createDirectoryStructureOptions(right, font);
        this.createDirectoryStructureButton.setSelection(true);
        this.createSelectionOnlyButton.setSelection(false);
        this.compressContentsCheckbox.setSelection(true);
    }

    protected void createFileFormatOptions(Composite optionsGroup, Font font) {
        this.zipFormatButton = new Button(optionsGroup, 16400);
        this.zipFormatButton.setText(DataTransferMessages.ArchiveExport_saveInZipFormat);
        this.zipFormatButton.setSelection(true);
        this.zipFormatButton.setFont(font);
        this.targzFormatButton = new Button(optionsGroup, 16400);
        this.targzFormatButton.setText(DataTransferMessages.ArchiveExport_saveInTarFormat);
        this.targzFormatButton.setSelection(false);
        this.targzFormatButton.setFont(font);
    }

    protected boolean ensureTargetDirectoryIsValid(String fullPathname) {
        int separatorIndex = fullPathname.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        return this.ensureTargetIsValid(new File(fullPathname.substring(0, separatorIndex)));
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.ZipExport_mustBeFile);
            this.giveFocusToDestination();
            return false;
        }
        if (targetFile.exists()) {
            if (targetFile.canWrite()) {
                if (!this.queryYesNoQuestion(DataTransferMessages.ZipExport_alreadyExists)) {
                    return false;
                }
            } else {
                this.displayErrorDialog(DataTransferMessages.ZipExport_alreadyExistsError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String targetPath = this.getDestinationValue();
        if (!this.ensureTargetDirectoryIsValid(targetPath)) {
            return false;
        }
        return this.ensureTargetFileIsValid(new File(targetPath));
    }

    protected boolean executeExportOperation(ArchiveFileExportOperation op) {
        op.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        op.setUseCompression(this.compressContentsCheckbox.getSelection());
        op.setUseTarFormat(this.targzFormatButton.getSelection());
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError(this.getContainer().getShell(), DataTransferMessages.DataTransfer_exportProblems, null, status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        List resourcesToExport = this.getWhiteCheckedResources();
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        this.saveDirtyEditors();
        this.saveWidgetValues();
        return this.executeExportOperation(new ArchiveFileExportOperation(null, resourcesToExport, this.getDestinationValue()));
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.ArchiveExport_destinationLabel;
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected String getOutputSuffix() {
        if (this.zipFormatButton.getSelection()) {
            return ".zip";
        }
        if (this.compressContentsCheckbox.getSelection()) {
            return ".tar.gz";
        }
        return ".tar";
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.zip;*.tar.gz;*.tar;*.tgz", "*.*"});
        dialog.setText(DataTransferMessages.ArchiveExport_selectDestinationTitle);
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedFileName);
        }
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
            settings.put(STORE_COMPRESS_CONTENTS_ID, this.compressContentsCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            boolean setStructure = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(setStructure);
            this.createSelectionOnlyButton.setSelection(!setStructure);
            this.compressContentsCheckbox.setSelection(settings.getBoolean(STORE_COMPRESS_CONTENTS_ID));
        }
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.ArchiveExport_destinationEmpty;
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.endsWith(".tar")) {
            this.compressContentsCheckbox.setSelection(false);
            this.targzFormatButton.setSelection(true);
            this.zipFormatButton.setSelection(false);
        } else if (destinationValue.endsWith(".tar.gz") || destinationValue.endsWith(".tgz")) {
            this.compressContentsCheckbox.setSelection(true);
            this.targzFormatButton.setSelection(true);
            this.zipFormatButton.setSelection(false);
        } else if (destinationValue.endsWith(".zip")) {
            this.zipFormatButton.setSelection(true);
            this.targzFormatButton.setSelection(false);
        }
        return super.validateDestinationGroup();
    }
}

