/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerResolutionDialog;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionResolveMarker
extends MarkerSelectionProviderAction {
    private MarkerView view;
    static /* synthetic */ Class class$0;

    public ActionResolveMarker(MarkerView markerView, ISelectionProvider provider) {
        super(provider, MarkerMessages.resolveMarkerAction_title);
        this.setEnabled(false);
        this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ELCL_QUICK_FIX_ENABLED"));
        this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLCL_QUICK_FIX_DISABLED"));
        this.view = markerView;
    }

    public void run() {
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.view.getSite().getShell());
        final Object[] resolutions = new Object[1];
        IRunnableWithProgress resolutionsRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind(MarkerMessages.resolveMarkerAction_computationAction, ActionResolveMarker.this.getMarkerDescription()), 100);
                monitor.worked(25);
                resolutions[0] = IDE.getMarkerHelpRegistry().getResolutions(ActionResolveMarker.this.getSelectedMarker());
                monitor.done();
            }
        };
        IWorkbenchPartSite iWorkbenchPartSite = this.view.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object service = iWorkbenchPartSite.getAdapter(clazz);
        try {
            if (service == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI(context, resolutionsRunnable, null);
            } else {
                ((IWorkbenchSiteProgressService)service).runInUI(context, resolutionsRunnable, null);
            }
        }
        catch (InvocationTargetException exception) {
            this.handleException(exception);
            return;
        }
        catch (InterruptedException exception) {
            this.handleException(exception);
            return;
        }
        IMarkerResolution[] foundResolutions = (IMarkerResolution[])resolutions[0];
        if (foundResolutions.length == 0) {
            MessageDialog.openInformation(this.view.getSite().getShell(), MarkerMessages.MarkerResolutionDialog_CannotFixTitle, NLS.bind(MarkerMessages.MarkerResolutionDialog_CannotFixMessage, this.getMarkerDescription()));
        } else {
            MarkerResolutionDialog dialog = new MarkerResolutionDialog(this.view.getSite().getShell(), this.getSelectedMarker(), foundResolutions, this.view);
            dialog.open();
        }
    }

    private void handleException(Exception exception) {
        IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception);
        ErrorDialog.openError(this.view.getSite().getShell(), MarkerMessages.Error, NLS.bind(MarkerMessages.MarkerResolutionDialog_CannotFixMessage, this.getMarkerDescription()), Util.errorStatus(exception));
    }

    private String getMarkerDescription() {
        return Util.getProperty("message", this.getSelectedMarker());
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (Util.isSingleConcreteSelection(selection) && IDE.getMarkerHelpRegistry().hasResolutions(this.getSelectedMarker())) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

