/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogBookmarkFilter;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Util;

public class BookmarkView
extends MarkerView {
    private final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.bookmark"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"message", Util.EMPTY_STRING, Util.EMPTY_STRING, Util.EMPTY_STRING};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.bookmark";
    private final IField[] VISIBLE_FIELDS = new IField[]{new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            if (element instanceof ConcreteMarker && "message".equals(property)) {
                return ((ConcreteMarker)element).getDescription();
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return element instanceof ConcreteMarker && "message".equals(property);
        }

        public void modify(Object element, String property, Object value) {
            Item item;
            Object data;
            if (element instanceof Item && (data = (item = (Item)element).getData()) instanceof ConcreteMarker) {
                IMarker marker = ((ConcreteMarker)data).getMarker();
                try {
                    if (!marker.getAttribute(property).equals(value) && "message".equals(property)) {
                        HashMap<String, Object> attrs = new HashMap<String, Object>();
                        attrs.put("message", value);
                        UpdateMarkersOperation op = new UpdateMarkersOperation(marker, attrs, MarkerMessages.modifyBookmark_title, true);
                        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(op, null, WorkspaceUndoUtil.getUIInfoAdapter(BookmarkView.this.getSite().getShell()));
                    }
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        ErrorDialog.openError(BookmarkView.this.getSite().getShell(), MarkerMessages.errorModifyingBookmark, null, ((CoreException)e.getCause()).getStatus());
                    } else {
                        IDEWorkbenchPlugin.log(MarkerMessages.errorModifyingBookmark, e);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError(BookmarkView.this.getSite().getShell(), MarkerMessages.errorModifyingBookmark, null, e.getStatus());
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TreeViewer treeViewer = this.getViewer();
        CellEditor[] cellEditors = new CellEditor[treeViewer.getTree().getColumnCount()];
        TextCellEditor descriptionCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        cellEditors[0] = descriptionCellEditor;
        treeViewer.setCellEditors(cellEditors);
        treeViewer.setCellModifier(this.cellModifier);
        treeViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor(descriptionCellEditor);
        this.cellEditorActionHandler.setCopyAction(this.copyAction);
        this.cellEditorActionHandler.setPasteAction(this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction(this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction(this.selectAllAction);
        this.cellEditorActionHandler.setUndoAction(this.undoAction);
        this.cellEditorActionHandler.setRedoAction(this.redoAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected IField[] getSortingFields() {
        IField[] all = new IField[this.VISIBLE_FIELDS.length + this.HIDDEN_FIELDS.length];
        System.arraycopy(this.VISIBLE_FIELDS, 0, all, 0, this.VISIBLE_FIELDS.length);
        System.arraycopy(this.HIDDEN_FIELDS, 0, all, this.VISIBLE_FIELDS.length, this.HIDDEN_FIELDS.length);
        return all;
    }

    protected IField[] getAllFields() {
        return this.getSortingFields();
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        super.setSelection(structuredSelection, reveal);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.bookmark"};
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] filters = this.getUserFilters();
        BookmarkFilter[] bookmarkFilters = new BookmarkFilter[filters.length];
        System.arraycopy(filters, 0, bookmarkFilters, 0, filters.length);
        return new DialogBookmarkFilter(this.getSite().getShell(), bookmarkFilters);
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.bookmark_view_context";
    }

    protected MarkerFilter createFilter(String name) {
        return new BookmarkFilter(name);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    void fillContextMenuAdditions(IMenuManager manager) {
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_BOOKMARKS";
    }

    String getMarkerLimitPreferenceName() {
        return "BOOKMARKS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "BOOKMARKS_FILTERS";
    }

    protected String getMarkerName() {
        return MarkerMessages.bookmark_title;
    }

    protected IUndoContext getUndoContext() {
        return WorkspaceUndoUtil.getBookmarksUndoContext();
    }
}

