/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class RemoveTaskAction
extends TaskAction {
    public RemoveTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.remove_task_action_context");
    }

    public void run() {
        TaskList taskList = this.getTaskList();
        TableViewer viewer = taskList.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        taskList.cancelEditing();
        Table table = viewer.getTable();
        int focusIndex = table.getSelectionIndex();
        List list = selection.toList();
        IMarker[] markers = new IMarker[list.size()];
        list.toArray(markers);
        DeleteMarkersOperation op = new DeleteMarkersOperation(markers, TaskListMessages.RemoveTask_undoText);
        this.execute(op, TaskListMessages.RemoveTask_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        int count = table.getItemCount();
        if (focusIndex < count) {
            table.setSelection(focusIndex);
        } else if (count != 0) {
            table.setSelection(count - 1);
        }
        viewer.setSelection(viewer.getSelection(), true);
    }
}

