/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.cli.resultchecker;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.result.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.result.Result;
import com.savvytest.eclipse.core.model.xml.result.ResultFactory;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.reportgenerator.AbstractResultReportGenerator;
import com.savvytest.eclipse.reportgenerator.IResultReportGenerator;
import com.savvytest.eclipse.reportgenerator.JunitResultReportGenerator;
import com.savvytest.eclipse.resultchecker.JexlResultchecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ResultChecker {
    private static final String ENCODING_PARAMETER = "Encoding";
    private static final String IGNORE_LICENSE_PARAMETER = "IgnoreLicense";
    private final File archiveFile;
    private File outputFile;
    private File resultFile;
    private File reportFile;
    private File junitReportFile;
    private String fileEncoding = "UTF-8";
    private String hexEncoding = null;
    private boolean saveArchive = true;

    public ResultChecker(File archiveFile) {
        this.archiveFile = archiveFile;
        if (archiveFile == null) {
            throw new IllegalArgumentException("Archive file must not be null.");
        }
        if (!archiveFile.canRead()) {
            throw new IllegalArgumentException("The archive file can not be read: " + archiveFile);
        }
    }

    public void check() {
        EditingUtility.prepareEMF();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI archiveURI = URI.createFileURI((String)this.archiveFile.toString());
        SavvytestSettings.INSTANCE.getLogger().log("Loading archive from: " + archiveURI, LogLevel.INFO, (Object)this);
        Resource archiveResource = resourceSet.createResource(archiveURI, SavvytestTypeEnum.ARCHIVE.contentTypeID);
        try {
            archiveResource.load(null);
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            SavvytestSettings.INSTANCE.getLogger().log("Couldn't load archive.", LogLevel.ERROR, (Object)this);
            System.exit(1);
        }
        if (!archiveResource.getErrors().isEmpty()) {
            SavvytestSettings.INSTANCE.getLogger().log("Archive couldn't be parsed, reasons following.", LogLevel.ERROR, (Object)this);
            for (Resource.Diagnostic diagnostic : archiveResource.getErrors()) {
                SavvytestSettings.INSTANCE.getLogger().log(diagnostic.toString(), LogLevel.ERROR, (Object)this);
            }
            System.exit(1);
        }
        Archive archive = ((com.savvytest.eclipse.core.model.xml.archive.DocumentRoot)archiveResource.getContents().get(0)).getArchive();
        SavvytestSettings.INSTANCE.getLogger().log("Computing results.", LogLevel.INFO, (Object)this);
        HashMap archiveProperties = PropertiesUtils.getPropertiesMap((Properties)archive.getProperties());
        String computedHexEncoding = this.computeHexEncoding(archiveProperties);
        SavvytestSettings.INSTANCE.getLogger().log("Hex encoding: " + computedHexEncoding, LogLevel.DEBUG, (Object)this);
        Result result = JexlResultchecker.getResult((Testsuite)archive.getTestsuite(), (String)computedHexEncoding);
        archive.setResult(result);
        if (this.isSaveArchive()) {
            this.saveArchive(archiveResource);
        }
        if (this.resultFile != null) {
            this.saveResult((ResourceSet)resourceSet, result);
        }
        if (this.reportFile != null) {
            this.saveReport(result, archiveProperties);
        }
        if (this.junitReportFile != null) {
            this.saveJunitReport(result, archiveProperties);
        }
    }

    private void saveReport(Result result, Map<String, String> archiveProperties) {
        IResultReportGenerator generator = AbstractResultReportGenerator.getGenerator();
        generator.setResult(result.getTestsuiteResult());
        generator.setArchiveProperties(archiveProperties);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(ENCODING_PARAMETER, this.getFileEncoding());
        parameters.put(IGNORE_LICENSE_PARAMETER, Boolean.toString(true));
        generator.setParameters(parameters);
        String report = generator.generateReport();
        try {
            SavvytestSettings.INSTANCE.getLogger().log("Saving report to: " + this.reportFile, LogLevel.INFO, (Object)this);
            FileOutputStream out = new FileOutputStream(this.reportFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.getFileEncoding());
            writer.write(report);
            writer.close();
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            SavvytestSettings.INSTANCE.getLogger().log("Report couldn't be written.", LogLevel.ERROR, (Object)this);
            System.exit(1);
        }
    }

    private void saveJunitReport(Result result, Map<String, String> archiveProperties) {
        JunitResultReportGenerator generator = new JunitResultReportGenerator();
        generator.setResult(result.getTestsuiteResult());
        generator.setArchiveProperties(archiveProperties);
        String report = generator.generateReport();
        try {
            SavvytestSettings.INSTANCE.getLogger().log("Saving JUnit report to: " + this.junitReportFile, LogLevel.INFO, (Object)this);
            FileOutputStream out = new FileOutputStream(this.junitReportFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.getFileEncoding());
            writer.write(report);
            writer.close();
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            SavvytestSettings.INSTANCE.getLogger().log("JUnit report couldn't be written.", LogLevel.ERROR, (Object)this);
            System.exit(1);
        }
    }

    private void saveResult(ResourceSet resourceSet, Result result) {
        URI resultURI = URI.createFileURI((String)this.resultFile.toString());
        SavvytestSettings.INSTANCE.getLogger().log("Saving result to: " + resultURI, LogLevel.INFO, (Object)this);
        Resource resultResource = resourceSet.createResource(resultURI, SavvytestTypeEnum.RESULT.contentTypeID);
        DocumentRoot resultDoc = ResultFactory.eINSTANCE.createDocumentRoot();
        resultResource.getContents().add((Object)resultDoc);
        resultDoc.setResult(result);
        try {
            resultResource.save(this.getSaveOptions());
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            SavvytestSettings.INSTANCE.getLogger().log("Result couldn't be written.", LogLevel.ERROR, (Object)this);
            System.exit(1);
        }
    }

    private void saveArchive(Resource archiveResource) {
        try {
            if (this.outputFile == null || this.archiveFile.equals(this.outputFile)) {
                SavvytestSettings.INSTANCE.getLogger().log("Saving archive to: " + this.archiveFile, LogLevel.INFO, (Object)this);
                archiveResource.save(this.getSaveOptions());
            } else {
                SavvytestSettings.INSTANCE.getLogger().log("Saving archive to: " + this.outputFile, LogLevel.INFO, (Object)this);
                FileOutputStream out = new FileOutputStream(this.outputFile);
                archiveResource.save((OutputStream)out, this.getSaveOptions());
                out.close();
            }
        }
        catch (IOException e) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            SavvytestSettings.INSTANCE.getLogger().log("Archive couldn't be written.", LogLevel.ERROR, (Object)this);
            System.exit(1);
        }
    }

    private Map<String, Object> getSaveOptions() {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("ENCODING", this.getFileEncoding());
        saveOptions.put("FORMATTED", Boolean.TRUE);
        return saveOptions;
    }

    private String computeHexEncoding(Map<String, String> archiveProperties) {
        if (this.hexEncoding != null) {
            return this.hexEncoding;
        }
        if (archiveProperties.containsKey(PropertiesUtils.PropertyEnum.HEX_ENCODING.getName())) {
            return archiveProperties.get(PropertiesUtils.PropertyEnum.HEX_ENCODING.getName());
        }
        return this.fileEncoding;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setResultFile(File resultFile) {
        this.resultFile = resultFile;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setJunitReportFile(File junitReportFile) {
        this.junitReportFile = junitReportFile;
    }

    public File getJunitReportFile() {
        return this.junitReportFile;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding == null ? "UTF-8" : encoding;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setHexEncoding(String hexEncoding) {
        this.hexEncoding = hexEncoding;
    }

    public String getHexEncoding() {
        return this.hexEncoding;
    }

    public void setSaveArchive(boolean saveArchive) {
        this.saveArchive = saveArchive;
    }

    public boolean isSaveArchive() {
        return this.saveArchive;
    }
}

