/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.builderparser.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class StringUtil {
    static final String[] UNPRINTABLE_EBCDIC_HEX_STRINGS = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "0E", "0F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "FA", "FB", "FC", "FD", "FE", "FF"};
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    static {
        Arrays.sort(UNPRINTABLE_EBCDIC_HEX_STRINGS);
    }

    public static String toHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        byte[] byArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
            ++n2;
        }
        try {
            return new String(hex, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static byte[] fromHexString(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        int i = 0;
        while (i < bts.length) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bts;
    }

    public static void main(String[] args) throws Exception {
        byte[] byArray = new byte[7];
        byArray[1] = -1;
        byArray[2] = -2;
        byArray[3] = -3;
        byArray[4] = -4;
        byArray[5] = -5;
        byArray[6] = -6;
        byte[] byteArray = byArray;
        String hex = StringUtil.toHexString(byteArray);
        System.out.println(hex);
        byte[] bytes = StringUtil.fromHexString(hex);
        System.out.println(Arrays.toString(byteArray));
        System.out.println("===");
        System.out.println(Arrays.toString(bytes));
        System.out.println(Arrays.equals(byteArray, bytes));
        System.out.println("=======");
        System.out.println(StringUtil.containsUnprintableCharacterInEBCDIC("00f7f0f1f9f7"));
    }

    public static boolean containsUnprintableCharacterInEBCDIC(String hex) {
        int bytesCount = hex.length() / 2;
        int i = 0;
        while (i < bytesCount) {
            String currentHexString = hex.substring(2 * i, 2 * i + 2);
            int result = Arrays.binarySearch(UNPRINTABLE_EBCDIC_HEX_STRINGS, currentHexString.toUpperCase());
            if (result >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsUnprintableCharacterInASCII(String hex) {
        int bytesCount = hex.length() / 2;
        int i = 0;
        while (i < bytesCount) {
            String currentHexString = hex.substring(2 * i, 2 * i + 2);
            int value = Integer.parseInt(currentHexString, 16);
            if (value <= 31) {
                return true;
            }
            if (value >= 127) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

