/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.components;

import com.savvytest.eclipse.common.components.QuickFilterComponent;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class QuickFilter
extends ViewerFilter
implements QuickFilterComponent.IQuickFilterListener {
    private String filterString = "";
    private boolean caseSensitive;
    private boolean useMap = true;
    private final Map<Object, Boolean> displayMap = new HashMap<Object, Boolean>();

    @Override
    public void filter(String filterString) {
        this.filterString = filterString;
        this.clearMap();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean boolFilter;
        if (this.filterString.isEmpty()) {
            return true;
        }
        if (this.isUseMap() && this.displayMap.containsKey(element)) {
            return this.displayMap.get(element);
        }
        Filter filter = this.select((StructuredViewer)viewer, parentElement, element, this.filterString);
        if (filter == Filter.SHOW) {
            boolFilter = true;
        } else if (filter == Filter.HIDE) {
            boolFilter = false;
        } else {
            Object[] children = this.getChildren((StructuredViewer)viewer, element);
            if (children == null || children.length == 0) {
                boolFilter = false;
            } else {
                boolFilter = false;
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        boolFilter = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (this.isUseMap()) {
            this.displayMap.put(element, boolFilter);
        }
        return boolFilter;
    }

    protected Filter select(StructuredViewer viewer, Object parentElement, Object element, String filterString) {
        IBaseLabelProvider labelProvider = viewer.getLabelProvider();
        if (labelProvider instanceof ITableLabelProvider) {
            ITableLabelProvider tableLabelProvider = (ITableLabelProvider)labelProvider;
            int columns = this.getColumnCount(viewer);
            int i = 0;
            while (i < columns) {
                String labelString = tableLabelProvider.getColumnText(element, i);
                if (this.show(labelString, filterString)) {
                    return Filter.SHOW;
                }
                ++i;
            }
        } else if (labelProvider instanceof ILabelProvider && this.show(((ILabelProvider)labelProvider).getText(element), filterString)) {
            return Filter.SHOW;
        }
        return Filter.CHECK_CHILDREN;
    }

    private int getColumnCount(StructuredViewer viewer) {
        if (viewer instanceof TableViewer) {
            return ((TableViewer)viewer).getTable().getColumnCount();
        }
        if (viewer instanceof TreeViewer) {
            return ((TreeViewer)viewer).getTree().getColumnCount();
        }
        return 0;
    }

    private boolean show(String labelString, String filterString) {
        return labelString != null && (this.isCaseSensitive() ? labelString.contains(filterString) : labelString.toLowerCase().contains(filterString.toLowerCase()));
    }

    protected Object[] getChildren(StructuredViewer viewer, Object element) {
        if (viewer.getContentProvider() instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
        }
        return null;
    }

    public void clearMap() {
        this.displayMap.clear();
    }

    public void setUseMap(boolean useMap) {
        this.useMap = useMap;
        if (!useMap) {
            this.displayMap.clear();
        }
    }

    public boolean isUseMap() {
        return this.useMap;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected static enum Filter {
        SHOW,
        HIDE,
        CHECK_CHILDREN;

    }
}

