/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.components;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.util.GridDataCreator;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QuickFilterComponent {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.components.QuickFilterComponent.";
    private Composite body;
    private final CopyOnWriteArraySet<IQuickFilterListener> listeners = new CopyOnWriteArraySet();

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public Control createControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        body.setLayout((Layout)layout);
        final Text text = new Text(body, 2052);
        text.setLayoutData((Object)GridDataCreator.horizontalFill());
        text.setMessage(QuickFilterComponent.getClassString("message"));
        text.setToolTipText(QuickFilterComponent.getClassString("texttooltip"));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                final String filterString = text.getText();
                text.getDisplay().timerExec(500, new Runnable(){

                    @Override
                    public void run() {
                        if (text.isDisposed()) {
                            return;
                        }
                        if (text.getText().equals(filterString)) {
                            QuickFilterComponent.this.handleQuickFilterEvent(filterString);
                        }
                    }
                });
            }
        });
        final Button button = new Button(body, 8);
        button.setLayoutData((Object)GridDataCreator.normal());
        button.setToolTipText(QuickFilterComponent.getClassString("buttontooltip"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText("");
            }
        });
        final ImageDescriptor resetImgDescriptor = ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/other/delete_edit.gif");
        button.setImage((Image)resetImgDescriptor.createResource((Device)button.getDisplay()));
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                resetImgDescriptor.destroyResource((Object)button.getImage());
            }
        });
        this.body = body;
        return body;
    }

    private void handleQuickFilterEvent(String filterString) {
        for (IQuickFilterListener listener : this.listeners) {
            listener.filter(filterString);
        }
    }

    public void addQuickFilterListener(IQuickFilterListener listener) {
        this.listeners.add(listener);
    }

    public void removeQuickFilterListener(IQuickFilterListener listener) {
        this.listeners.remove(listener);
    }

    public Control getControl() {
        return this.body;
    }

    public static interface IQuickFilterListener {
        public void filter(String var1);
    }
}

