/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.components.selection;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.ContainerContentProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AbstractSavvytestSelection
implements ISelectionProvider {
    private IResource initialSelection;
    private IStructuredSelection selection = StructuredSelection.EMPTY;
    private boolean multi;
    private int mode;
    private Control control;
    private TreeViewer viewer;
    private IProject projectRestriction;
    private SavvytestTypeEnum[] types = SavvytestTypeEnum.values();
    private final CopyOnWriteArraySet<ISelectionChangedListener> listeners = new CopyOnWriteArraySet();
    private final ArrayList<Control> styledControls = new ArrayList();

    public Control createControl(Composite parent, int selectStyle) {
        if (selectStyle != 8192 && selectStyle != 4096 && selectStyle != 4098) {
            throw new IllegalArgumentException("'SelectStyle' must be one of: SWT.SAVE, SWT.OPEN");
        }
        this.mode = selectStyle & 0x3000;
        this.multi = (selectStyle & 2) == 2;
        this.control = this.createControl(parent);
        return this.control;
    }

    protected Control createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 0x800 | (this.multi ? 2 : 4));
        this.viewer.setContentProvider((IContentProvider)new ContainerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setAutoExpandLevel(3);
        this.viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IProject) {
                    return 0;
                }
                if (element instanceof IContainer) {
                    return 1;
                }
                return 2;
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IResource)) {
                    return false;
                }
                return AbstractSavvytestSelection.this.select((IResource)element);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractSavvytestSelection.this.setNewSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        if (this.getInitialSelection() != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.getInitialSelection()), true);
        }
        this.addStyledControl(this.viewer.getControl());
        return this.viewer.getControl();
    }

    protected boolean select(IResource element) {
        if (element.getType() == 4) {
            if (!Savvytest.hasSavvytestNature((IProject)element)) {
                return false;
            }
            return this.getProjectRestriction() == null || this.getProjectRestriction().equals((Object)element);
        }
        SavvytestTypeEnum[] savvytestTypeEnumArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            SavvytestTypeEnum type = savvytestTypeEnumArray[n2];
            if (type.isType(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void setNewSelection(IStructuredSelection newSelection) {
        IStructuredSelection oldSelection = this.selection;
        this.selection = newSelection;
        this.notifyListeners(newSelection, oldSelection);
    }

    private void notifyListeners(IStructuredSelection newSelection, IStructuredSelection oldSelection) {
        if (!newSelection.equals(oldSelection)) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)newSelection);
            Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().selectionChanged(event);
            }
        }
    }

    public void refresh() {
        if (this.viewer != null) {
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        }
    }

    public void setTypes(SavvytestTypeEnum ... types) {
        this.types = types;
        if (types == null || types.length == 0) {
            this.types = SavvytestTypeEnum.values();
        }
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public SavvytestTypeEnum[] getTypes() {
        return this.types;
    }

    public void setProjectRestriction(IProject projectRestriction) {
        this.projectRestriction = projectRestriction;
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.expandToLevel(this.viewer.getAutoExpandLevel());
        }
    }

    public IProject getProjectRestriction() {
        return this.projectRestriction;
    }

    public Control getControl() {
        return this.control;
    }

    protected IResource getSelectedResource() {
        if (this.selection.isEmpty() || !this.multi && this.selection.size() > 1) {
            return null;
        }
        return (IResource)this.selection.getFirstElement();
    }

    protected IResource[] getSelectedResources() {
        ArrayList<IResource> resources = new ArrayList<IResource>(this.selection.size());
        Iterator iter = this.selection.iterator();
        while (iter.hasNext()) {
            resources.add((IResource)iter.next());
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected IResource getSelectedResource(int resourceType) {
        IResource resource = this.getSelectedResource();
        if (resource != null && resource.getType() == resourceType) {
            return resource;
        }
        return null;
    }

    protected IResource[] getSelectedResources(int resourceType) {
        ArrayList<IResource> resources = new ArrayList<IResource>(this.selection.size());
        for (IResource resource : this.selection) {
            if (resource.getType() != resourceType) continue;
            resources.add(resource);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public void setInitialSelection(IResource initialSelection) {
        this.initialSelection = initialSelection;
    }

    public IResource getInitialSelection() {
        return this.initialSelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection((ISelection)(selection != null ? selection : StructuredSelection.EMPTY), true);
    }

    public void setFont(Font font) {
        for (Control control : this.styledControls) {
            control.setFont(font);
        }
    }

    public void setColor(Color color) {
        for (Control control : this.styledControls) {
            control.setForeground(color);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultiSelect() {
        return this.multi;
    }

    protected void addStyledControl(Control control) {
        this.styledControls.add(control);
    }
}

