/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class InOutViewerFilter
extends ViewerFilter {
    private static final HashSet<EReference> containerReferences = new HashSet(4);
    private final EnumSet<UsageType> filterUsages;
    private final boolean showFiller;

    static {
        containerReferences.add(DataPackage.Literals.CONTAINER_DATA__STRUCT);
        containerReferences.add(DataPackage.Literals.CONTAINER_DATA__ARRAY);
        containerReferences.add(DataPackage.Literals.PARAMETERS__STRUCT);
        containerReferences.add(DataPackage.Literals.PARAMETERS__ARRAY);
    }

    public InOutViewerFilter(EnumSet<UsageType> filterUsages) {
        this(filterUsages, false);
    }

    public InOutViewerFilter(EnumSet<UsageType> filterUsages, boolean showFiller) {
        this.filterUsages = EnumSet.copyOf(filterUsages);
        this.showFiller = showFiller;
    }

    private boolean recursiveSelect(Data data) {
        boolean passUsageType;
        BaseTypeExtension bte = data.getBaseTypeExtension();
        BaseType bt = data.getBaseType();
        if (bte == null || bt == null) {
            return true;
        }
        UsageType type = PropertiesUtils.getUsage((Properties)bte.getProperties());
        boolean isFiller = PropertiesUtils.getBooleanProperty((Properties)bt.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER, (boolean)false);
        if ((type == UsageType.INOUT || isFiller) && containerReferences.contains(data.eContainmentFeature())) {
            boolean visible = false;
            Iterator iter = ((ContainerData)data).getElements().iterator();
            while (!visible && iter.hasNext()) {
                visible = this.recursiveSelect((Data)((FeatureMap.Entry)iter.next()).getValue());
            }
            return visible;
        }
        boolean passFiller = this.showFiller || !isFiller;
        boolean bl = passUsageType = !this.filterUsages.contains(type);
        return passUsageType && passFiller;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)element);
        if (unwrapped instanceof Data) {
            return this.recursiveSelect((Data)unwrapped);
        }
        return true;
    }
}

