/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.views;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.TextActionHandler;

public abstract class DefaultEditorInformationPage
extends Composite {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.views.DefaultEditorInformationPage.";
    protected ScrolledComposite scrollComp;
    private boolean recursionPreventer = false;
    protected boolean init = false;
    private TextActionHandler textActionHandler;
    private final Adapter nameAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (DefaultEditorInformationPage.this.recursionPreventer) {
                return;
            }
            if (msg.getEventType() == 1 && msg.getFeature() == DefaultEditorInformationPage.this.getSavvyNameFeature()) {
                try {
                    DefaultEditorInformationPage.this.recursionPreventer = true;
                    if (DefaultEditorInformationPage.this.nameText != null && !DefaultEditorInformationPage.this.nameText.isDisposed()) {
                        String name = msg.getNewStringValue();
                        if (name == null) {
                            name = "";
                        }
                        DefaultEditorInformationPage.this.nameText.setText(name);
                    }
                }
                finally {
                    DefaultEditorInformationPage.this.recursionPreventer = false;
                }
            }
        }
    };
    private final Adapter aliasAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (DefaultEditorInformationPage.this.recursionPreventer) {
                return;
            }
            if (msg.getEventType() == 1 && msg.getFeature() == DefaultEditorInformationPage.this.getSavvyAliasFeature()) {
                try {
                    DefaultEditorInformationPage.this.recursionPreventer = true;
                    if (DefaultEditorInformationPage.this.aliasText != null && !DefaultEditorInformationPage.this.aliasText.isDisposed()) {
                        String alias = msg.getNewStringValue();
                        if (alias == null) {
                            alias = "";
                        }
                        DefaultEditorInformationPage.this.aliasText.setText(alias);
                    }
                }
                finally {
                    DefaultEditorInformationPage.this.recursionPreventer = false;
                }
            }
        }
    };
    private final Adapter descriptionAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (DefaultEditorInformationPage.this.recursionPreventer) {
                return;
            }
            if (msg.getEventType() == 1 && msg.getFeature() == DefaultEditorInformationPage.this.getSavvyDescriptionFeature()) {
                try {
                    DefaultEditorInformationPage.this.recursionPreventer = true;
                    if (DefaultEditorInformationPage.this.descText != null && !DefaultEditorInformationPage.this.descText.isDisposed()) {
                        String desc = msg.getNewStringValue();
                        if (desc == null) {
                            desc = "";
                        }
                        DefaultEditorInformationPage.this.descText.setText(desc);
                    }
                }
                finally {
                    DefaultEditorInformationPage.this.recursionPreventer = false;
                }
            }
        }
    };
    private final KeyAdapter checkEditingListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (UtilityFunctions.isPrintableChar(e.character) || this.modifies(e)) {
                e.doit = DefaultEditorInformationPage.this.checkEditing();
            }
        }

        private boolean modifies(KeyEvent e) {
            switch (e.keyCode) {
                case 8: 
                case 13: 
                case 127: 
                case 0x1000050: {
                    return true;
                }
            }
            return false;
        }
    };
    protected Text nameText;
    protected Text aliasText;
    protected Text descText;

    private static String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public DefaultEditorInformationPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
    }

    public void init() {
        if (!this.init) {
            this.createControl(this);
            this.init = true;
        }
    }

    public void enableCutCopyPasteHandler(IActionBars actionBar) {
        if (this.textActionHandler != null) {
            return;
        }
        this.textActionHandler = new TextActionHandler(actionBar);
        if (this.init) {
            this.textActionHandler.addText(this.nameText);
            this.textActionHandler.addText(this.aliasText);
            this.textActionHandler.addText(this.descText);
        }
    }

    protected TextActionHandler getCutCopyPasteHandler() {
        return this.textActionHandler;
    }

    protected KeyAdapter getCheckEditingListener() {
        return this.checkEditingListener;
    }

    protected void createControl(Composite parent) {
        final EditingDomain editingDomain = this.getEditingDomain();
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.scrollComp = new ScrolledComposite(parent, 768);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.setExpandVertical(true);
        Composite baseComp = new Composite((Composite)this.scrollComp, 0);
        baseComp.setLayout((Layout)new GridLayout());
        Group groupName = new Group(baseComp, 16);
        groupName.setText(DefaultEditorInformationPage.getClassString("groupname"));
        groupName.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupName.setLayout((Layout)new FillLayout());
        groupName.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupName.setFont(font);
        this.nameText = new Text((Composite)groupName, 2060);
        String name = this.getSavvyName();
        this.nameText.setText(name);
        this.nameText.setFont(font);
        this.nameText.setForeground(color);
        Group groupAlias = new Group(baseComp, 16);
        groupAlias.setText(DefaultEditorInformationPage.getClassString("groupalias"));
        groupAlias.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupAlias.setLayout((Layout)new FillLayout());
        groupAlias.setFont(font);
        this.aliasText = new Text((Composite)groupAlias, 2052);
        String alias = this.getSavvyAlias();
        this.aliasText.setText(alias);
        this.aliasText.setFont(font);
        this.aliasText.setForeground(color);
        this.aliasText.addKeyListener((KeyListener)this.getCheckEditingListener());
        this.aliasText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (DefaultEditorInformationPage.this.recursionPreventer) {
                    return;
                }
                try {
                    DefaultEditorInformationPage.this.recursionPreventer = true;
                    String newAlias = DefaultEditorInformationPage.this.aliasText.getText();
                    String oldAlias = DefaultEditorInformationPage.this.getSavvyAlias();
                    if (!newAlias.equals(oldAlias)) {
                        Command cmd = DefaultEditorInformationPage.this.makeAliasCommand(newAlias);
                        if (cmd.canExecute()) {
                            editingDomain.getCommandStack().execute(cmd);
                        } else {
                            SavvytestSettings.INSTANCE.getLogger().log("Alias setting failed: " + cmd, LogLevel.ERROR, this);
                        }
                    }
                }
                finally {
                    DefaultEditorInformationPage.this.recursionPreventer = false;
                }
            }
        });
        Group groupDesc = new Group(baseComp, 16);
        groupDesc.setText(DefaultEditorInformationPage.getClassString("groupdesc"));
        groupDesc.setLayout((Layout)new FillLayout());
        groupDesc.setFont(font);
        this.descText = new Text((Composite)groupDesc, 2626);
        String description = this.getSavvyDescription();
        this.descText.setText(description);
        this.descText.setFont(font);
        this.descText.setForeground(color);
        this.descText.addKeyListener((KeyListener)this.getCheckEditingListener());
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (DefaultEditorInformationPage.this.recursionPreventer) {
                    return;
                }
                try {
                    DefaultEditorInformationPage.this.recursionPreventer = true;
                    String newDesc = DefaultEditorInformationPage.this.descText.getText();
                    String oldDesc = DefaultEditorInformationPage.this.getSavvyDescription();
                    if (!newDesc.equals(oldDesc)) {
                        Command cmd = DefaultEditorInformationPage.this.makeDescriptionCommand(newDesc);
                        if (cmd.canExecute()) {
                            editingDomain.getCommandStack().execute(cmd);
                        } else {
                            SavvytestSettings.INSTANCE.getLogger().log("Description setting failed: " + cmd, LogLevel.ERROR, this);
                        }
                    }
                }
                finally {
                    DefaultEditorInformationPage.this.recursionPreventer = false;
                }
            }
        });
        GridData descGrid = GridDataCreator.horizontalFill();
        descGrid.heightHint = descGrid.minimumHeight = this.nameText.computeSize((int)-1, (int)-1).y * 4;
        groupDesc.setLayoutData((Object)descGrid);
        this.scrollComp.setContent((Control)baseComp);
        this.scrollComp.setMinSize(baseComp.computeSize(-1, -1, true));
        this.getSavvyNameOwner().eAdapters().add((Object)this.nameAdapter);
        this.getSavvyAliasOwner().eAdapters().add((Object)this.aliasAdapter);
        this.getSavvyDescriptionOwner().eAdapters().add((Object)this.descriptionAdapter);
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.nameText);
            this.textActionHandler.addText(this.aliasText);
            this.textActionHandler.addText(this.descText);
        }
    }

    public void dispose() {
        if (this.init) {
            if (this.getSavvyNameOwner() != null) {
                this.getSavvyNameOwner().eAdapters().remove((Object)this.nameAdapter);
            }
            if (this.getSavvyAliasOwner() != null) {
                this.getSavvyAliasOwner().eAdapters().remove((Object)this.aliasAdapter);
            }
            if (this.getSavvyDescriptionOwner() != null) {
                this.getSavvyDescriptionOwner().eAdapters().remove((Object)this.descriptionAdapter);
            }
        }
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.nameText);
            this.textActionHandler.removeText(this.aliasText);
            this.textActionHandler.removeText(this.descText);
            this.textActionHandler.dispose();
        }
        super.dispose();
    }

    protected abstract EditingDomain getEditingDomain();

    protected abstract EObject getSavvyNameOwner();

    protected abstract EObject getSavvyAliasOwner();

    protected abstract EObject getSavvyDescriptionOwner();

    protected abstract EStructuralFeature getSavvyNameFeature();

    protected abstract EStructuralFeature getSavvyAliasFeature();

    protected abstract EStructuralFeature getSavvyDescriptionFeature();

    protected abstract boolean isReadOnly();

    protected String getSavvyName() {
        Object value = this.getSavvyNameOwner().eGet(this.getSavvyNameFeature());
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Name couldn't be retrieved. (Owner: " + this.getSavvyNameOwner() + "; Feature: " + this.getSavvyNameFeature() + "; Name: " + value + ")", LogLevel.ERROR, (Object)this);
        return null;
    }

    protected String getSavvyAlias() {
        Object value = this.getSavvyAliasOwner().eGet(this.getSavvyAliasFeature());
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Alias couldn't be retrieved. (Owner: " + this.getSavvyAliasOwner() + "; Feature: " + this.getSavvyAliasFeature() + "; Alias: " + value + ")", LogLevel.ERROR, (Object)this);
        return null;
    }

    protected String getSavvyDescription() {
        Object value = this.getSavvyDescriptionOwner().eGet(this.getSavvyDescriptionFeature());
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Description couldn't be retrieved. (Owner: " + this.getSavvyDescriptionOwner() + "; Feature: " + this.getSavvyDescriptionFeature() + "; Description: " + value + ")", LogLevel.ERROR, (Object)this);
        return null;
    }

    protected Command makeNameCommand(String newName) {
        return new SetCommand(this.getEditingDomain(), this.getSavvyNameOwner(), this.getSavvyNameFeature(), (Object)newName);
    }

    protected Command makeAliasCommand(String newAlias) {
        return new SetCommand(this.getEditingDomain(), this.getSavvyAliasOwner(), this.getSavvyAliasFeature(), (Object)newAlias);
    }

    protected Command makeDescriptionCommand(String newDescription) {
        return new SetCommand(this.getEditingDomain(), this.getSavvyDescriptionOwner(), this.getSavvyDescriptionFeature(), (Object)newDescription);
    }

    protected boolean checkEditing() {
        if (!this.isReadOnly()) {
            return true;
        }
        Resource resource = this.getSavvyNameOwner().eResource();
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            IStatus status;
            String platformString = uri.toPlatformString(true);
            IFile resourceFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            if (resourceFile != null && resourceFile.isReadOnly() && (status = EditingUtility.checkEditing(resourceFile, this.getShell())) != null) {
                ((AdapterFactoryEditingDomain)this.getEditingDomain()).getResourceToReadOnlyMap().put(resource, resourceFile.isReadOnly());
                return false;
            }
        }
        return true;
    }

    public void refresh() {
        if (this.init) {
            try {
                this.recursionPreventer = true;
                this.nameText.setText(this.getSavvyName());
                this.aliasText.setText(this.getSavvyAlias());
                this.descText.setText(this.getSavvyDescription());
            }
            finally {
                this.recursionPreventer = false;
            }
        }
    }
}

