/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.provider;

import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.provider.AbstractModifyPersistentDataCompoundCommand;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class UpdatePersistentDataIdCommand
extends AbstractModifyPersistentDataCompoundCommand {
    private EObject parent;

    public UpdatePersistentDataIdCommand(Array array, EditingDomain domain) {
        this(array, domain, 0);
    }

    public UpdatePersistentDataIdCommand(Array array, EditingDomain domain, int index) {
        super(domain, (EObject)array, null, null, index);
    }

    protected boolean prepare() {
        if (this.getCommandList().isEmpty()) {
            Array array = this.getArray();
            this.parent = UpdatePersistentDataIdCommand.getEnclosingParent((EObject)array);
            if (this.index >= 0 && this.index < array.getElements().size()) {
                int i = this.index;
                while (i < array.getElements().size()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)array.getElements().get(i);
                    Data data = (Data)entry.getValue();
                    this.handleData(data);
                    ++i;
                }
            }
        }
        return super.prepare();
    }

    private Array getArray() {
        return (Array)this.owner;
    }

    private void handleAtomic(Atomic data) {
        PersistentData persistentData = data.getPersistentData();
        String newId = this.adaptID(this.parent, data.calculateId());
        if (!newId.equals(persistentData.getId())) {
            this.append(SetCommand.create((EditingDomain)this.domain, (Object)persistentData, (Object)DataPackage.Literals.PERSISTENT_DATA__ID, (Object)newId));
            Properties properties = persistentData.getProperties();
            Property owner = PropertiesUtils.getProperty((Properties)properties, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.INDEX);
            this.append(SetCommand.create((EditingDomain)this.domain, (Object)owner, (Object)PropertiesPackage.Literals.PROPERTY__VALUE, (Object)newId));
        }
    }

    private void handleContainer(ContainerData container) {
        for (FeatureMap.Entry entry : container.getElements()) {
            Data data = (Data)entry.getValue();
            this.handleData(data);
        }
    }

    private void handleData(Data data) {
        if (data instanceof ContainerData) {
            this.handleContainer((ContainerData)data);
        } else {
            this.handleAtomic((Atomic)data);
        }
    }
}

