/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.ISavvytestWizardPage;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.SimpleXPathEvaluator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListAdapter;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListListener;
import com.savvytest.eclipse.common.util.editing.duallistselector.ElementInformation;
import com.savvytest.eclipse.common.util.editing.duallistselector.TreeFileSelector;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditor;
import com.savvytest.eclipse.editor.iface.gui.InterfaceModelWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SavvytestInterfaceWizardPage
extends WizardPage
implements ISavvytestWizardPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.gui.SavvytestInterfaceWizardPage.";
    private Composite container;
    private Text interfaceTargetText;
    private IFile resultFile;
    private IProject containingProject = null;
    private InterfaceModelWizard.InterfaceModelWizardNewFileCreationPage filepage = null;
    private TreeFileSelector tfs = null;
    private List<IFile> preSetFiles = null;
    private WizardPageValidator validator;

    protected static String getString(String key) {
        return InterfaceEditor.getString(key);
    }

    private static String getClassString(String key) {
        return SavvytestInterfaceWizardPage.getString(TRANSLATION_PREFIX + key);
    }

    public SavvytestInterfaceWizardPage(String pageName) {
        super(pageName);
    }

    public void dispose() {
        super.dispose();
        if (this.tfs != null) {
            this.tfs.dispose();
        }
    }

    public String getInterfaceTarget() {
        return this.interfaceTargetText.getText().trim();
    }

    public List<IFile> getListructureFilenames() {
        if (this.tfs == null) {
            return null;
        }
        return this.tfs.getSelected();
    }

    public IFile getResultFile() {
        return this.resultFile;
    }

    public void setListructureFilenames(List<IFile> listructures) {
        if (this.tfs != null) {
            this.tfs.setSelected(listructures);
        } else if (this.preSetFiles == null) {
            this.preSetFiles = new ArrayList<IFile>(listructures);
        } else {
            this.preSetFiles.clear();
            this.preSetFiles.addAll(listructures);
        }
    }

    public void createControl(Composite parent) {
        IWizardPage page;
        this.validator = new WizardPageValidator(this){

            protected String internalValidate() {
                String target = SavvytestInterfaceWizardPage.this.interfaceTargetText.getText().trim();
                if (target.isEmpty()) {
                    return SavvytestInterfaceWizardPage.getClassString("error.target");
                }
                if (SavvytestInterfaceWizardPage.this.tfs.isNothingSelected()) {
                    return SavvytestInterfaceWizardPage.getClassString("error.parameters");
                }
                return null;
            }

            private IFile makeIFile(String pathToFile) {
                IPath path = Path.fromOSString((String)pathToFile);
                return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            }
        };
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        Group groupTarget = new Group(this.container, 16);
        Group groupInterface = new Group(this.container, 16);
        Group groupInformation = new Group(this.container, 16);
        Label labelAlias = new Label((Composite)groupInformation, 0);
        final Text textAlias = new Text((Composite)groupInformation, 2060);
        Label labelFolder = new Label((Composite)groupInformation, 0);
        final Text textFolder = new Text((Composite)groupInformation, 2060);
        Label labelProject = new Label((Composite)groupInformation, 0);
        final Text textProject = new Text((Composite)groupInformation, 2060);
        groupTarget.setText(SavvytestInterfaceWizardPage.getClassString("target"));
        groupTarget.setLayoutData((Object)new GridData(4, 0, true, false));
        groupTarget.setLayout((Layout)new GridLayout(1, false));
        groupTarget.setFont(font);
        groupTarget.setForeground(color);
        this.interfaceTargetText = new Text((Composite)groupTarget, 2048);
        this.interfaceTargetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.interfaceTargetText.addListener(24, (Listener)this.validator);
        this.interfaceTargetText.setFont(font);
        this.interfaceTargetText.setForeground(color);
        groupInterface.setText(SavvytestInterfaceWizardPage.getClassString("grouplistructures"));
        groupInterface.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupInterface.setLayout((Layout)new GridLayout(2, false));
        groupInterface.setFont(font);
        groupInterface.setForeground(color);
        this.tfs = new TreeFileSelector((Composite)groupInterface, 0);
        this.tfs.setFont(font);
        this.tfs.setColor(color);
        this.tfs.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.tfs.setFileTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.LISTRUCTURE});
        this.tfs.setProjectRestriction(this.containingProject);
        this.tfs.addDualListListener((DualListListener)new DualListAdapter<IFile>(){

            public void selectionEvent(int side, List<ElementInformation<IFile>> elements) {
                if (elements != null && elements.size() == 1 && ((IFile)elements.get((int)0).element).exists()) {
                    IFile file = (IFile)elements.get((int)0).element;
                    SimpleXPathEvaluator parser = new SimpleXPathEvaluator();
                    parser.setDocumentSecure(file);
                    parser.setXPath(SimpleXPathEvaluator.XPATH_ALIAS);
                    String alias = parser.evaluateXPathForStringSecure();
                    textAlias.setText(alias == null ? "" : alias);
                    textFolder.setText(file.getProjectRelativePath().removeLastSegments(1).toString());
                    textProject.setText(file.getProject().getName());
                } else {
                    textAlias.setText("");
                    textFolder.setText("");
                    textProject.setText("");
                }
            }

            public void movementEvent(int side, List<ElementInformation<IFile>> elements) {
                SavvytestInterfaceWizardPage.this.validator.validate();
            }
        });
        groupInformation.setText(SavvytestInterfaceWizardPage.getClassString("groupinfo"));
        groupInformation.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupInformation.setLayout((Layout)new GridLayout(2, false));
        groupInformation.setFont(font);
        groupInformation.setForeground(color);
        labelAlias.setText(SavvytestInterfaceWizardPage.getClassString("infoalias"));
        labelAlias.setLayoutData((Object)GridDataCreator.normal());
        labelAlias.setFont(font);
        labelAlias.setForeground(color);
        textAlias.setLayoutData((Object)GridDataCreator.horizontalFill());
        textAlias.setFont(font);
        textAlias.setForeground(color);
        labelFolder.setText(SavvytestInterfaceWizardPage.getClassString("infofolder"));
        labelFolder.setLayoutData((Object)GridDataCreator.normal());
        labelFolder.setFont(font);
        labelFolder.setForeground(color);
        textFolder.setLayoutData((Object)GridDataCreator.horizontalFill());
        textFolder.setFont(font);
        textFolder.setForeground(color);
        labelProject.setText(SavvytestInterfaceWizardPage.getClassString("infoproject"));
        labelProject.setLayoutData((Object)GridDataCreator.normal());
        labelProject.setFont(font);
        labelProject.setForeground(color);
        textProject.setLayoutData((Object)GridDataCreator.horizontalFill());
        textProject.setFont(font);
        textProject.setForeground(color);
        if (this.preSetFiles != null) {
            if (!this.preSetFiles.isEmpty()) {
                this.tfs.setSelected(this.preSetFiles);
                this.preSetFiles.clear();
            }
            this.preSetFiles = null;
        }
        if ((page = this.getNextPage()) instanceof InterfaceModelWizard.InterfaceModelWizardNewFileCreationPage) {
            this.filepage = (InterfaceModelWizard.InterfaceModelWizardNewFileCreationPage)page;
        }
        this.container.pack();
        this.setControl((Control)this.container);
        this.validator.validate();
        this.validator.setDisplayError(true);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getControl()});
    }

    public void updateName(String name) {
        if (this.filepage != null) {
            this.filepage.setFileName(String.valueOf(name) + '.' + InterfaceModelWizard.FILE_EXTENSIONS.get(0));
            this.filepage.setPageComplete(this.filepage.validatePage());
            this.filepage.getWizard().getContainer().updateButtons();
        }
    }

    public void updateProject(IProject project) {
        this.containingProject = project;
        if (this.tfs != null) {
            this.tfs.deselectAll();
            this.tfs.setProjectRestriction(this.containingProject);
            this.validator.validate();
            if (this.filepage != null) {
                this.filepage.setContainerFullPath(SavvytestTypeEnum.INTERFACE.getDefaultFolder((IResource)this.containingProject).getFullPath());
                this.filepage.setPageComplete(this.filepage.validatePage());
                this.filepage.getWizard().getContainer().updateButtons();
            }
        }
    }
}

