/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.actions;

import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUi;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditorPlugin;
import com.savvytest.eclipse.editor.iface.gui.SavvytestInterfaceEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;

public class RemoveListructureCommand
extends AbstractOverrideableCommand {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.actions.RemoveListructureCommand.";
    private static final String LABEL = RemoveListructureCommand.getClassString("label");
    private static final String DESCRIPTION = RemoveListructureCommand.getClassString("description");
    private final SavvytestInterfaceEditor editor;
    private int index;
    private Interface iface;
    private InterfaceUi ifaceUi;
    private Map<Listructure, Map<String, BaseType>> map;
    private Argument arg;
    private Listructure listructure;
    private Map<String, BaseType> content;

    private static String getClassString(String key) {
        return InterfaceEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public RemoveListructureCommand(SavvytestInterfaceEditor editor, int index) {
        super(editor.getEditingDomain(), LABEL, DESCRIPTION);
        this.editor = editor;
        this.index = index;
    }

    public RemoveListructureCommand(SavvytestInterfaceEditor editor, Listructure listructure) {
        super(editor.getEditingDomain(), LABEL, DESCRIPTION);
        this.editor = editor;
        this.listructure = listructure;
        this.index = -1;
    }

    protected boolean prepare() {
        Resource resource = (Resource)this.getDomain().getResourceSet().getResources().get(0);
        DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
        this.iface = doc.getInterface();
        this.ifaceUi = (InterfaceUi)resource.getContents().get(1);
        this.map = this.editor.getArgumentsMap();
        if (this.index == -1) {
            EList args = this.iface.getArguments();
            int i = 0;
            while (i < args.size()) {
                if (((Argument)args.get(i)).getListructure() == this.listructure) {
                    this.index = i;
                    break;
                }
                ++i;
            }
        }
        return this.iface != null && this.ifaceUi != null && this.index >= 0 && this.index <= this.iface.getArguments().size();
    }

    public void doExecute() {
        this.arg = (Argument)this.iface.getArguments().remove(this.index);
        this.listructure = (Listructure)this.ifaceUi.getArgumentsUi().remove(this.index);
        if (this.map != null) {
            this.content = this.map.remove(this.listructure);
        }
    }

    public void doUndo() {
        this.iface.getArguments().add(this.index, (Object)this.arg);
        this.ifaceUi.getArgumentsUi().add(this.index, (Object)this.listructure);
        if (this.map != null && this.content != null) {
            this.map.put(this.listructure, this.content);
        }
    }

    public void doRedo() {
        this.doExecute();
    }

    public Collection<?> doGetAffectedObjects() {
        ArrayList<Object> objList = new ArrayList<Object>(3);
        objList.add(this.iface);
        objList.add(this.ifaceUi);
        objList.add(this.map);
        return objList;
    }

    public Collection<?> doGetResult() {
        ArrayList<Object> objList = new ArrayList<Object>(2);
        objList.add(this.iface);
        objList.add(this.ifaceUi);
        return objList;
    }
}

