/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.gui;

import com.savvytest.eclipse.common.commands.SwapCommand;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListAdapter;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListListener;
import com.savvytest.eclipse.common.util.editing.duallistselector.ElementInformation;
import com.savvytest.eclipse.common.util.editing.duallistselector.TreeFileSelector;
import com.savvytest.eclipse.common.views.DefaultEditorInformationPage;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.iface.InterfacePackage;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUi;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUiPackage;
import com.savvytest.eclipse.editor.iface.actions.AddListructureCommand;
import com.savvytest.eclipse.editor.iface.actions.RemoveListructureCommand;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditorPlugin;
import com.savvytest.eclipse.editor.iface.gui.SavvytestInterfaceEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class AdditionalInterfaceInformation
extends DefaultEditorInformationPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.gui.AdditionalInterfaceInformation.";
    private boolean recursionPreventer = false;
    private final SavvytestInterfaceEditor editor;
    private EditingDomain editingDomain;
    private Resource resource;
    private DocumentRoot doc;
    private TreeFileSelector tfs;
    private final Adapter modelChangeAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (AdditionalInterfaceInformation.this.recursionPreventer) {
                return;
            }
            try {
                AdditionalInterfaceInformation.this.recursionPreventer = true;
                switch (msg.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (msg.getFeature() == InterfacePackage.Literals.INTERFACE__ARGUMENTS) {
                            SavvytestSettings.INSTANCE.getLogger().log("Model update of arguments.", LogLevel.DEBUG, (Object)this);
                            AdditionalInterfaceInformation.this.setToDLS((List)AdditionalInterfaceInformation.this.doc.getInterface().getArguments());
                        }
                        break;
                    }
                    case 1: {
                        Object feature = msg.getFeature();
                        if (feature == InterfacePackage.Literals.INTERFACE__ARGUMENTS) {
                            SavvytestSettings.INSTANCE.getLogger().log("Model update of arguments.", LogLevel.DEBUG, (Object)this);
                            AdditionalInterfaceInformation.this.setToDLS((List)AdditionalInterfaceInformation.this.doc.getInterface().getArguments());
                            break;
                        }
                        if (feature == InterfacePackage.Literals.INTERFACE__TARGET) {
                            String newTarget = msg.getNewStringValue();
                            SavvytestSettings.INSTANCE.getLogger().log("Model update of target: " + newTarget, LogLevel.DEBUG, (Object)this);
                            if (newTarget == null) {
                                newTarget = "";
                            }
                            AdditionalInterfaceInformation.this.interfaceTargetText.setText(newTarget);
                            break;
                        }
                        if (feature == InterfacePackage.Literals.INTERFACE__CALL_TYPE) {
                            String newCallType = msg.getNewStringValue();
                            SavvytestSettings.INSTANCE.getLogger().log("Model update of call type: " + newCallType, LogLevel.DEBUG, (Object)this);
                            if (AdditionalInterfaceInformation.this.callTypeCombo != null && !AdditionalInterfaceInformation.this.callTypeCombo.getCombo().isDisposed()) {
                                if (newCallType == null || newCallType.trim().isEmpty()) {
                                    AdditionalInterfaceInformation.this.callTypeCombo.setSelection((ISelection)StructuredSelection.EMPTY, true);
                                } else {
                                    AdditionalInterfaceInformation.this.callTypeCombo.setSelection((ISelection)new StructuredSelection((Object)newCallType), true);
                                }
                            }
                            if (AdditionalInterfaceInformation.this.callTypeText != null && !AdditionalInterfaceInformation.this.callTypeText.isDisposed()) {
                                if (newCallType == null) {
                                    newCallType = "";
                                }
                                AdditionalInterfaceInformation.this.interfaceTargetText.setText(newCallType);
                            }
                        }
                        break;
                    }
                }
            }
            finally {
                AdditionalInterfaceInformation.this.recursionPreventer = false;
            }
        }
    };
    private Text interfaceTargetText;
    private ComboViewer callTypeCombo;
    private Text callTypeText;

    private static String getClassString(String key) {
        return InterfaceEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public AdditionalInterfaceInformation(SavvytestInterfaceEditor editor, Composite parent, int style) {
        super(parent, style);
        this.editor = editor;
        this.editingDomain = editor.getEditingDomain();
        this.resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.doc = (DocumentRoot)this.resource.getContents().get(0);
        this.enableCutCopyPasteHandler(editor.getActionBars());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.scrollComp.getContent();
        String projectname = URI.decode((String)this.resource.getURI().segments()[1]);
        IProject containingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectname);
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Group groupTarget = new Group(comp, 16);
        groupTarget.setText(AdditionalInterfaceInformation.getClassString("grouptarget"));
        groupTarget.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupTarget.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        groupTarget.setFont(font);
        Label targetLabel = new Label((Composite)groupTarget, 0);
        targetLabel.setLayoutData((Object)GridDataCreator.normal());
        targetLabel.setText(AdditionalInterfaceInformation.getClassString("target"));
        this.interfaceTargetText = new Text((Composite)groupTarget, 2052);
        this.interfaceTargetText.setLayoutData((Object)GridDataCreator.horizontalFill());
        this.interfaceTargetText.setFont(font);
        this.interfaceTargetText.setForeground(color);
        this.interfaceTargetText.setText(this.getSavvyTarget());
        this.interfaceTargetText.addKeyListener((KeyListener)this.getCheckEditingListener());
        this.interfaceTargetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (AdditionalInterfaceInformation.this.recursionPreventer) {
                    return;
                }
                try {
                    AdditionalInterfaceInformation.this.recursionPreventer = true;
                    String newTarget = AdditionalInterfaceInformation.this.interfaceTargetText.getText().trim();
                    String oldTarget = AdditionalInterfaceInformation.this.doc.getInterface().getTarget();
                    if (!newTarget.equals(oldTarget)) {
                        SetCommand cmd = new SetCommand(AdditionalInterfaceInformation.this.editingDomain, (EObject)AdditionalInterfaceInformation.this.doc.getInterface(), (EStructuralFeature)InterfacePackage.eINSTANCE.getInterface_Target(), (Object)newTarget);
                        AdditionalInterfaceInformation.this.editingDomain.getCommandStack().execute((Command)cmd);
                    }
                }
                finally {
                    AdditionalInterfaceInformation.this.recursionPreventer = false;
                }
            }
        });
        this.interfaceTargetText.setEditable(!this.isReadOnly());
        Label callTypeLabel = new Label((Composite)groupTarget, 0);
        callTypeLabel.setLayoutData((Object)GridDataCreator.normal());
        callTypeLabel.setText(AdditionalInterfaceInformation.getClassString("calltype"));
        if (this.isRestProject()) {
            this.callTypeCombo = new ComboViewer((Composite)groupTarget, 12);
            this.callTypeCombo.getCombo().setLayoutData((Object)GridDataCreator.horizontalFill());
            this.callTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.callTypeCombo.setInput((Object)new String[]{"GET", "POST", "PUT", "DELETE"});
            this.callTypeCombo.getCombo().setFont(font);
            this.callTypeCombo.getCombo().setForeground(color);
            this.callTypeCombo.setSelection((ISelection)this.getSavvyCallTypeCombo(), true);
            this.callTypeCombo.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (AdditionalInterfaceInformation.this.recursionPreventer) {
                        return;
                    }
                    try {
                        AdditionalInterfaceInformation.this.recursionPreventer = true;
                        String newTarget = (String)((StructuredSelection)AdditionalInterfaceInformation.this.callTypeCombo.getSelection()).getFirstElement();
                        String oldTarget = AdditionalInterfaceInformation.this.doc.getInterface().getCallType();
                        if (newTarget == null && oldTarget != null || newTarget != null && !newTarget.equals(oldTarget)) {
                            SetCommand cmd = new SetCommand(AdditionalInterfaceInformation.this.editingDomain, (EObject)AdditionalInterfaceInformation.this.doc.getInterface(), (EStructuralFeature)InterfacePackage.eINSTANCE.getInterface_CallType(), (Object)newTarget);
                            AdditionalInterfaceInformation.this.editingDomain.getCommandStack().execute((Command)cmd);
                        }
                    }
                    finally {
                        AdditionalInterfaceInformation.this.recursionPreventer = false;
                    }
                }
            });
            this.callTypeCombo.getCombo().setEnabled(!this.isReadOnly());
        } else {
            this.callTypeText = new Text((Composite)groupTarget, 2052);
            this.callTypeText.setLayoutData((Object)GridDataCreator.horizontalFill());
            this.callTypeText.setFont(font);
            this.callTypeText.setForeground(color);
            this.callTypeText.setText(this.getSavvyCallTypeText());
            this.callTypeText.addKeyListener((KeyListener)this.getCheckEditingListener());
            this.callTypeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (AdditionalInterfaceInformation.this.recursionPreventer) {
                        return;
                    }
                    try {
                        AdditionalInterfaceInformation.this.recursionPreventer = true;
                        String newCallType = AdditionalInterfaceInformation.this.callTypeText.getText().trim();
                        String oldCallType = AdditionalInterfaceInformation.this.doc.getInterface().getCallType();
                        if (!newCallType.equals(oldCallType)) {
                            SetCommand cmd = new SetCommand(AdditionalInterfaceInformation.this.editingDomain, (EObject)AdditionalInterfaceInformation.this.doc.getInterface(), (EStructuralFeature)InterfacePackage.eINSTANCE.getInterface_CallType(), (Object)newCallType);
                            AdditionalInterfaceInformation.this.editingDomain.getCommandStack().execute((Command)cmd);
                        }
                    }
                    finally {
                        AdditionalInterfaceInformation.this.recursionPreventer = false;
                    }
                }
            });
            this.callTypeText.setEditable(!this.isReadOnly());
        }
        final Group groupListructures = new Group(comp, 16){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle trim = this.computeTrim(0, 0, 0, 0);
                Point tfsSize = AdditionalInterfaceInformation.this.tfs.getControl().computeSize(wHint, hHint, changed);
                return new Point(600, tfsSize.y - trim.y + trim.height);
            }

            protected void checkSubclass() {
            }
        };
        groupListructures.setText("Listructures");
        groupListructures.setLayoutData((Object)GridDataCreator.fill());
        groupListructures.setFont(font);
        groupListructures.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = groupListructures.getClientArea();
                Point computeSize = AdditionalInterfaceInformation.this.tfs.getControl().computeSize(-1, -1, false);
                AdditionalInterfaceInformation.this.tfs.getControl().setBounds(clientArea.x, clientArea.y, clientArea.width, Math.max(clientArea.height, computeSize.y));
            }
        });
        this.tfs = new TreeFileSelector((Composite)groupListructures, 0);
        this.tfs.setProjectRestriction(containingProject);
        this.tfs.setFileTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.LISTRUCTURE});
        this.tfs.setFont(font);
        this.tfs.setColor(color);
        this.tfs.addDualListListener((DualListListener)new DualListAdapter<IFile>(){

            public void movementEvent(int side, List<ElementInformation<IFile>> elements) {
                if (AdditionalInterfaceInformation.this.recursionPreventer) {
                    return;
                }
                try {
                    AdditionalInterfaceInformation.this.recursionPreventer = true;
                    if (!AdditionalInterfaceInformation.this.checkEditing()) {
                        AdditionalInterfaceInformation.this.tfs.undoMovement(side, elements);
                        return;
                    }
                    CompoundCommand cc = new CompoundCommand();
                    if (side == 1) {
                        for (ElementInformation<IFile> info : elements) {
                            SavvytestSettings.INSTANCE.getLogger().log("Adding: " + info, LogLevel.DEBUG, (Object)this);
                            Resource res = AdditionalInterfaceInformation.this.editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)((IFile)info.element).getFullPath().toString(), (boolean)true), true);
                            com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot docRoot = (com.savvytest.eclipse.core.model.xml.listructure.DocumentRoot)res.getContents().get(0);
                            AddListructureCommand alc = new AddListructureCommand(AdditionalInterfaceInformation.this.editor, docRoot.getListructure());
                            cc.append((Command)alc);
                        }
                    } else if (side == 2) {
                        int i = elements.size() - 1;
                        while (i >= 0) {
                            ElementInformation<IFile> info = elements.get(i);
                            SavvytestSettings.INSTANCE.getLogger().log("Removing: " + info, LogLevel.DEBUG, (Object)this);
                            RemoveListructureCommand rlc = new RemoveListructureCommand(AdditionalInterfaceInformation.this.editor, info.oldPosition);
                            cc.append((Command)rlc);
                            --i;
                        }
                    }
                    if (cc.canExecute()) {
                        AdditionalInterfaceInformation.this.editingDomain.getCommandStack().execute((Command)cc);
                    } else {
                        SavvytestSettings.INSTANCE.getLogger().log("Could not execute command to add/remove interface-arguments.", LogLevel.ERROR, (Object)this);
                    }
                }
                finally {
                    AdditionalInterfaceInformation.this.recursionPreventer = false;
                }
            }

            public void positionEvent(int side, List<ElementInformation<IFile>> elements) {
                if (AdditionalInterfaceInformation.this.recursionPreventer || side != 1) {
                    return;
                }
                try {
                    AdditionalInterfaceInformation.this.recursionPreventer = true;
                    if (!AdditionalInterfaceInformation.this.checkEditing()) {
                        AdditionalInterfaceInformation.this.tfs.undoPosition(side, elements);
                        return;
                    }
                    CompoundCommand cc = new CompoundCommand();
                    InterfaceUi ifaceUi = (InterfaceUi)AdditionalInterfaceInformation.this.resource.getContents().get(1);
                    for (ElementInformation<IFile> info : elements) {
                        SavvytestSettings.INSTANCE.getLogger().log("Moving: " + info, LogLevel.DEBUG, (Object)this);
                        SwapCommand sc1 = new SwapCommand(AdditionalInterfaceInformation.this.editingDomain, (EObject)AdditionalInterfaceInformation.this.doc.getInterface(), (EStructuralFeature)InterfacePackage.Literals.INTERFACE__ARGUMENTS, info.oldPosition, info.newPosition);
                        SwapCommand sc2 = new SwapCommand(AdditionalInterfaceInformation.this.editingDomain, (EObject)ifaceUi, (EStructuralFeature)InterfaceUiPackage.Literals.INTERFACE_UI__ARGUMENTS_UI, info.oldPosition, info.newPosition);
                        cc.append((Command)sc1);
                        cc.append((Command)sc2);
                    }
                    if (cc.canExecute()) {
                        AdditionalInterfaceInformation.this.editingDomain.getCommandStack().execute((Command)cc);
                    } else {
                        SavvytestSettings.INSTANCE.getLogger().log("Could not execute command to reorder interface-arguments.", LogLevel.ERROR, (Object)this);
                    }
                }
                finally {
                    AdditionalInterfaceInformation.this.recursionPreventer = false;
                }
            }
        });
        if (!this.recursionPreventer) {
            try {
                this.recursionPreventer = true;
                this.setToDLS((List<Argument>)this.doc.getInterface().getArguments());
            }
            finally {
                this.recursionPreventer = false;
            }
        }
        this.scrollComp.setMinSize(comp.computeSize(-1, -1, true));
        this.doc.getInterface().eAdapters().add((Object)this.modelChangeAdapter);
        this.getCutCopyPasteHandler().addText(this.interfaceTargetText);
    }

    private void setToDLS(List<Argument> arguments) {
        ArrayList<IFile> selectedFiles = new ArrayList<IFile>(arguments.size());
        for (Argument argument : arguments) {
            String filename = argument.getListructure().eResource().getURI().toPlatformString(true);
            IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(filename);
            selectedFiles.add(file);
        }
        this.tfs.setSelected(selectedFiles);
    }

    public void dispose() {
        if (this.init && this.doc != null) {
            this.doc.getInterface().eAdapters().remove((Object)this.modelChangeAdapter);
        }
        this.getCutCopyPasteHandler().removeText(this.interfaceTargetText);
        super.dispose();
    }

    protected String getSavvyTarget() {
        String value = this.doc.getInterface().getTarget();
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getSavvyCallTypeText() {
        String value = this.doc.getInterface().getCallType();
        if (value == null) {
            return "";
        }
        return value;
    }

    protected StructuredSelection getSavvyCallTypeCombo() {
        String value = this.doc.getInterface().getCallType();
        if (value == null || value.trim().isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)value);
    }

    protected EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected EObject getSavvyNameOwner() {
        return this.doc.getInterface();
    }

    protected EObject getSavvyAliasOwner() {
        return this.doc.getInterface();
    }

    protected EObject getSavvyDescriptionOwner() {
        return this.doc.getInterface();
    }

    protected EStructuralFeature getSavvyNameFeature() {
        return InterfacePackage.Literals.INTERFACE__NAME;
    }

    protected EStructuralFeature getSavvyAliasFeature() {
        return InterfacePackage.Literals.INTERFACE__ALIAS;
    }

    protected EStructuralFeature getSavvyDescriptionFeature() {
        return InterfacePackage.Literals.INTERFACE__DESCRIPTION;
    }

    protected boolean isReadOnly() {
        return this.editor.isReadOnly();
    }

    protected boolean checkEditing() {
        boolean result = super.checkEditing();
        if (!result) {
            this.editor.handleActivate();
        }
        return result;
    }

    public void refresh() {
        this.editingDomain = this.editor.getEditingDomain();
        this.resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.doc = (DocumentRoot)this.resource.getContents().get(0);
        if (this.init) {
            try {
                this.recursionPreventer = true;
                this.setToDLS((List<Argument>)this.doc.getInterface().getArguments());
                this.interfaceTargetText.setText(this.getSavvyTarget());
            }
            finally {
                this.recursionPreventer = false;
            }
        }
        super.refresh();
    }

    private boolean isRestProject() {
        return this.editor.isRestProject();
    }
}

