/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.result.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.result.Result;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.editor.result.gui.SavvytestResultEditor;
import com.savvytest.eclipse.editor.testscenario.gui.SavvytestTestscenarioEditor;
import com.savvytest.eclipse.reportgenerator.AbstractResultReportGenerator;
import com.savvytest.eclipse.reportgenerator.IResultReportGenerator;
import com.savvytest.eclipse.resultchecker.JexlResultchecker;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class ResultPage {
    private static final Pattern TESTCASE_PATTERN = Pattern.compile("^about:blank#\\{testscenario:(.+?)\\}\\{testcase:(.+?)\\}$");
    private static final Pattern TESTSCENARIO_PATTERN = Pattern.compile("^about:blank#\\{testscenario:(.+?)\\}$");
    private static final Pattern TESTSUITE_PATTERN = Pattern.compile("^about:blank#\\{testsuite:(.+?)\\}$");
    private final SavvytestResultEditor editor;
    private String htmlReport;
    private Browser browser;

    public ResultPage(SavvytestResultEditor editor) {
        this.editor = editor;
    }

    public Control createPage(Composite parent) {
        this.createReport();
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.setText(this.htmlReport);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                String location = event.location;
                event.doit = false;
                String id = null;
                String testcaseId = null;
                SavvytestTypeEnum type = null;
                Matcher testcaseMatcher = TESTCASE_PATTERN.matcher(location);
                if (testcaseMatcher.matches()) {
                    id = testcaseMatcher.group(1);
                    testcaseId = testcaseMatcher.group(2);
                    type = SavvytestTypeEnum.TESTSCENARIO;
                } else {
                    Matcher testscenarioMatcher = TESTSCENARIO_PATTERN.matcher(location);
                    if (testscenarioMatcher.matches()) {
                        id = testscenarioMatcher.group(1);
                        type = SavvytestTypeEnum.TESTSCENARIO;
                    } else {
                        Matcher testsuiteMatcher = TESTSUITE_PATTERN.matcher(location);
                        if (testsuiteMatcher.matches()) {
                            id = testsuiteMatcher.group(1);
                            type = SavvytestTypeEnum.TESTSUITE;
                        }
                    }
                }
                if (id != null && type != null) {
                    try {
                        IEditorPart openedEditor = ResultPage.this.editor.openFile(type, id);
                        if (testcaseId != null && openedEditor instanceof SavvytestTestscenarioEditor) {
                            ((SavvytestTestscenarioEditor)openedEditor).setActiveTestcase(testcaseId);
                        }
                        ResultPage.this.browser.setText(ResultPage.this.htmlReport);
                    }
                    catch (Exception e) {
                        SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                        MessageDialog.openError((Shell)ResultPage.this.browser.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)e.getMessage());
                    }
                }
            }
        });
        return this.browser;
    }

    private Result getResult() {
        Archive archive = this.editor.getArchive();
        if (archive.getResult() != null) {
            return archive.getResult();
        }
        String hexEncoding = PropertiesUtils.getStringProperty((Properties)archive.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.HEX_ENCODING);
        return JexlResultchecker.getResult((Testsuite)archive.getTestsuite(), (String)hexEncoding);
    }

    private void createReport() {
        Archive archive = this.editor.getArchive();
        if (archive == null) {
            this.htmlReport = "";
            return;
        }
        Result result = this.getResult();
        HashMap archiveProperties = PropertiesUtils.getPropertiesMap((Properties)archive.getProperties());
        IResultReportGenerator generator = AbstractResultReportGenerator.getGenerator();
        generator.setResult(result.getTestsuiteResult());
        generator.setArchiveProperties((Map)archiveProperties);
        this.htmlReport = generator.generateReport();
    }

    public void handleChangedResources() {
        if (this.browser != null) {
            this.createReport();
            this.browser.setText(this.htmlReport);
        }
    }

    public void printResult() {
        if (this.browser == null) {
            return;
        }
        this.browser.execute("javascript:print()");
    }
}

