/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.result.gui;

import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.ContainerData;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.InputOutputDualism;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.editor.result.gui.ResultEditorPlugin;
import com.savvytest.eclipse.editor.result.gui.SavvytestResultEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DetailPage {
    private static final java.lang.String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.result.gui.DetailPage.";
    private final SavvytestResultEditor editor;
    private TreeViewer outputDataTreeViewer;
    private TreeViewer inputDataTreeViewer;
    private final DataContentProvider inputDataContentProvider = new DataContentProvider(InputOutputDualism.INPUT);
    private final DataContentProvider outputDataContentProvider = new DataContentProvider(InputOutputDualism.OUTPUT);
    private InputOutputDualism selectionSource;
    private Testcase currentTestcase;

    private static java.lang.String getClassString(java.lang.String key) {
        return ResultEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public DetailPage(SavvytestResultEditor editor) {
        this.editor = editor;
    }

    public Control createPage(Composite parent) {
        Archive archive = this.editor.getArchive();
        if (archive == null) {
            return new Composite(parent, 0);
        }
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite body = toolkit.createComposite(parent);
        body.setLayout((Layout)new GridLayout(2, true));
        Composite leftComposite = toolkit.createComposite(body, 0);
        GridData leftGD = GridDataCreator.fill();
        leftGD.heightHint = 150;
        leftComposite.setLayoutData((Object)leftGD);
        leftComposite.setLayout((Layout)new FillLayout());
        this.createInputSection(toolkit, leftComposite);
        Composite rightComposite = toolkit.createComposite(body, 0);
        GridData rightGD = GridDataCreator.fill();
        rightGD.heightHint = 150;
        rightComposite.setLayoutData((Object)rightGD);
        rightComposite.setLayout((Layout)new FillLayout());
        this.createOutputSection(toolkit, rightComposite);
        Label reminderLabel = new Label(body, 0);
        reminderLabel.setLayoutData((Object)GridDataCreator.horizontalSpan((GridData)GridDataCreator.horizontalFill(), (int)2));
        reminderLabel.setText(DetailPage.getClassString("reminder"));
        toolkit.paintBordersFor(leftComposite);
        toolkit.paintBordersFor(rightComposite);
        this.handleChangedResources();
        return body;
    }

    public void handleChangedResources() {
        if (this.inputDataTreeViewer == null || this.inputDataTreeViewer.getControl().isDisposed()) {
            return;
        }
        if (this.editor != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)this.editor.getArchive()));
        }
    }

    private void createInputSection(FormToolkit toolkit, Composite composite) {
        Section artifactSection = toolkit.createSection(composite, 256);
        artifactSection.setText(DetailPage.getClassString("headerinput"));
        Composite artifactComposite = toolkit.createComposite((Composite)artifactSection, 0);
        toolkit.adapt(artifactComposite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 1;
        artifactComposite.setLayout((Layout)gridLayout);
        artifactSection.setClient((Control)artifactComposite);
        this.inputDataTreeViewer = new TreeViewer(artifactComposite, 65536);
        Tree tree = this.inputDataTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn treeColumn = new TreeViewerColumn(this.inputDataTreeViewer, 0);
        treeColumn.getColumn().setText(DetailPage.getClassString("structure"));
        treeColumn.getColumn().setResizable(true);
        treeColumn.getColumn().setWidth(250);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.inputDataTreeViewer, 0);
        valueColumn.getColumn().setText(DetailPage.getClassString("value"));
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setWidth(125);
        this.inputDataTreeViewer.setColumnProperties(new java.lang.String[]{"ColumnStructure", "ColumnValue"});
        this.inputDataTreeViewer.setAutoExpandLevel(4);
        this.inputDataTreeViewer.setContentProvider((IContentProvider)this.inputDataContentProvider);
        this.inputDataTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editor.getAdapterFactory()){

            public java.lang.String getColumnText(Object object, int columnIndex) {
                if (object instanceof Atomic && columnIndex == 1) {
                    Object value = ((Atomic)object).getEffectiveValue();
                    if (value != null) {
                        return value.toString();
                    }
                    return null;
                }
                return super.getColumnText(object, columnIndex);
            }
        });
        this.inputDataTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!InputOutputDualism.OUTPUT.equals((Object)DetailPage.this.selectionSource)) {
                    Argument arg;
                    DetailPage.this.selectionSource = InputOutputDualism.INPUT;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof Data) {
                        Data data = (Data)element;
                        java.lang.String id = data.calculateInputId();
                        Data outputData = DetailPage.this.outputDataContentProvider.getDataIdMap().get(id);
                        if (outputData != null) {
                            DetailPage.this.outputDataTreeViewer.setSelection((ISelection)new StructuredSelection((Object)outputData));
                        }
                    } else if (element instanceof Argument && !(arg = (Argument)element).getParameters().getParameters().isEmpty()) {
                        Data data = (Data)((FeatureMap.Entry)arg.getParameters().getParameters().get(0)).getValue();
                        java.lang.String id = data.calculateInputId();
                        java.lang.String argId = id.substring(0, id.indexOf("."));
                        Argument outputArg = DetailPage.this.outputDataContentProvider.getArgIdMap().get(argId);
                        if (outputArg != null) {
                            DetailPage.this.outputDataTreeViewer.setSelection((ISelection)new StructuredSelection((Object)outputArg));
                        }
                    }
                }
                DetailPage.this.selectionSource = null;
            }
        });
        toolkit.adapt((Composite)this.inputDataTreeViewer.getTree());
        toolkit.paintBordersFor(artifactComposite);
        CollapseAction collapseAction = new CollapseAction(this.inputDataTreeViewer, false);
        ExpandAction expandAction = new ExpandAction(this.inputDataTreeViewer, false);
        this.createContextMenu((Viewer)this.inputDataTreeViewer, new IAction[]{collapseAction, expandAction});
    }

    private void createOutputSection(FormToolkit toolkit, Composite composite) {
        Section artifactSection = toolkit.createSection(composite, 256);
        artifactSection.setText(DetailPage.getClassString("headeroutput"));
        Composite artifactComposite = toolkit.createComposite((Composite)artifactSection, 0);
        toolkit.adapt(artifactComposite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 1;
        artifactComposite.setLayout((Layout)gridLayout);
        artifactSection.setClient((Control)artifactComposite);
        this.outputDataTreeViewer = new TreeViewer(artifactComposite, 65536);
        Tree tree = this.outputDataTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn treeColumn = new TreeViewerColumn(this.outputDataTreeViewer, 0);
        treeColumn.getColumn().setText(DetailPage.getClassString("structure"));
        treeColumn.getColumn().setResizable(true);
        treeColumn.getColumn().setWidth(250);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.outputDataTreeViewer, 0);
        valueColumn.getColumn().setText(DetailPage.getClassString("value"));
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setWidth(125);
        this.outputDataTreeViewer.setColumnProperties(new java.lang.String[]{"ColumnStructure", "ColumnValue"});
        this.outputDataTreeViewer.setAutoExpandLevel(4);
        this.outputDataTreeViewer.setContentProvider((IContentProvider)this.outputDataContentProvider);
        this.outputDataTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editor.getAdapterFactory()));
        this.outputDataTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!InputOutputDualism.INPUT.equals((Object)DetailPage.this.selectionSource)) {
                    Argument arg;
                    DetailPage.this.selectionSource = InputOutputDualism.OUTPUT;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof Data) {
                        Data data = (Data)element;
                        java.lang.String id = data.calculateOutputId();
                        Data inputData = DetailPage.this.inputDataContentProvider.getDataIdMap().get(id);
                        if (inputData != null) {
                            DetailPage.this.inputDataTreeViewer.setSelection((ISelection)new StructuredSelection((Object)inputData));
                        }
                    } else if (element instanceof Argument && !(arg = (Argument)element).getParameters().getParameters().isEmpty()) {
                        Data data = (Data)((FeatureMap.Entry)arg.getParameters().getParameters().get(0)).getValue();
                        java.lang.String id = data.calculateOutputId();
                        java.lang.String argId = id.substring(0, id.indexOf("."));
                        Argument inputArg = DetailPage.this.inputDataContentProvider.getArgIdMap().get(argId);
                        if (inputArg != null) {
                            DetailPage.this.inputDataTreeViewer.setSelection((ISelection)new StructuredSelection((Object)inputArg));
                        }
                    }
                }
                DetailPage.this.selectionSource = null;
            }
        });
        toolkit.adapt((Composite)this.outputDataTreeViewer.getTree());
        toolkit.paintBordersFor(artifactComposite);
        CollapseAction collapseAction = new CollapseAction(this.outputDataTreeViewer, false);
        ExpandAction expandAction = new ExpandAction(this.outputDataTreeViewer, false);
        this.createContextMenu((Viewer)this.outputDataTreeViewer, new IAction[]{collapseAction, expandAction});
    }

    private void createContextMenu(Viewer viewer, IAction ... actions) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            contextMenu.add(action);
            ++n2;
        }
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public void setSelection(ISelection selection) {
        Object element = ((IStructuredSelection)selection).getFirstElement();
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)element);
        if (!(unwrapped instanceof EObject)) {
            return;
        }
        Testcase testcase = this.getTestcase((EObject)unwrapped);
        if (testcase == null) {
            this.currentTestcase = null;
            this.inputDataTreeViewer.setInput(null);
            this.outputDataTreeViewer.setInput(null);
            return;
        }
        if (testcase != this.currentTestcase) {
            this.currentTestcase = testcase;
            this.inputDataTreeViewer.setInput((Object)testcase.getInputUi());
            this.outputDataTreeViewer.setInput((Object)testcase.getOutputUi());
        }
        if (unwrapped instanceof Data) {
            this.inputDataTreeViewer.setSelection((ISelection)new StructuredSelection(unwrapped), true);
        }
    }

    private Testcase getTestcase(EObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Testcase) {
            return (Testcase)obj;
        }
        if (obj instanceof Testscenario) {
            return (Testcase)((Testscenario)obj).getTestcases().getTestcases().get(0);
        }
        if (obj instanceof Testsuite) {
            return this.getTestcase((EObject)((Testsuite)obj).getTestscenarios().get(0));
        }
        if (obj instanceof Archive) {
            return this.getTestcase((EObject)((Archive)obj).getTestsuite());
        }
        return this.getTestcase(obj.eContainer());
    }

    public static class DataContentProvider
    implements ITreeContentProvider {
        private Map<java.lang.String, Data> dataIdMap;
        private Map<java.lang.String, Argument> argIdMap;
        private final InputOutputDualism usage;

        public DataContentProvider(InputOutputDualism usage) {
            this.usage = usage;
        }

        public Map<java.lang.String, Data> getDataIdMap() {
            return this.dataIdMap;
        }

        public Map<java.lang.String, Argument> getArgIdMap() {
            return this.argIdMap;
        }

        public Object[] getElements(Object object) {
            if (object instanceof List) {
                return ((List)object).toArray();
            }
            if (object instanceof Argument) {
                ArrayList<Data> list = new ArrayList<Data>();
                ListIterator iterator = ((Argument)object).getParameters().getParameters().listIterator();
                while (iterator.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)iterator.next();
                    list.add((Data)entry.getValue());
                }
                return list.toArray();
            }
            if (object instanceof ContainerData) {
                ArrayList<Data> list = new ArrayList<Data>();
                ListIterator iterator = ((ContainerData)object).getElements().listIterator();
                while (iterator.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)iterator.next();
                    list.add((Data)entry.getValue());
                }
                return list.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof EObject) {
                return ((EObject)object).eContainer();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return this.getElements(object);
        }

        public boolean hasChildren(Object object) {
            return this.getElements(object).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.dataIdMap = new HashMap<java.lang.String, Data>();
            this.argIdMap = new HashMap<java.lang.String, Argument>();
            if (newInput instanceof List) {
                List arguments = (List)newInput;
                for (Argument argument : arguments) {
                    java.lang.String argId = null;
                    for (FeatureMap.Entry entry : argument.getParameters().getParameters()) {
                        Data data = (Data)entry.getValue();
                        PopulateDataIdMapVisitor visitor = new PopulateDataIdMapVisitor(this.usage);
                        try {
                            data.accept((DataVisitor)visitor);
                            this.dataIdMap.putAll(visitor.getDataIdMap());
                            if (visitor.getDataIdMap().keySet().isEmpty()) continue;
                            argId = visitor.getDataIdMap().keySet().iterator().next();
                        }
                        catch (Exception e) {
                            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                        }
                    }
                    int index = argId.indexOf(".");
                    java.lang.String key = argId.substring(0, index);
                    this.argIdMap.put(key, argument);
                }
            }
        }

        public void dispose() {
            this.dataIdMap = null;
            this.argIdMap = null;
        }
    }

    private static class PopulateDataIdMapVisitor
    implements DataVisitor {
        private final Map<java.lang.String, Data> dataIdMap;
        private final InputOutputDualism usage;

        public PopulateDataIdMapVisitor(InputOutputDualism usage) {
            this.usage = usage;
            this.dataIdMap = new HashMap<java.lang.String, Data>();
        }

        public Map<java.lang.String, Data> getDataIdMap() {
            return this.dataIdMap;
        }

        public Object visit(Struct struct) throws Exception {
            java.lang.String id = null;
            if (InputOutputDualism.INPUT.equals((Object)this.usage)) {
                id = struct.calculateInputId();
            } else if (InputOutputDualism.OUTPUT.equals((Object)this.usage)) {
                id = struct.calculateOutputId();
            }
            this.dataIdMap.put(id, (Data)struct);
            for (FeatureMap.Entry entry : struct.getElements()) {
                Data data = (Data)entry.getValue();
                data.accept((DataVisitor)this);
            }
            return null;
        }

        public Object visit(Array array) throws Exception {
            java.lang.String id = null;
            if (InputOutputDualism.INPUT.equals((Object)this.usage)) {
                id = array.calculateInputId();
            } else if (InputOutputDualism.OUTPUT.equals((Object)this.usage)) {
                id = array.calculateOutputId();
            }
            this.dataIdMap.put(id, (Data)array);
            for (FeatureMap.Entry entry : array.getElements()) {
                Data data = (Data)entry.getValue();
                data.accept((DataVisitor)this);
            }
            return null;
        }

        public Object visit(String string) throws Exception {
            return this.visitAtomic((Atomic)string);
        }

        public Object visit(Number number) throws Exception {
            return this.visitAtomic((Atomic)number);
        }

        public Object visit(Boolean bool) throws Exception {
            return this.visitAtomic((Atomic)bool);
        }

        private Object visitAtomic(Atomic atomic) {
            java.lang.String id = null;
            if (InputOutputDualism.INPUT.equals((Object)this.usage)) {
                id = atomic.calculateInputId();
            } else if (InputOutputDualism.OUTPUT.equals((Object)this.usage)) {
                id = atomic.calculateOutputId();
            }
            this.dataIdMap.put(id, (Data)atomic);
            return null;
        }
    }
}

