/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.result.gui.wizard;

import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.archive.Archive;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.editor.result.gui.ResultEditorPlugin;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TestscenarioSelectionPage
extends WizardPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.result.gui.wizard.TestscenarioSelectionPage.";
    private IFile archiveFile;
    private Archive archive;
    private final Map<Testscenario, TestscenarioSelectionComponent> testscenarioMap = new HashMap<Testscenario, TestscenarioSelectionComponent>();

    private static String getClassString(String key, Object ... substitutes) {
        String translation = ResultEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    protected TestscenarioSelectionPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout());
        this.setControl((Control)body);
        this.update();
    }

    private void update() {
        Composite body = (Composite)this.getControl();
        Control[] controlArray = body.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.testscenarioMap.clear();
        if (this.getArchive() != null) {
            for (Testscenario testscenario : this.getArchive().getTestscenarios()) {
                IProject project = this.getArchiveFile().getProject();
                TestscenarioSelectionComponent component = new TestscenarioSelectionComponent();
                component.setLabel(testscenario.getName());
                component.setProjectRestriction(project);
                IFile file = project.getFile(URI.decode((String)testscenario.getId()));
                if (file.exists()) {
                    component.setFile(file);
                }
                Control control = component.createControl(body);
                control.setLayoutData((Object)GridDataCreator.horizontalFill());
                this.testscenarioMap.put(testscenario, component);
            }
        }
        body.layout();
    }

    public void setArchiveFile(IFile archiveFile) {
        this.archiveFile = archiveFile;
        Archive archive = this.archive = archiveFile != null ? EditingUtility.loadArchive((IFile)archiveFile, null) : null;
        if (this.getControl() != null) {
            this.update();
        }
    }

    public IFile getArchiveFile() {
        return this.archiveFile;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public Map<Testscenario, IFile> getFiles() {
        LinkedHashMap<Testscenario, IFile> files = new LinkedHashMap<Testscenario, IFile>(this.testscenarioMap.size());
        for (Map.Entry<Testscenario, TestscenarioSelectionComponent> entry : this.testscenarioMap.entrySet()) {
            IFile file = entry.getValue().getFile();
            if (file == null) continue;
            files.put(entry.getKey(), file);
        }
        return files;
    }

    private static class TestscenarioSelectionComponent {
        private String label;
        private Control control;
        private Text text;
        private IFile file;
        private IProject projectRestriction;

        private TestscenarioSelectionComponent() {
        }

        public Control createControl(Composite parent) {
            Composite body = new Composite(parent, 0);
            body.setLayout((Layout)new GridLayout(4, false));
            this.control = body;
            Label label = new Label(body, 0);
            label.setLayoutData((Object)GridDataCreator.normal());
            label.setText(this.label);
            this.text = new Text(body, 2056);
            this.text.setLayoutData((Object)GridDataCreator.horizontalFill());
            this.text.setText(this.file == null ? "" : this.file.getProjectRelativePath().toString());
            Button selectButton = new Button(body, 8);
            selectButton.setLayoutData((Object)GridDataCreator.normal());
            selectButton.setText(TestscenarioSelectionPage.getClassString("TestscenarioSelectionComponent.select", new Object[0]));
            selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFile selectedFile = TestscenarioSelectionComponent.this.selectFile();
                    if (selectedFile != null) {
                        TestscenarioSelectionComponent.this.setFile(selectedFile);
                    }
                }
            });
            Button clearButton = new Button(body, 8);
            clearButton.setLayoutData((Object)GridDataCreator.normal());
            clearButton.setText(TestscenarioSelectionPage.getClassString("TestscenarioSelectionComponent.clear", new Object[0]));
            clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TestscenarioSelectionComponent.this.setFile(null);
                }
            });
            return this.control;
        }

        private IFile selectFile() {
            final SavvytestFileSelection selection = new SavvytestFileSelection();
            selection.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.TESTSCENARIO});
            selection.setProjectRestriction(this.projectRestriction);
            selection.setInitialSelection((IResource)this.getFile());
            TitleAreaDialog dialog = new TitleAreaDialog(this.control.getShell()){

                public void create() {
                    super.create();
                    this.setTitle(TestscenarioSelectionPage.getClassString("TestscenarioSelectionComponent.dialogtitle", new Object[0]));
                    this.setMessage(TestscenarioSelectionPage.getClassString("TestscenarioSelectionComponent.dialogmessage", new Object[0]), 1);
                }

                protected Control createDialogArea(Composite parent) {
                    Composite body = (Composite)super.createDialogArea(parent);
                    Control control = selection.createControl(body, 4096);
                    control.setLayoutData((Object)GridDataCreator.fill());
                    return body;
                }
            };
            dialog.open();
            return selection.getSelectedFile();
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setFile(IFile file) {
            this.file = file;
            if (this.text != null) {
                this.text.setText(file == null ? "" : file.getProjectRelativePath().toString());
            }
        }

        public IFile getFile() {
            return this.file;
        }

        public void setProjectRestriction(IProject projectRestriction) {
            this.projectRestriction = projectRestriction;
        }
    }
}

