/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.stub.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.InOutViewerFilter;
import com.savvytest.eclipse.common.util.MissingResourceUtil;
import com.savvytest.eclipse.common.util.ToolTipHandler;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import com.savvytest.eclipse.common.util.editing.CutCopyPasteKeyListener;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.Parameters;
import com.savvytest.eclipse.core.model.xml.data.impl.AtomicImpl;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.stub.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.stub.Stub;
import com.savvytest.eclipse.core.model.xml.stub.StubPackage;
import com.savvytest.eclipse.core.model.xml.stub.impl.StubImpl;
import com.savvytest.eclipse.core.model.xml.stub.util.StubElementMigrationInfo;
import com.savvytest.eclipse.editor.stub.actions.AddArrayAction;
import com.savvytest.eclipse.editor.stub.actions.DuplicateArrayAction;
import com.savvytest.eclipse.editor.stub.actions.RemoveArrayAction;
import com.savvytest.eclipse.editor.stub.gui.AdditionalStubInformation;
import com.savvytest.eclipse.editor.stub.gui.StubEditor;
import com.savvytest.eclipse.editor.stub.gui.StubEditorPlugin;
import com.savvytest.eclipse.editor.stub.migration.StubElementMigration;
import com.savvytest.eclipse.editor.stub.migration.StubElementMigrationDialog;
import com.savvytest.eclipse.editor.stub.preferences.SavvytestPreferencesPage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IUpdateableItemText;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SavvytestStubEditor
extends StubEditor {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.stub.gui.SavvytestStubEditor.";
    protected Disposable disposable = new Disposable();
    protected TreeViewer editDataTreeViewer;
    protected Map<ColumnViewer, IToolBarManager> toolbars = new HashMap<ColumnViewer, IToolBarManager>(5);
    private boolean selectionRecursionPreventer = false;
    private final Color colorForeground = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
    private final Color colorError = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorConflicting");
    private final Color colorDefault = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorInherited");
    private final Font fontForeground = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
    private boolean readOnly;
    private int stubPageIndex = -1;
    private int infoPageIndex = -1;

    private static String getClassString(String key) {
        return SavvytestStubEditor.getString(TRANSLATION_PREFIX + key);
    }

    private static void checkMissingResources(Stub stub, Shell shell) {
        SavvytestSettings.INSTANCE.getLogger().log("Checking for missing resources in stub: " + stub.getName(), LogLevel.DEBUG, SavvytestStubEditor.class);
        Map missingResources = MissingResourceUtil.checkMissingResourcesForStub((Stub)stub);
        if (!missingResources.isEmpty()) {
            String missingResourcesString = MissingResourceUtil.buildMissingResourcesString((Map)missingResources, (String)"\n");
            String msg = MessageFormat.format(SavvytestStubEditor.getClassString("error.missingResource"), missingResourcesString);
            MissingResourceException e = new MissingResourceException(msg, null, null);
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, SavvytestStubEditor.class);
            if (Savvytest.getEclipseVersion().getMajor() == 4) {
                MessageDialog.openError((Shell)shell, (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)msg);
            }
            throw e;
        }
        SavvytestSettings.INSTANCE.getLogger().log("All resources are present.", LogLevel.DEBUG, SavvytestStubEditor.class);
    }

    @Override
    public void dispose() {
        this.disposable.dispose();
        super.dispose();
    }

    @Override
    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        this.readOnly = file != null && file.isReadOnly();
        IStatus licenseErrorMessage = License.getInstance().getLicenseStatus();
        if (!licenseErrorMessage.isOK()) {
            this.getActionBarContributor().getActionBars().getStatusLineManager().setErrorMessage(licenseErrorMessage.getMessage());
        }
    }

    @Override
    public void createModel() {
        super.createModel();
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
        this.updateManager(resource);
        SavvytestStubEditor.checkMissingResources(doc.getStub(), this.getSite().getShell());
        Stub stub = doc.getStub();
        StubElementMigrationInfo info = new StubElementMigrationInfo();
        ((StubImpl)stub).getOutputUi(false, info);
        if (!info.isEmpty()) {
            this.handleMigration(info, stub, resource);
        }
    }

    private boolean handleMigration(StubElementMigrationInfo info, Stub stub, final Resource resource) {
        if (this.isReadOnly()) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)SavvytestStubEditor.getClassString("migrationInfoTitle"), (String)SavvytestStubEditor.getClassString("migrationInfoMessage"));
            SavvytestSettings.INSTANCE.getLogger().log("Migration detected. Found editor in read only state.", LogLevel.DEBUG, (Object)this);
            IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
            IStatus status = EditingUtility.checkEditing((IFile)file, (Shell)this.getSite().getShell());
            if (status.getSeverity() == 8 || status.getSeverity() == 4) {
                SavvytestSettings.INSTANCE.getLogger().log("Migration aborted. Status: " + status, LogLevel.DEBUG, (Object)this);
                return false;
            }
            this.getSite().getShell().getDisplay().timerExec(200, new Runnable(){

                @Override
                public void run() {
                    if (!SavvytestStubEditor.this.changedResources.contains(resource)) {
                        SavvytestStubEditor.this.changedResources.add(resource);
                    }
                    SavvytestSettings.INSTANCE.getLogger().log("Running delayed handleActivate because of migration.", LogLevel.DEBUG, (Object)this);
                    SavvytestStubEditor.this.handleActivate();
                }
            });
            return false;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Doing migration for " + stub.getName() + ". Migration info: " + info, LogLevel.DEBUG, (Object)this);
        StubElementMigration migration = new StubElementMigration(info);
        migration.compute();
        if (!migration.migrationMap.isEmpty()) {
            StubElementMigrationDialog dialog = new StubElementMigrationDialog(this.getSite().getShell(), migration);
            dialog.open();
        }
        migration.applyMap(this.getEditingDomain(), stub);
        return true;
    }

    @Override
    protected void handleActivate() {
        boolean oldReadOnly = this.readOnly;
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        boolean bl = this.readOnly = file != null && file.isReadOnly();
        if (oldReadOnly != this.readOnly) {
            SavvytestSettings.INSTANCE.getLogger().log("Read only status changed to: " + this.readOnly, LogLevel.DEBUG, (Object)this);
        }
        super.handleActivate();
    }

    @Override
    protected void handleChangedResources() {
        super.handleChangedResources();
        if (!this.changedResources.isEmpty()) {
            this.createModel();
            Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
            Stub stub = doc.getStub();
            ISelection oldSelection = this.editDataTreeViewer.getSelection();
            TreePath[] oldTreePaths = this.editDataTreeViewer.getExpandedTreePaths();
            this.editDataTreeViewer.setInput((Object)stub.getOutputUi());
            IElementComparer expandedComparer = new IElementComparer(){

                public int hashCode(Object element) {
                    Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)element);
                    if (unwrapped instanceof Data) {
                        return ((Data)unwrapped).calculateId().hashCode();
                    }
                    if (unwrapped instanceof Parameters) {
                        return this.hashCode(((Parameters)unwrapped).eContainer());
                    }
                    if (unwrapped instanceof com.savvytest.eclipse.core.model.xml.data.Argument) {
                        return this.getIndex((com.savvytest.eclipse.core.model.xml.data.Argument)unwrapped);
                    }
                    return element.hashCode();
                }

                public boolean equals(Object a, Object b) {
                    Object ea = AdapterFactoryEditingDomain.unwrap((Object)a);
                    Object eb = AdapterFactoryEditingDomain.unwrap((Object)b);
                    if (ea.getClass() != eb.getClass()) {
                        return false;
                    }
                    if (ea instanceof Data) {
                        Data da = (Data)ea;
                        Data db = (Data)eb;
                        if (!da.getName().equals(db.getName())) {
                            return false;
                        }
                        return this.equals(da.eContainer(), db.eContainer());
                    }
                    if (ea instanceof Parameters) {
                        return this.equals(((Parameters)ea).eContainer(), ((Parameters)eb).eContainer());
                    }
                    if (ea instanceof com.savvytest.eclipse.core.model.xml.data.Argument) {
                        com.savvytest.eclipse.core.model.xml.data.Argument aa = (com.savvytest.eclipse.core.model.xml.data.Argument)ea;
                        com.savvytest.eclipse.core.model.xml.data.Argument ab = (com.savvytest.eclipse.core.model.xml.data.Argument)eb;
                        if (!aa.getListructure().getId().equals(ab.getListructure().getId())) {
                            return false;
                        }
                        return this.getIndex(aa) == this.getIndex(ab);
                    }
                    return a.equals(b);
                }

                private int getIndex(com.savvytest.eclipse.core.model.xml.data.Argument argument) {
                    Stub sa = (Stub)argument.eContainer();
                    return sa.getOutputUi().indexOf((Object)argument);
                }
            };
            IElementComparer oldComparer = this.editDataTreeViewer.getComparer();
            this.editDataTreeViewer.setComparer(expandedComparer);
            this.editDataTreeViewer.setExpandedTreePaths(oldTreePaths);
            this.editDataTreeViewer.setSelection(oldSelection, true);
            this.editDataTreeViewer.setComparer(oldComparer);
            if (this.infoPageIndex != -1) {
                ((AdditionalStubInformation)this.getControl(this.infoPageIndex)).refresh();
            }
            this.pageChange(this.getActivePage());
        }
    }

    protected boolean checkEditing() {
        IFile file;
        IStatus status;
        if (this.isReadOnly() && (status = EditingUtility.checkEditing((IFile)(file = (IFile)this.getEditorInput().getAdapter(IFile.class)), (Shell)this.getSite().getShell())) != null) {
            if (status.getSeverity() != 8 && status.getSeverity() != 4) {
                this.handleActivate();
            }
            return false;
        }
        return true;
    }

    protected IToolBarManager getToolBarManager(ColumnViewer viewer) {
        Control bar;
        Composite parent;
        IToolBarManager manager = this.toolbars.get(viewer);
        if (manager == null && (parent = viewer.getControl().getParent()) instanceof ViewForm && (bar = ((ViewForm)parent).getTopRight()) instanceof ToolBar) {
            manager = new ToolBarManager((ToolBar)bar);
            this.toolbars.put(viewer, manager);
        }
        return manager;
    }

    @Override
    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.createPageStub();
            this.createPageInformation();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SavvytestStubEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    SavvytestStubEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SavvytestStubEditor.this.updateProblemIndication();
            }
        });
    }

    private boolean isStringLengthTooLong(Object object, String text) {
        Matcher hex;
        BigInteger length;
        Atomic atomic;
        BaseType bt;
        Object obj;
        return text != null && (obj = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof Atomic && (bt = (atomic = (Atomic)obj).getBaseType()) != null && (length = bt.getLength()) != null && ((hex = Savvytest.HEX_NUMBER.matcher(text)).matches() ? hex.group(1).length() / 2 > length.intValue() : text.length() > length.intValue());
    }

    protected void createPageStub() {
        Control mainPageControl;
        License.getInstance().isOptionStubsLicensed();
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                return new TreeViewer(composite, 65536);
            }

            public void requestActivation() {
                super.requestActivation();
                SavvytestStubEditor.this.setCurrentViewerPane(this);
            }
        };
        if (License.getInstance().isOptionStubsLicensed()) {
            viewerPane.createControl(this.getContainer());
            mainPageControl = viewerPane.getControl();
        } else {
            Composite body = new Composite(this.getContainer(), 0);
            GridLayout bodyLayout = new GridLayout();
            bodyLayout.marginWidth = 0;
            bodyLayout.marginHeight = 0;
            bodyLayout.marginBottom = 5;
            body.setLayout((Layout)bodyLayout);
            mainPageControl = body;
            viewerPane.createControl(body);
            viewerPane.getControl().setLayoutData((Object)GridDataCreator.fill());
            Label notLicensedLabel = new Label(body, 0);
            GridData labelLayout = GridDataCreator.horizontalFill();
            labelLayout.horizontalIndent = 5;
            notLicensedLabel.setLayoutData((Object)labelLayout);
            notLicensedLabel.setText(SavvytestStubEditor.getClassString("stubsNotLicensed"));
            notLicensedLabel.setForeground(this.colorError);
            notLicensedLabel.setFont(this.fontForeground);
        }
        IPreferenceStore prefStore = StubEditorPlugin.getPreferenceStore();
        this.editDataTreeViewer = (TreeViewer)viewerPane.getViewer();
        this.editDataTreeViewer.setAutoExpandLevel(4);
        this.editDataTreeViewer.addFilter((ViewerFilter)new InOutViewerFilter(EnumSet.complementOf(EnumSet.of(UsageType.INOUT, UsageType.OUT))));
        this.editDataTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SavvytestStubEditor.this.selectionRecursionPreventer || SavvytestStubEditor.this.contentOutlineViewer == null) {
                    return;
                }
                if (!SavvytestStubEditor.this.contentOutlineViewer.getSelection().equals(event.getSelection())) {
                    SavvytestStubEditor.this.selectionRecursionPreventer = true;
                    SavvytestStubEditor.this.contentOutlineViewer.setSelection(event.getSelection(), true);
                    SavvytestStubEditor.this.selectionRecursionPreventer = false;
                }
            }
        });
        Tree tree = this.editDataTreeViewer.getTree();
        tree.setFont(this.fontForeground);
        tree.setForeground(this.colorForeground);
        tree.setLayoutData((Object)new FillLayout());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        final TreeViewerColumn treeColumn = new TreeViewerColumn(this.editDataTreeViewer, 0);
        treeColumn.getColumn().setText(SavvytestStubEditor.getClassString("column.structure"));
        treeColumn.getColumn().setResizable(true);
        treeColumn.getColumn().setWidth(prefStore.getInt(SavvytestPreferencesPage.STUB_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[0]));
        treeColumn.getColumn().addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                SavvytestStubEditor.this.saveRowPreference(SavvytestPreferencesPage.STUB_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[0], treeColumn.getColumn().getWidth());
            }
        });
        final TreeViewerColumn valueColumn = new TreeViewerColumn(this.editDataTreeViewer, 0);
        valueColumn.getColumn().setText(SavvytestStubEditor.getClassString("column.value"));
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setWidth(prefStore.getInt(SavvytestPreferencesPage.STUB_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[1]));
        valueColumn.getColumn().addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                SavvytestStubEditor.this.saveRowPreference(SavvytestPreferencesPage.STUB_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[1], valueColumn.getColumn().getWidth());
            }
        });
        this.editDataTreeViewer.setColumnProperties(new String[]{"ColumnStructure", "ColumnValue"});
        class TreeLabelProvider
        extends AdapterFactoryLabelProvider
        implements ITableColorProvider {
            private final HashSet<EReference> allowedReferences;

            public TreeLabelProvider(AdapterFactory adapterFactory) {
                super(adapterFactory);
                this.allowedReferences = new HashSet(4);
                this.allowedReferences.add(DataPackage.Literals.CONTAINER_DATA__NUMBER);
                this.allowedReferences.add(DataPackage.Literals.CONTAINER_DATA__STRING);
                this.allowedReferences.add(DataPackage.Literals.PARAMETERS__NUMBER);
                this.allowedReferences.add(DataPackage.Literals.PARAMETERS__STRING);
            }

            public Color getForeground(Object object, int columnIndex) {
                if (columnIndex == 1) {
                    String text = this.getColumnText(object, columnIndex);
                    if (SavvytestStubEditor.this.isStringLengthTooLong(object, text)) {
                        return SavvytestStubEditor.this.colorError;
                    }
                    String value = super.getColumnText(object, columnIndex);
                    if (value == null || value.length() == 0) {
                        return SavvytestStubEditor.this.colorDefault;
                    }
                }
                return super.getForeground(object, columnIndex);
            }

            public String getText(Object object) {
                return this.getColumnText(object, 0);
            }

            public String getColumnText(Object object, int columnIndex) {
                Object obj;
                if (columnIndex == 0) {
                    if (object instanceof DelegatingWrapperItemProvider) {
                        String alias;
                        Data data = (Data)((DelegatingWrapperItemProvider)object).getEditableValue(object);
                        if (data.getBaseTypeExtension() != null && (alias = PropertiesUtils.getStringProperty((Properties)data.getBaseTypeExtension().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS)) != null && alias.length() > 0) {
                            return alias;
                        }
                    } else if (object instanceof com.savvytest.eclipse.core.model.xml.data.Argument) {
                        com.savvytest.eclipse.core.model.xml.data.Argument arg = (com.savvytest.eclipse.core.model.xml.data.Argument)object;
                        String name = arg.getListructure().getName();
                        if (name != null && name.length() > 0) {
                            return String.valueOf(super.getColumnText(object, columnIndex)) + ' ' + name;
                        }
                    } else if (object instanceof Parameters) {
                        Parameters param = (Parameters)object;
                        com.savvytest.eclipse.core.model.xml.data.Argument arg = (com.savvytest.eclipse.core.model.xml.data.Argument)param.eContainer();
                        Stub stub = (Stub)arg.eContainer();
                        int index = stub.getOutputUi().indexOf((Object)arg);
                        Argument argI = (Argument)stub.getInterface().getArguments().get(index);
                        String alias = PropertiesUtils.getStringProperty((Properties)argI.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
                        if (alias != null && alias.length() > 0) {
                            return String.valueOf(super.getColumnText(object, columnIndex)) + ' ' + alias;
                        }
                    }
                } else if (columnIndex == 1 && (obj = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof Atomic) {
                    if ((obj = ((Atomic)obj).getEffectiveValue()) != null) {
                        return obj.toString();
                    }
                    return null;
                }
                return super.getColumnText(object, columnIndex);
            }
        }
        this.editDataTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider((AdapterFactory)this.adapterFactory));
        this.editDataTreeViewer.setContentProvider((IContentProvider)new EditDataContentProvider((AdapterFactory)this.adapterFactory));
        class TreeEditor
        extends AdapterFactoryTreeEditor {
            private final AdapterFactoryLabelProvider labelProvider;
            private final int columnIndex;

            public TreeEditor(Tree tree, AdapterFactory adapterFactory, AdapterFactoryLabelProvider labelProvider, int columnIndex) {
                super(tree, adapterFactory);
                this.labelProvider = labelProvider;
                this.columnIndex = columnIndex;
            }

            private void nextToEdit(TreeItem sibling, TreeItem parent, boolean backwards) {
                if (parent == null) {
                    return;
                }
                int nextIndex = backwards ? (sibling == null ? parent.getItemCount() - 1 : parent.indexOf(sibling) - 1) : (sibling == null ? 0 : parent.indexOf(sibling) + 1);
                if (nextIndex < 0 || nextIndex >= parent.getItemCount()) {
                    this.nextToEdit(parent, parent.getParentItem(), backwards);
                    return;
                }
                final TreeItem next = parent.getItem(nextIndex);
                Object obj = AdapterFactoryEditingDomain.unwrap((Object)next.getData());
                if (obj instanceof EObject) {
                    EObject editable = (EObject)obj;
                    int featureID = editable.eContainingFeature().getFeatureID();
                    if (featureID == 9 || featureID == 8) {
                        Display.getCurrent().timerExec(100, new Runnable(){

                            @Override
                            public void run() {
                                ((TreeEditor)this).SavvytestStubEditor.this.editDataTreeViewer.setSelection((ISelection)new StructuredSelection(next.getData()), true);
                                this.editItem(next);
                            }
                        });
                    } else if (featureID == 11 || featureID == 12) {
                        SavvytestStubEditor.this.editDataTreeViewer.expandToLevel(next.getData(), 1);
                        this.nextToEdit(null, next, backwards);
                    }
                }
            }

            protected void editItem(final TreeItem treeItem) {
                final Object object = treeItem.getData();
                final IUpdateableItemText updateableItemText = (IUpdateableItemText)this.adapterFactory.adapt(object, IUpdateableItemText.class);
                if (updateableItemText != null) {
                    final EObject obj = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
                    String string = updateableItemText.getUpdateableText(object);
                    if (string == null) {
                        return;
                    }
                    if (!SavvytestStubEditor.this.checkEditing()) {
                        return;
                    }
                    this.horizontalAlignment = 16384;
                    this.minimumWidth = Math.max(50, treeItem.getBounds().width);
                    this.tree.showItem(treeItem);
                    final Text text = new Text((Composite)this.tree, 2048);
                    text.setFont(this.tree.getFont());
                    text.setForeground(this.tree.getForeground());
                    text.setBackground(this.tree.getBackground());
                    this.setEditor((Control)text, treeItem);
                    text.setFocus();
                    text.setText(string);
                    text.setSelection(0, string.length());
                    text.addKeyListener((KeyListener)new CutCopyPasteKeyListener(){

                        public void paste() {
                            text.paste();
                        }

                        public void cut() {
                            text.cut();
                        }

                        public void copy() {
                            text.copy();
                        }
                    });
                    text.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent event) {
                            this.updateObject(updateableItemText, object, text.getText());
                            this.setEditor(null);
                            text.dispose();
                        }
                    });
                    text.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            if (event.character == '\r' || event.character == '\n') {
                                if (this.isValid(obj, text.getText())) {
                                    this.updateObject(updateableItemText, object, text.getText());
                                    this.setEditor(null);
                                    text.dispose();
                                    this.nextToEdit(treeItem, treeItem.getParentItem(), false);
                                }
                            } else if (event.character == '\u001b') {
                                this.setEditor(null);
                                text.dispose();
                            }
                        }
                    });
                    text.addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            TreeItem item;
                            if ((e.detail == 16 || e.detail == 8) && (item = this.getItem()) != null && this.isValid(obj, text.getText())) {
                                if (e.detail == 16) {
                                    this.nextToEdit(item, item.getParentItem(), false);
                                } else {
                                    this.nextToEdit(item, item.getParentItem(), true);
                                }
                            }
                        }
                    });
                }
            }

            private boolean isValid(Object object, String text) {
                String formattedText = this.formatText(text);
                if (formattedText == null || formattedText.isEmpty()) {
                    return true;
                }
                if (SavvytestStubEditor.this.isStringLengthTooLong(object, formattedText)) {
                    return false;
                }
                if (object instanceof Number) {
                    try {
                        new BigDecimal(text);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return true;
            }

            private void updateObject(IUpdateableItemText item, Object object, String text) {
                String formattedText = this.formatText(text);
                if (item.getUpdateableText(object).equals(formattedText)) {
                    return;
                }
                if (formattedText == null || formattedText.length() == 0) {
                    item.setText(object, null);
                } else if (!formattedText.equals(this.labelProvider.getColumnText(object, this.columnIndex))) {
                    item.setText(object, formattedText);
                }
            }

            private String formatText(String text) {
                String retString = UtilityFunctions.rightTrim((String)text);
                if (retString.length() == 0 && text.length() > 0) {
                    retString = " ";
                }
                return retString;
            }
        }
        TreeEditor treeEditor = new TreeEditor(this.editDataTreeViewer.getTree(), (AdapterFactory)this.adapterFactory, (AdapterFactoryLabelProvider)this.editDataTreeViewer.getLabelProvider(), 1);
        treeEditor.grabHorizontal = true;
        treeEditor.setColumn(1);
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
        this.editDataTreeViewer.setInput((Object)doc.getStub().getOutputUi());
        IToolBarManager manager = this.getToolBarManager((ColumnViewer)this.editDataTreeViewer);
        ExpandAction expandAllAction = new ExpandAction(this.editDataTreeViewer, true);
        manager.add((IAction)expandAllAction);
        CollapseAction collapseAllAction = new CollapseAction(this.editDataTreeViewer, true);
        manager.add((IAction)collapseAllAction);
        manager.update(true);
        AddArrayAction addArrayAction = new AddArrayAction(this.getEditingDomain(), (ISelectionProvider)this.editDataTreeViewer);
        addArrayAction.setLabelProvider((AdapterFactoryLabelProvider)this.editDataTreeViewer.getLabelProvider(), 0);
        this.disposable.add((Object)addArrayAction);
        DuplicateArrayAction duplicateArrayAction = new DuplicateArrayAction(this.getEditingDomain(), (ISelectionProvider)this.editDataTreeViewer);
        duplicateArrayAction.setLabelProvider((AdapterFactoryLabelProvider)this.editDataTreeViewer.getLabelProvider(), 0);
        this.disposable.add((Object)duplicateArrayAction);
        RemoveArrayAction removeArrayAction = new RemoveArrayAction(this.getEditingDomain(), (ISelectionProvider)this.editDataTreeViewer);
        removeArrayAction.setLabelProvider((AdapterFactoryLabelProvider)this.editDataTreeViewer.getLabelProvider(), 0);
        this.disposable.add((Object)removeArrayAction);
        ExpandAction expandAction = new ExpandAction(this.editDataTreeViewer, false);
        CollapseAction collapseAction = new CollapseAction(this.editDataTreeViewer, false);
        this.createContextMenu((Viewer)this.editDataTreeViewer, new IAction[]{addArrayAction, duplicateArrayAction, removeArrayAction, expandAction, collapseAction});
        ToolTipHandler toolTipHandler = new ToolTipHandler(tree.getShell()){

            public String getHoverText(Object object, int column) {
                String hoverText = null;
                Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
                if (unwrapped instanceof Atomic) {
                    Atomic atomic = (Atomic)unwrapped;
                    switch (column) {
                        case 0: {
                            String id = ((AtomicImpl)atomic).calculateId();
                            hoverText = MessageFormat.format(SavvytestStubEditor.getClassString("tooltipid"), id);
                            break;
                        }
                        case 1: {
                            String liType = PropertiesUtils.getStringProperty((Properties)atomic.getBaseType().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.LI_TYPE);
                            if (liType != null) {
                                liType = MessageFormat.format(SavvytestStubEditor.getClassString("tooltiplistructure"), liType);
                            }
                            String maxLength = null;
                            BigInteger bigInt = atomic.getBaseType().getLength();
                            if (bigInt != null) {
                                maxLength = MessageFormat.format(SavvytestStubEditor.getClassString("tooltiplength"), bigInt);
                            }
                            if (liType != null && maxLength != null) {
                                hoverText = String.valueOf(liType) + '\n' + maxLength;
                                break;
                            }
                            if (liType != null) {
                                hoverText = liType;
                                break;
                            }
                            if (maxLength == null) break;
                            hoverText = maxLength;
                        }
                    }
                }
                return hoverText;
            }

            public Image getHoverImage(Object object, int column) {
                Image hoverImage = null;
                if (AdapterFactoryEditingDomain.unwrap((Object)object) instanceof Atomic) {
                    TreeLabelProvider labelProvider = (TreeLabelProvider)SavvytestStubEditor.this.editDataTreeViewer.getLabelProvider();
                    hoverImage = labelProvider.getImage(object);
                }
                return hoverImage;
            }
        };
        toolTipHandler.activateHoverHelp((Control)tree);
        this.stubPageIndex = this.addPage(mainPageControl);
        this.setPageText(this.stubPageIndex, SavvytestStubEditor.getClassString("pagetitle"));
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{tree, mainPageControl});
    }

    private void createPageInformation() {
        AdditionalStubInformation info = new AdditionalStubInformation(this, this.getContainer(), 0);
        info.init();
        this.infoPageIndex = this.addPage((Control)info);
        this.setPageText(this.infoPageIndex, SavvytestStubEditor.getClassString("infopagetitle"));
    }

    @Override
    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    SavvytestStubEditor.this.contentOutlineViewer = this.getTreeViewer();
                    SavvytestStubEditor.this.contentOutlineViewer.getTree().setFont(SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal"));
                    SavvytestStubEditor.this.contentOutlineViewer.getTree().setForeground(SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground"));
                    SavvytestStubEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    SavvytestStubEditor.this.contentOutlineViewer.setLabelProvider(SavvytestStubEditor.this.editDataTreeViewer.getLabelProvider());
                    SavvytestStubEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new EditDataContentProvider((AdapterFactory)SavvytestStubEditor.this.adapterFactory));
                    SavvytestStubEditor.this.contentOutlineViewer.setFilters(SavvytestStubEditor.this.editDataTreeViewer.getFilters());
                    SavvytestStubEditor.this.contentOutlineViewer.setInput(SavvytestStubEditor.this.editDataTreeViewer.getInput());
                    ExpandAction expandAction = new ExpandAction(SavvytestStubEditor.this.contentOutlineViewer, false);
                    CollapseAction collapseAction = new CollapseAction(SavvytestStubEditor.this.contentOutlineViewer, false);
                    SavvytestStubEditor.this.createContextMenu((Viewer)SavvytestStubEditor.this.contentOutlineViewer, new IAction[]{expandAction, collapseAction});
                    if (!SavvytestStubEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        SavvytestStubEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(SavvytestStubEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    SavvytestStubEditor.this.contentOutlineStatusLineManager = statusLineManager;
                    ExpandAction expandAllAction = new ExpandAction(SavvytestStubEditor.this.contentOutlineViewer, true);
                    expandAllAction.setId("expandAll");
                    toolBarManager.add((IAction)expandAllAction);
                    CollapseAction collapseAllAction = new CollapseAction(SavvytestStubEditor.this.contentOutlineViewer, true);
                    collapseAllAction.setId("collapseAll");
                    toolBarManager.add((IAction)collapseAllAction);
                    toolBarManager.update(true);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    SavvytestStubEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SavvytestStubEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    @Override
    public void handleContentOutlineSelection(ISelection selection) {
        if (this.selectionRecursionPreventer) {
            return;
        }
        try {
            this.selectionRecursionPreventer = true;
            if (this.currentViewerPane != null && selection instanceof IStructuredSelection) {
                if (this.currentViewerPane.getViewer() == this.editDataTreeViewer) {
                    if (!this.editDataTreeViewer.getSelection().equals(selection)) {
                        this.editDataTreeViewer.setSelection(selection, true);
                    }
                } else {
                    TableViewer checkconditionsViewer = (TableViewer)this.currentViewerPane.getViewer();
                    checkconditionsViewer.setSelection(selection);
                }
            }
        }
        finally {
            this.selectionRecursionPreventer = false;
        }
    }

    @Override
    protected void pageChange(int pageIndex) {
        if (this.contentOutlineViewer != null) {
            this.contentOutlineViewer.setInput(null);
            switch (pageIndex) {
                case 0: {
                    this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)this.editDataTreeViewer.getLabelProvider(0));
                    this.contentOutlineViewer.setContentProvider((IContentProvider)new EditDataContentProvider((AdapterFactory)this.adapterFactory));
                    this.contentOutlineViewer.setFilters(this.editDataTreeViewer.getFilters());
                    this.contentOutlineViewer.setInput(this.editDataTreeViewer.getInput());
                    break;
                }
                case 1: {
                    this.contentOutlineViewer.setInput(null);
                    break;
                }
                default: {
                    System.err.println("Unkown page index: " + pageIndex);
                    this.contentOutlineViewer.setInput(null);
                }
            }
        }
        super.pageChange(pageIndex);
    }

    private void saveRowPreference(String storePath, int width) {
        IPreferenceStore store = StubEditorPlugin.getPreferenceStore();
        store.setValue(storePath, width);
    }

    private void createContextMenu(Viewer viewer, IAction ... actions) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            contextMenu.add(action);
            ++n2;
        }
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void updateManager(Resource resource) {
        if (this.isReadOnly()) {
            SavvytestSettings.INSTANCE.getLogger().log("Editor read only. No update.", LogLevel.DEBUG, (Object)this);
            return;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Checking for updates.", LogLevel.DEBUG, (Object)this);
        CompoundCommand cc = new CompoundCommand();
        cc.appendIfCanExecute(this.checkId(resource));
        if (cc.canExecute()) {
            SavvytestSettings.INSTANCE.getLogger().log("Executing updates.", LogLevel.INFO, (Object)this);
            this.getEditingDomain().getCommandStack().execute((Command)cc);
            SavvytestSettings.INSTANCE.getLogger().log("Updates successfully finished.", LogLevel.INFO, (Object)this);
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("No updates found.", LogLevel.DEBUG, (Object)this);
        }
    }

    private Command checkId(Resource resource) {
        SavvytestSettings.INSTANCE.getLogger().log("Checking for update of stub ID.", LogLevel.DEBUG, (Object)this);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            String currentId;
            IFile file = ((FileEditorInput)input).getFile();
            String filepath = URI.encodeOpaquePart((String)file.getProjectRelativePath().toString(), (boolean)true);
            if (!filepath.equals(currentId = root.getStub().getId())) {
                SavvytestSettings.INSTANCE.getLogger().log("Filename: " + filepath + ". Stubg ID: " + currentId + ". Need to update.", LogLevel.DEBUG, (Object)this);
                return new SetCommand(this.getEditingDomain(), (EObject)root.getStub(), (EStructuralFeature)StubPackage.Literals.STUB__ID, (Object)filepath);
            }
            SavvytestSettings.INSTANCE.getLogger().log("No update needed.", LogLevel.DEBUG, (Object)this);
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("Editor input is not a file, can't check for change.", LogLevel.DEBUG, (Object)this);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public class CollectionPassThroughAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public CollectionPassThroughAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            if (object instanceof Object[]) {
                return (Object[])object;
            }
            return super.getElements(object);
        }
    }

    private static class EditDataContentProvider
    extends AdapterFactoryContentProvider {
        public EditDataContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            return super.getElements(object);
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification instanceof IViewerNotification) {
                IViewerNotification noti = (IViewerNotification)notification;
                if (noti.getEventType() == 3 || noti.getEventType() == 4) {
                    ((TreeViewer)this.viewer).refresh(noti.getElement(), true);
                } else if (noti.getEventType() == 1) {
                    ((TreeViewer)this.viewer).update(noti.getElement(), null);
                }
            }
        }
    }
}

