/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.gui;

import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.editor.testscenario.gui.TestcaseComponent;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioEditorPlugin;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TestcaseDialog
extends TitleAreaDialog {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testscenario.gui.TestcaseDialog.";
    private final TestcaseComponent testcaseComponent = new TestcaseComponent();
    private String defaultMessage;
    private String defaultTitle;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = TestscenarioEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public static final TestcaseDialog createNewDialog(Shell parentShell) {
        TestcaseDialog dialog = new TestcaseDialog(parentShell);
        dialog.defaultTitle = TestcaseDialog.getClassString("add.title", new Object[0]);
        dialog.defaultMessage = TestcaseDialog.getClassString("add.message", new Object[0]);
        return dialog;
    }

    public static final TestcaseDialog createDuplicateDialog(Shell parentShell) {
        TestcaseDialog dialog = new TestcaseDialog(parentShell);
        dialog.setEnableInterfaceSelection(false);
        dialog.setAllowInitialName(false);
        dialog.defaultTitle = TestcaseDialog.getClassString("duplicate.title", new Object[0]);
        dialog.defaultMessage = TestcaseDialog.getClassString("duplicate.message", new Object[0]);
        return dialog;
    }

    public static final TestcaseDialog createRenameDialog(Shell parentShell) {
        TestcaseDialog dialog = new TestcaseDialog(parentShell);
        dialog.setEnableInterfaceSelection(false);
        dialog.defaultTitle = TestcaseDialog.getClassString("rename.title", new Object[0]);
        dialog.defaultMessage = TestcaseDialog.getClassString("rename.message", new Object[0]);
        return dialog;
    }

    public static final boolean removeTestcaseDialog(Shell parentShell, String testcaseName) {
        return MessageDialog.openConfirm((Shell)parentShell, (String)TestcaseDialog.getClassString("remove.title", new Object[0]), (String)TestcaseDialog.getClassString("remove.message", testcaseName));
    }

    public static final boolean removeTestcaseDialog(Shell parentShell, String testcaseName, Map<Data, Data> assignationMap) {
        if (assignationMap == null || assignationMap.isEmpty()) {
            return TestcaseDialog.removeTestcaseDialog(parentShell, testcaseName);
        }
        StringBuilder builder = new StringBuilder(100 * assignationMap.size());
        for (Map.Entry<Data, Data> entry : assignationMap.entrySet()) {
            builder.append('\n');
            builder.append(((Testcase)UtilityFunctions.adapt((EObject)((EObject)entry.getKey()), Testcase.class)).getName());
            builder.append(": ");
            builder.append(entry.getKey().getName());
            builder.append(" -> ");
            builder.append(((Testcase)UtilityFunctions.adapt((EObject)((EObject)entry.getValue()), Testcase.class)).getName());
            builder.append(": ");
            builder.append(entry.getValue().getName());
        }
        return MessageDialog.openConfirm((Shell)parentShell, (String)TestcaseDialog.getClassString("remove.title", new Object[0]), (String)TestcaseDialog.getClassString("remove.messageWithAssignation", testcaseName, builder.toString()));
    }

    private TestcaseDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(this.defaultTitle);
        this.setMessage(this.defaultMessage);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = this.testcaseComponent.createControl(parent);
        control.setLayoutData((Object)GridDataCreator.fill());
        return control;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.validate()) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    private boolean validate() {
        String message = this.testcaseComponent.getValidationMessage();
        if (message != null) {
            this.setMessage(message, 3);
            return false;
        }
        this.setMessage(this.defaultMessage);
        return true;
    }

    public void setProjectRestriction(IProject projectRestriction) {
        this.testcaseComponent.setProjectRestriction(projectRestriction);
    }

    public void setEnableInterfaceSelection(boolean enableInterfaceSelection) {
        this.testcaseComponent.setEnableInterfaceSelection(enableInterfaceSelection);
    }

    public void setAllowInitialName(boolean allowInitialName) {
        this.testcaseComponent.setAllowInitialName(allowInitialName);
    }

    public void setTestcases(List<Testcase> testcases) {
        this.testcaseComponent.setTestcases(testcases);
    }

    public void setTestcaseName(String testcaseName) {
        this.testcaseComponent.setTestcaseName(testcaseName);
    }

    public String getTestcaseName() {
        return this.testcaseComponent.getTestcaseName();
    }

    public IFile getInterfaceFile() {
        return this.testcaseComponent.getInterfaceFile();
    }
}

