/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.handlers;

import com.savvytest.eclipse.common.logging.SavvytestErrorHandler;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testscenario.TestscenarioPackage;
import com.savvytest.eclipse.editor.testscenario.gui.SavvytestTestscenarioEditor;
import com.savvytest.eclipse.editor.testscenario.gui.TestcaseDialog;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioEditorPlugin;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioModelWizard;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class NewTestcaseHandler
extends AbstractHandler {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testscenario.handlers.NewTestcaseHandler.";

    private static String getClassString(String key) {
        return TestscenarioEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SavvytestTestscenarioEditor editor = (SavvytestTestscenarioEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Testscenario testscenario = editor.getTestscenario();
        EditingDomain editingDomain = editor.getEditingDomain();
        if (!editor.checkEditing()) {
            return null;
        }
        TestcaseDialog dialog = TestcaseDialog.createNewDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            dialog.setProjectRestriction(((FileEditorInput)editorInput).getFile().getProject());
        }
        dialog.setTestcases((List<Testcase>)testscenario.getTestcases().getTestcases());
        if (dialog.open() == 0) {
            Testcase testcase = null;
            try {
                String testcaseName = dialog.getTestcaseName();
                testcase = TestscenarioModelWizard.createTestcase(dialog.getInterfaceFile(), String.valueOf(testscenario.getId()) + '#' + testcaseName);
            }
            catch (Exception e) {
                Status status = new Status(4, TestscenarioEditorPlugin.getPlugin().getSymbolicName(), NewTestcaseHandler.getClassString("error.creation"), (Throwable)e);
                StatusAdapter adapter = new StatusAdapter((IStatus)status);
                SavvytestErrorHandler.handler.handle(adapter, 3);
            }
            if (testcase != null) {
                Command command = AddCommand.create((EditingDomain)editingDomain, (Object)testscenario.getTestcases(), (Object)TestscenarioPackage.eINSTANCE.getTestcases_Testcases(), (Object)testcase);
                editingDomain.getCommandStack().execute(command);
            }
        }
        return null;
    }
}

