/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.gui.provider;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import com.savvytest.eclipse.common.util.editing.CutCopyPasteKeyListener;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IUpdateableItemText;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class TestcaseDataValueEditor
extends AdapterFactoryTreeEditor {
    private ICheckEditing checkEditing;
    private final TreeViewer viewer;

    static boolean isStringLengthTooLong(Object object, java.lang.String text) {
        Matcher hex;
        BigInteger length;
        BaseType bt;
        Object obj;
        return text != null && (obj = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof String && (bt = ((String)obj).getBaseType()) != null && (length = bt.getLength()) != null && ((hex = Savvytest.HEX_NUMBER.matcher(text)).matches() ? hex.group(1).length() / 2 > length.intValue() : text.length() > length.intValue());
    }

    public TestcaseDataValueEditor(TreeViewer viewer, AdapterFactory adapterFactory) {
        super(viewer.getTree(), adapterFactory);
        this.viewer = viewer;
    }

    private void nextToEdit(TreeItem sibling, TreeItem parent, boolean backwards) {
        if (parent == null) {
            return;
        }
        int nextIndex = backwards ? (sibling == null ? parent.getItemCount() - 1 : parent.indexOf(sibling) - 1) : (sibling == null ? 0 : parent.indexOf(sibling) + 1);
        if (nextIndex < 0 || nextIndex >= parent.getItemCount()) {
            this.nextToEdit(parent, parent.getParentItem(), backwards);
            return;
        }
        final TreeItem next = parent.getItem(nextIndex);
        Object obj = AdapterFactoryEditingDomain.unwrap((Object)next.getData());
        if (obj instanceof EObject) {
            EObject editable = (EObject)obj;
            int featureID = editable.eContainingFeature().getFeatureID();
            switch (featureID) {
                case 8: 
                case 9: 
                case 10: {
                    Display.getCurrent().timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            TestcaseDataValueEditor.this.viewer.setSelection((ISelection)new StructuredSelection(next.getData()), true);
                            TestcaseDataValueEditor.this.editItem(next);
                        }
                    });
                    break;
                }
                case 11: 
                case 12: {
                    this.viewer.expandToLevel(next.getData(), 1);
                    this.nextToEdit(null, next, backwards);
                    break;
                }
                default: {
                    SavvytestSettings.INSTANCE.getLogger().log("Unknown feature detected during editing. Feature: " + editable.eContainingFeature() + " Data: " + editable, LogLevel.WARNING, (Object)this);
                }
            }
        }
    }

    protected void editItem(final TreeItem treeItem) {
        final Object object = treeItem.getData();
        final IUpdateableItemText updateableItemText = (IUpdateableItemText)this.adapterFactory.adapt(object, IUpdateableItemText.class);
        if (updateableItemText != null) {
            final EObject obj = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
            java.lang.String string = updateableItemText.getUpdateableText(object);
            if (string == null) {
                return;
            }
            if (this.checkEditing != null && !this.checkEditing.checkEditing(treeItem)) {
                return;
            }
            this.horizontalAlignment = 16384;
            this.minimumWidth = Math.max(50, treeItem.getBounds().width);
            this.tree.showItem(treeItem);
            final Text text = new Text((Composite)this.tree, 2048);
            text.setFont(this.tree.getFont());
            text.setForeground(this.tree.getForeground());
            text.setBackground(this.tree.getBackground());
            this.setEditor((Control)text, treeItem);
            text.setFocus();
            text.setText(string);
            text.setSelection(0, string.length());
            text.addKeyListener((KeyListener)new CutCopyPasteKeyListener(){

                public void paste() {
                    text.paste();
                }

                public void cut() {
                    text.cut();
                }

                public void copy() {
                    text.copy();
                }
            });
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    TestcaseDataValueEditor.this.updateObject(updateableItemText, object, text.getText());
                    TestcaseDataValueEditor.this.setEditor(null);
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if ((event.character == '\r' || event.character == '\n') && TestcaseDataValueEditor.this.isValid(obj, text.getText())) {
                        TestcaseDataValueEditor.this.updateObject(updateableItemText, object, text.getText());
                        TestcaseDataValueEditor.this.setEditor(null);
                        text.dispose();
                        TestcaseDataValueEditor.this.nextToEdit(treeItem, treeItem.getParentItem(), false);
                    }
                }
            });
            text.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16 || e.detail == 8) {
                        TreeItem item = TestcaseDataValueEditor.this.getItem();
                        if (item != null && TestcaseDataValueEditor.this.isValid(obj, text.getText())) {
                            if (e.detail == 16) {
                                TestcaseDataValueEditor.this.nextToEdit(item, item.getParentItem(), false);
                            } else {
                                TestcaseDataValueEditor.this.nextToEdit(item, item.getParentItem(), true);
                            }
                        }
                    } else if (e.detail == 2) {
                        TestcaseDataValueEditor.this.setEditor(null);
                        text.dispose();
                        e.doit = false;
                    }
                }
            });
        }
    }

    private boolean isValid(Object object, java.lang.String text) {
        java.lang.String formattedText = this.formatText(text);
        if (formattedText == null || formattedText.isEmpty()) {
            return true;
        }
        if (TestcaseDataValueEditor.isStringLengthTooLong(object, formattedText)) {
            return false;
        }
        if (object instanceof Number) {
            try {
                new BigDecimal(text);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private void updateObject(IUpdateableItemText item, Object object, java.lang.String text) {
        java.lang.String formattedText = this.formatText(text);
        if (item.getUpdateableText(object).equals(formattedText)) {
            return;
        }
        if (formattedText == null || formattedText.length() == 0) {
            item.setText(object, null);
        } else if (!formattedText.equals(((ITableLabelProvider)this.viewer.getLabelProvider()).getColumnText(object, this.getColumn()))) {
            item.setText(object, formattedText);
        }
    }

    private java.lang.String formatText(java.lang.String text) {
        java.lang.String retString = UtilityFunctions.rightTrim((java.lang.String)text);
        if (retString.length() == 0 && text.length() > 0) {
            retString = " ";
        }
        return retString;
    }

    public ICheckEditing getCheckEditing() {
        return this.checkEditing;
    }

    public void setCheckEditing(ICheckEditing checkEditing) {
        this.checkEditing = checkEditing;
    }

    public static interface ICheckEditing {
        public boolean checkEditing(TreeItem var1);
    }
}

