/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.handlers;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseUtil;
import com.savvytest.eclipse.editor.testscenario.gui.SavvytestTestscenarioEditor;
import com.savvytest.eclipse.editor.testscenario.gui.TestcaseDialog;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioEditorPlugin;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveTestcaseHandler
extends AbstractHandler {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testscenario.handlers.RemoveTestcaseHandler.";

    private static String getClassString(String key, Object ... substitutes) {
        String translation = TestscenarioEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Map assignationSuppliesMap;
        Map assignationMap;
        SavvytestTestscenarioEditor editor = (SavvytestTestscenarioEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        EditingDomain editingDomain = editor.getEditingDomain();
        IStructuredSelection currentSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Testcase testcase = (Testcase)currentSelection.getFirstElement();
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        try {
            assignationMap = TestcaseUtil.getAssignationMap((Testcase)testcase);
            assignationSuppliesMap = TestcaseUtil.getAssignationSuppliesMap((Testcase)testcase);
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            MessageDialog.openError((Shell)shell, (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)RemoveTestcaseHandler.getClassString("error.assignationVisitor", e.getLocalizedMessage()));
            return null;
        }
        if (!TestcaseDialog.removeTestcaseDialog(shell, testcase.getName(), assignationSuppliesMap)) {
            return null;
        }
        if (!editor.checkEditing()) {
            return null;
        }
        CompoundCommand cc = new CompoundCommand();
        cc.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)testcase));
        for (Data data : assignationMap.keySet()) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)data, (Object)DataPackage.eINSTANCE.getData_AssignationVolatileData(), null));
        }
        for (Data data : assignationSuppliesMap.keySet()) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)data, (Object)DataPackage.eINSTANCE.getData_AssignationVolatileData(), null));
        }
        editingDomain.getCommandStack().execute(cc.unwrap());
        return null;
    }
}

