/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testscenario.gui.provider;

import com.savvytest.eclipse.common.util.ToolTipHandler;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.editor.testscenario.gui.TestscenarioEditorPlugin;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class TestcaseToolTipHandler
extends ToolTipHandler {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testscenario.gui.provider.TestcaseToolTipHandler.";
    private ILabelProvider labelProvider;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = TestscenarioEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public TestcaseToolTipHandler(Shell parent) {
        super(parent);
    }

    public String getHoverText(Object object, int column) {
        String hoverText = null;
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
        if (unwrapped instanceof Data) {
            Data data = (Data)unwrapped;
            Atomic atomic = data instanceof Atomic ? (Atomic)data : null;
            switch (column) {
                case 0: {
                    String id = data.calculateId();
                    hoverText = MessageFormat.format(TestcaseToolTipHandler.getClassString("id", new Object[0]), id);
                    break;
                }
                case 1: {
                    if (atomic == null) break;
                    String liType = PropertiesUtils.getStringProperty((Properties)atomic.getBaseType().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.LI_TYPE);
                    if (liType != null) {
                        liType = MessageFormat.format(TestcaseToolTipHandler.getClassString("listructure", new Object[0]), liType);
                    }
                    String maxLength = null;
                    BigInteger length = atomic.getBaseType().getLength();
                    BigDecimal scale = PropertiesUtils.getNumberProperty((Properties)atomic.getBaseType().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.SCALE);
                    if (length != null) {
                        if (scale != null) {
                            int scaleDigits = scale.toPlainString().length();
                            BigDecimal value = new BigDecimal(length.intValue() - scale.intValue());
                            value = value.scaleByPowerOfTen(scaleDigits);
                            value = value.add(scale);
                            value = value.scaleByPowerOfTen(-scaleDigits);
                            maxLength = MessageFormat.format(TestcaseToolTipHandler.getClassString("length", new Object[0]), value);
                        } else {
                            maxLength = MessageFormat.format(TestcaseToolTipHandler.getClassString("length", new Object[0]), length);
                        }
                    }
                    if (liType != null && maxLength != null) {
                        hoverText = String.valueOf(liType) + '\n' + maxLength;
                        break;
                    }
                    if (liType != null) {
                        hoverText = liType;
                        break;
                    }
                    if (maxLength == null) break;
                    hoverText = maxLength;
                    break;
                }
                case 2: {
                    Data assignation = data.getAssignationVolatileData();
                    if (assignation == null) break;
                    String assignationID = assignation.calculateId();
                    hoverText = MessageFormat.format(TestcaseToolTipHandler.getClassString("tooltipid", new Object[0]), assignationID);
                }
            }
        }
        return hoverText;
    }

    public Image getHoverImage(Object object, int column) {
        if (column < 0 || column > 2) {
            return null;
        }
        Image hoverImage = null;
        if (AdapterFactoryEditingDomain.unwrap((Object)object) instanceof Atomic) {
            Object imageObject = object;
            if (column == 2) {
                imageObject = ((Atomic)AdapterFactoryEditingDomain.unwrap((Object)object)).getAssignationVolatileData();
            }
            if (imageObject != null) {
                hoverImage = this.getLabelProvider().getImage(imageObject);
            }
        }
        return hoverImage;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

