/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.testsuite.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.MissingResourceUtil;
import com.savvytest.eclipse.common.util.SimpleXPathEvaluator;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.util.editing.duallistselector.DualListListener;
import com.savvytest.eclipse.common.util.editing.duallistselector.ElementInformation;
import com.savvytest.eclipse.common.util.editing.duallistselector.TreeFileSelector;
import com.savvytest.eclipse.core.model.xml.testscenario.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.core.model.xml.testsuite.TestsuitePackage;
import com.savvytest.eclipse.editor.testsuite.gui.AdditionalTestsuiteInformation;
import com.savvytest.eclipse.editor.testsuite.gui.TestsuiteEditor;
import com.savvytest.eclipse.editor.testsuite.gui.TestsuiteEditorPlugin;
import com.savvytest.eclipse.runner.RunTestsuiteAction;
import com.savvytest.eclipse.runner.RunTestsuiteJob;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SavvytestTestsuiteEditor
extends TestsuiteEditor {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.testsuite.gui.SavvytestTestsuiteEditor.";
    private ScrolledComposite testsuiteScrollComp;
    private Composite testsuiteComp;
    private ViewForm headerForm;
    private TreeFileSelector tfs;
    private com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot doc;
    private boolean recursionPreventer = false;
    private final Color colorForeground;
    private final Font fontForeground;
    private boolean readOnly;
    private int testsuitePageIndex = -1;
    private int infoPageIndex = -1;
    private final Adapter modelChangeAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (SavvytestTestsuiteEditor.this.recursionPreventer) {
                return;
            }
            try {
                SavvytestTestsuiteEditor.this.recursionPreventer = true;
                switch (msg.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        SavvytestTestsuiteEditor.this.setToDLS((List)SavvytestTestsuiteEditor.this.doc.getTestsuite().getTestscenarios());
                        break;
                    }
                    case 1: {
                        Object feature = msg.getFeature();
                        if (feature != TestsuitePackage.Literals.TESTSUITE__TESTSCENARIOS) break;
                        SavvytestTestsuiteEditor.this.setToDLS((List)SavvytestTestsuiteEditor.this.doc.getTestsuite().getTestscenarios());
                    }
                    default: {
                        break;
                    }
                }
            }
            finally {
                SavvytestTestsuiteEditor.this.recursionPreventer = false;
            }
        }
    };

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = TestsuiteEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestTestsuiteEditor() {
        this.colorForeground = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.fontForeground = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
    }

    @Override
    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        this.readOnly = file != null && file.isReadOnly();
        IStatus licenseErrorMessage = License.getInstance().getLicenseStatus();
        if (!licenseErrorMessage.isOK()) {
            this.getActionBarContributor().getActionBars().getStatusLineManager().setErrorMessage(licenseErrorMessage.getMessage());
        }
    }

    @Override
    public void createModel() {
        if (this.doc != null) {
            this.doc.getTestsuite().eAdapters().remove((Object)this.modelChangeAdapter);
        }
        super.createModel();
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.doc = (com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot)resource.getContents().get(0);
        this.updateManager(resource);
        this.checkMissingResources(this.doc.getTestsuite());
        this.doc.getTestsuite().eAdapters().add((Object)this.modelChangeAdapter);
    }

    @Override
    protected void handleActivate() {
        boolean oldReadOnly = this.readOnly;
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        boolean bl = this.readOnly = file != null && file.isReadOnly();
        if (oldReadOnly != this.readOnly) {
            SavvytestSettings.INSTANCE.getLogger().log("Read only status changed to: " + this.readOnly, LogLevel.DEBUG, (Object)this);
        }
        super.handleActivate();
    }

    @Override
    protected void handleChangedResources() {
        super.handleChangedResources();
        if (!this.changedResources.isEmpty()) {
            this.createModel();
            try {
                this.recursionPreventer = true;
                this.setToDLS((List<Testscenario>)this.doc.getTestsuite().getTestscenarios());
            }
            finally {
                this.recursionPreventer = false;
            }
            if (this.infoPageIndex != -1) {
                ((AdditionalTestsuiteInformation)this.getControl(this.infoPageIndex)).refresh();
            }
        }
    }

    protected boolean checkEditing() {
        IFile file;
        IStatus status;
        if (this.isReadOnly() && (status = EditingUtility.checkEditing((IFile)(file = (IFile)this.getEditorInput().getAdapter(IFile.class)), (Shell)this.getSite().getShell())) != null) {
            if (status.getSeverity() != 8 && status.getSeverity() != 4) {
                this.handleActivate();
            }
            return false;
        }
        return true;
    }

    @Override
    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.createPageTestsuite();
            this.createPageInformation();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SavvytestTestsuiteEditor.this.setActivePage(0);
                    if (SavvytestTestsuiteEditor.this.testsuiteComp != null && SavvytestTestsuiteEditor.this.testsuiteScrollComp != null) {
                        SavvytestTestsuiteEditor.this.testsuiteScrollComp.setMinSize(SavvytestTestsuiteEditor.this.testsuiteComp.computeSize(-1, -1));
                    }
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    SavvytestTestsuiteEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SavvytestTestsuiteEditor.this.updateProblemIndication();
            }
        });
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getContainer()});
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkMissingResources(Testsuite testsuite) {
        SavvytestSettings.INSTANCE.getLogger().log("Checking for missing resources in testsuite: " + testsuite.getName(), LogLevel.DEBUG, SavvytestTestsuiteEditor.class);
        Map missingResources = MissingResourceUtil.checkMissingResourcesForTestsuite((Testsuite)testsuite);
        if (missingResources.isEmpty()) {
            SavvytestSettings.INSTANCE.getLogger().log("All resources are present.", LogLevel.DEBUG, SavvytestTestsuiteEditor.class);
            return;
        }
        HashMap<EObject, SavvytestTypeEnum> missingNonScenarios = new HashMap<EObject, SavvytestTypeEnum>();
        HashMap<Object, SavvytestTypeEnum> missingScenarios = new HashMap<Object, SavvytestTypeEnum>();
        for (Map.Entry entry : missingResources.entrySet()) {
            if (entry.getValue() == SavvytestTypeEnum.TESTSCENARIO) {
                missingScenarios.put((EObject)entry.getKey(), (SavvytestTypeEnum)entry.getValue());
                continue;
            }
            missingNonScenarios.put((EObject)entry.getKey(), (SavvytestTypeEnum)entry.getValue());
        }
        if (!missingNonScenarios.isEmpty()) {
            for (Testscenario testscenario : testsuite.getTestscenarios()) {
                if (missingScenarios.containsKey(testscenario) || MissingResourceUtil.checkMissingResourcesForTestscenario((Testscenario)testscenario).isEmpty()) continue;
                missingScenarios.put(testscenario, SavvytestTypeEnum.TESTSCENARIO);
            }
        }
        String missingResourcesString = MissingResourceUtil.buildMissingResourcesString(missingScenarios, (String)"\n");
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), SavvytestTestsuiteEditor.getClassString("missingresourcetitle", new Object[0]), null, SavvytestTestsuiteEditor.getClassString("missingresourcemessage", missingResourcesString), 1, new String[]{Savvytest.getGlobalString((String)"yes", (Object[])new Object[0]), Savvytest.getGlobalString((String)"no", (Object[])new Object[0])}, 0);
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            SavvytestSettings.INSTANCE.getLogger().log("User chose to not remove missing resources.", LogLevel.DEBUG, (Object)this);
            String msg = MessageFormat.format(SavvytestTestsuiteEditor.getClassString("error.missingresource", new Object[0]), missingResourcesString.toString());
            MissingResourceException e = new MissingResourceException(msg, null, null);
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            if (Savvytest.getEclipseVersion().getMajor() != 4) throw e;
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)msg);
            throw e;
        }
        if (this.isReadOnly()) {
            String msg = SavvytestTestsuiteEditor.getClassString("error.filewriteprotected", new Object[0]);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)msg);
            RuntimeException e = new RuntimeException(msg);
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            throw e;
        }
        SavvytestSettings.INSTANCE.getLogger().log("User chose to remove missing resources.", LogLevel.DEBUG, (Object)this);
        Iterator iter = this.resourceToDiagnosticMap.keySet().iterator();
        block2: while (iter.hasNext()) {
            URI uri = ((Resource)iter.next()).getURI();
            for (EObject impl : missingResources.keySet()) {
                URI compare = ((BasicEObjectImpl)impl).eProxyURI();
                if (!uri.devicePath().equalsIgnoreCase(compare.devicePath())) continue;
                iter.remove();
                continue block2;
            }
        }
        CompoundCommand cc = new CompoundCommand(){

            public boolean canUndo() {
                return false;
            }
        };
        RemoveCommand cmd = new RemoveCommand(this.getEditingDomain(), (EObject)testsuite, (EStructuralFeature)TestsuitePackage.Literals.TESTSUITE__TESTSCENARIOS, missingScenarios.keySet());
        cc.append((Command)cmd);
        if (cc.canExecute()) {
            this.editingDomain.getCommandStack().execute((Command)cc);
            this.updateProblemIndication();
            if (!this.resourceToDiagnosticMap.isEmpty()) return;
            if (this.getPageCount() <= this.infoPageIndex + 1) return;
            this.removePage(this.getPageCount() - 1);
            return;
        }
        String msg = MessageFormat.format(SavvytestTestsuiteEditor.getClassString("error.commandmissingresource", new Object[0]), missingResourcesString);
        RuntimeException e = new RuntimeException(msg);
        SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
        throw e;
    }

    private void createPageTestsuite() {
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        this.headerForm = new ViewForm(this.getContainer(), 0x800000);
        try {
            if (RunTestsuiteJob.class == RunTestsuiteJob.class) {
                ToolBarManager manager = new ToolBarManager(131072);
                ContributionItem item = new ContributionItem(){
                    private ImageDescriptor descriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(TestsuiteEditorPlugin.INSTANCE.getImage("full/obj16/TestsuiteLaunchConfiguration"));
                    private Image image;

                    public void fill(ToolBar parent, int index) {
                        ToolItem toolItem = new ToolItem(parent, 8, index);
                        if (this.image == null && this.descriptor != null) {
                            this.image = (Image)this.descriptor.createResource((Device)SavvytestTestsuiteEditor.this.getSite().getShell().getDisplay());
                            toolItem.setImage(this.image);
                        } else {
                            toolItem.setText(SavvytestTestsuiteEditor.getClassString("runbutton.label", new Object[0]));
                        }
                        toolItem.setToolTipText(SavvytestTestsuiteEditor.getClassString("runbutton.tooltip", new Object[0]));
                        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RunTestsuiteAction action = new RunTestsuiteAction();
                                action.setFiles(new IFile[]{((IFileEditorInput)SavvytestTestsuiteEditor.this.getEditorInput()).getFile()});
                                action.setPart((IWorkbenchPart)SavvytestTestsuiteEditor.this);
                                action.run(null);
                            }
                        });
                    }

                    public void dispose() {
                        if (this.image != null && this.descriptor != null) {
                            this.descriptor.destroyResource((Object)this.image);
                        }
                    }
                };
                manager.add((IContributionItem)item);
                this.headerForm.setTopRight((Control)manager.createControl((Composite)this.headerForm));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            SavvytestSettings.INSTANCE.getLogger().log("Runner plugin not found. Testsuite can't be run directly.", LogLevel.WARNING, (Object)this);
        }
        String projectname = URI.decode((String)resource.getURI().segments()[1]);
        IProject containingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectname);
        this.testsuiteScrollComp = new ScrolledComposite((Composite)this.headerForm, 2816);
        this.testsuiteScrollComp.setExpandHorizontal(true);
        this.testsuiteScrollComp.setExpandVertical(true);
        this.testsuiteComp = new Composite((Composite)this.testsuiteScrollComp, 0);
        this.testsuiteComp.setLayout((Layout)new GridLayout(1, false));
        this.testsuiteScrollComp.setContent((Control)this.testsuiteComp);
        Group groupSuites = new Group(this.testsuiteComp, 16);
        Group groupInformation = new Group(this.testsuiteComp, 16);
        Label labelName = new Label((Composite)groupInformation, 0);
        final Hyperlink hyperlinkName = new Hyperlink((Composite)groupInformation, 0);
        Label labelAlias = new Label((Composite)groupInformation, 0);
        final Text textAlias = new Text((Composite)groupInformation, 2060);
        Label labelFolder = new Label((Composite)groupInformation, 0);
        final Text textFolder = new Text((Composite)groupInformation, 2060);
        Label labelProject = new Label((Composite)groupInformation, 0);
        final Text textProject = new Text((Composite)groupInformation, 2060);
        groupSuites.setText(SavvytestTestsuiteEditor.getClassString("grouptestscenarios", new Object[0]));
        groupSuites.setLayoutData((Object)GridDataCreator.fill());
        groupSuites.setLayout((Layout)new GridLayout(2, false));
        groupSuites.setForeground(this.colorForeground);
        groupSuites.setFont(this.fontForeground);
        this.tfs = new TreeFileSelector((Composite)groupSuites, 0);
        this.tfs.getControl().setLayoutData((Object)GridDataCreator.fill());
        this.tfs.setMultiple(false);
        this.tfs.setProjectRestriction(containingProject);
        this.tfs.setFileTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.TESTSCENARIO});
        this.tfs.setColor(this.colorForeground);
        this.tfs.setFont(this.fontForeground);
        this.tfs.addDualListListener((DualListListener)new DualListListener<IFile>(){

            public void selectionEvent(int side, List<ElementInformation<IFile>> elements) {
                if (elements != null && elements.size() == 1 && ((IFile)elements.get((int)0).element).exists()) {
                    IFile file = (IFile)elements.get((int)0).element;
                    SimpleXPathEvaluator parser = new SimpleXPathEvaluator();
                    parser.setDocumentSecure(file);
                    parser.setXPath(SimpleXPathEvaluator.XPATH_NAME);
                    String name = parser.evaluateXPathForStringSecure();
                    parser.setXPath(SimpleXPathEvaluator.XPATH_ALIAS);
                    String alias = parser.evaluateXPathForStringSecure();
                    hyperlinkName.setHref((Object)file);
                    hyperlinkName.setText(name == null ? "" : name);
                    textAlias.setText(alias == null ? "" : alias);
                    textFolder.setText(file.getProjectRelativePath().removeLastSegments(1).toString());
                    textProject.setText(file.getProject().getName());
                } else {
                    hyperlinkName.setHref(null);
                    hyperlinkName.setText("");
                    textAlias.setText("");
                    textFolder.setText("");
                    textProject.setText("");
                }
            }

            public void movementEvent(int side, List<ElementInformation<IFile>> elements) {
                if (SavvytestTestsuiteEditor.this.recursionPreventer) {
                    return;
                }
                try {
                    SavvytestTestsuiteEditor.this.recursionPreventer = true;
                    if (!SavvytestTestsuiteEditor.this.checkEditing()) {
                        SavvytestTestsuiteEditor.this.tfs.undoMovement(side, elements);
                        return;
                    }
                    SavvytestTestsuiteEditor.this.setToModel(SavvytestTestsuiteEditor.this.tfs.getSelected());
                }
                finally {
                    SavvytestTestsuiteEditor.this.recursionPreventer = false;
                }
            }

            public void positionEvent(int side, List<ElementInformation<IFile>> elements) {
                if (SavvytestTestsuiteEditor.this.recursionPreventer) {
                    return;
                }
                try {
                    SavvytestTestsuiteEditor.this.recursionPreventer = true;
                    if (!SavvytestTestsuiteEditor.this.checkEditing()) {
                        SavvytestTestsuiteEditor.this.tfs.undoPosition(side, elements);
                        return;
                    }
                    SavvytestTestsuiteEditor.this.setToModel(SavvytestTestsuiteEditor.this.tfs.getSelected());
                }
                finally {
                    SavvytestTestsuiteEditor.this.recursionPreventer = false;
                }
            }
        });
        try {
            this.recursionPreventer = true;
            this.setToDLS((List<Testscenario>)this.doc.getTestsuite().getTestscenarios());
        }
        finally {
            this.recursionPreventer = false;
        }
        groupInformation.setText(SavvytestTestsuiteEditor.getClassString("groupinfo", new Object[0]));
        groupInformation.setLayoutData((Object)GridDataCreator.horizontalFill());
        groupInformation.setLayout((Layout)new GridLayout(2, false));
        groupInformation.setForeground(this.colorForeground);
        groupInformation.setFont(this.fontForeground);
        labelName.setText(SavvytestTestsuiteEditor.getClassString("infoname", new Object[0]));
        labelName.setLayoutData((Object)GridDataCreator.normal());
        labelName.setForeground(this.colorForeground);
        labelName.setFont(this.fontForeground);
        hyperlinkName.setLayoutData((Object)GridDataCreator.horizontalFill());
        hyperlinkName.setText("");
        hyperlinkName.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                IFile file = (IFile)hyperlinkName.getHref();
                if (file == null) {
                    return;
                }
                try {
                    IDE.openEditor((IWorkbenchPage)SavvytestTestsuiteEditor.this.getSite().getPage(), (IFile)file);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)SavvytestTestsuiteEditor.this.getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)SavvytestTestsuiteEditor.getClassString("openeditorfailed", file.getFullPath(), e.getLocalizedMessage()));
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                }
            }
        });
        HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(this.headerForm.getDisplay());
        hyperlinkGroup.add(hyperlinkName);
        labelAlias.setText(SavvytestTestsuiteEditor.getClassString("infoalias", new Object[0]));
        labelAlias.setLayoutData((Object)GridDataCreator.normal());
        labelAlias.setForeground(this.colorForeground);
        labelAlias.setFont(this.fontForeground);
        textAlias.setLayoutData((Object)GridDataCreator.horizontalFill());
        textAlias.setForeground(this.colorForeground);
        textAlias.setFont(this.fontForeground);
        labelFolder.setText(SavvytestTestsuiteEditor.getClassString("infofolder", new Object[0]));
        labelFolder.setLayoutData((Object)GridDataCreator.normal());
        labelFolder.setForeground(this.colorForeground);
        labelFolder.setFont(this.fontForeground);
        textFolder.setLayoutData((Object)GridDataCreator.horizontalFill());
        textFolder.setForeground(this.colorForeground);
        textFolder.setFont(this.fontForeground);
        labelProject.setText(SavvytestTestsuiteEditor.getClassString("infoproject", new Object[0]));
        labelProject.setLayoutData((Object)GridDataCreator.normal());
        labelProject.setForeground(this.colorForeground);
        labelProject.setFont(this.fontForeground);
        textProject.setLayoutData((Object)GridDataCreator.horizontalFill());
        textProject.setForeground(this.colorForeground);
        textProject.setFont(this.fontForeground);
        this.headerForm.setContent((Control)this.testsuiteScrollComp);
        this.testsuitePageIndex = this.addPage((Control)this.headerForm);
        this.setPageText(this.testsuitePageIndex, SavvytestTestsuiteEditor.getClassString("pagetitle", new Object[0]));
    }

    private void createPageInformation() {
        AdditionalTestsuiteInformation info = new AdditionalTestsuiteInformation(this, this.getContainer(), 0);
        info.init();
        this.infoPageIndex = this.addPage((Control)info);
        this.setPageText(this.infoPageIndex, SavvytestTestsuiteEditor.getClassString("infopagetitle", new Object[0]));
    }

    private void setToModel(List<IFile> files) {
        SetCommand command;
        ArrayList<Testscenario> scenarios = new ArrayList<Testscenario>(files.size());
        for (IFile file : files) {
            Resource res = this.editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
            DocumentRoot testscenarioDoc = (DocumentRoot)res.getContents().get(0);
            scenarios.add(testscenarioDoc.getTestscenario());
        }
        if (!scenarios.equals(this.doc.getTestsuite().getTestscenarios()) && (command = new SetCommand((EditingDomain)this.editingDomain, (EObject)this.doc.getTestsuite(), (EStructuralFeature)TestsuitePackage.Literals.TESTSUITE__TESTSCENARIOS, scenarios)).canExecute()) {
            this.editingDomain.getCommandStack().execute((Command)command);
        }
    }

    private void setToDLS(List<Testscenario> scenarios) {
        ArrayList<IFile> selectedFiles = new ArrayList<IFile>(scenarios.size());
        for (Testscenario scenario : scenarios) {
            String filename = scenario.eResource().getURI().toPlatformString(true);
            IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(filename);
            selectedFiles.add(file);
        }
        this.tfs.setSelected(selectedFiles);
    }

    @Override
    public void dispose() {
        Label label;
        if (this.doc != null) {
            this.doc.getTestsuite().eAdapters().remove((Object)this.modelChangeAdapter);
        }
        if (this.headerForm != null && (label = (Label)this.headerForm.getTopLeft()) != null) {
            label.getFont().dispose();
        }
        super.dispose();
    }

    public void refresh() {
        if (this.tfs != null) {
            this.tfs.refresh();
            try {
                this.recursionPreventer = true;
                this.setToDLS((List<Testscenario>)this.doc.getTestsuite().getTestscenarios());
            }
            finally {
                this.recursionPreventer = false;
            }
        }
        if (this.infoPageIndex != -1) {
            ((AdditionalTestsuiteInformation)this.getControl(this.infoPageIndex)).refresh();
        }
    }

    @Override
    public IContentOutlinePage getContentOutlinePage() {
        return null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void updateManager(Resource resource) {
        if (this.isReadOnly()) {
            SavvytestSettings.INSTANCE.getLogger().log("Editor read only. No update.", LogLevel.DEBUG, (Object)this);
            return;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Checking for updates.", LogLevel.DEBUG, (Object)this);
        CompoundCommand cc = new CompoundCommand();
        cc.appendIfCanExecute(this.checkId(resource));
        if (cc.canExecute()) {
            SavvytestSettings.INSTANCE.getLogger().log("Executing updates.", LogLevel.INFO, (Object)this);
            this.getEditingDomain().getCommandStack().execute((Command)cc);
            SavvytestSettings.INSTANCE.getLogger().log("Updates successfully finished.", LogLevel.INFO, (Object)this);
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("No updates found.", LogLevel.DEBUG, (Object)this);
        }
    }

    private Command checkId(Resource resource) {
        SavvytestSettings.INSTANCE.getLogger().log("Checking for update of testsuite ID.", LogLevel.DEBUG, (Object)this);
        com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot root = (com.savvytest.eclipse.core.model.xml.testsuite.DocumentRoot)resource.getContents().get(0);
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            String currentId;
            String filepath = URI.encodeOpaquePart((String)file.getProjectRelativePath().toString(), (boolean)true);
            if (!filepath.equals(currentId = root.getTestsuite().getId())) {
                SavvytestSettings.INSTANCE.getLogger().log("Filename: " + filepath + ". Testsuite ID: " + currentId + ". Need to update.", LogLevel.DEBUG, (Object)this);
                return new SetCommand(this.getEditingDomain(), (EObject)root.getTestsuite(), (EStructuralFeature)TestsuitePackage.Literals.TESTSUITE__ID, (Object)filepath);
            }
            SavvytestSettings.INSTANCE.getLogger().log("No update needed.", LogLevel.DEBUG, (Object)this);
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("Editor input is not a file, can't check for change.", LogLevel.DEBUG, (Object)this);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

