/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.excel.Activator;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExcelSheetSelectionPage
extends WizardPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.excel.importexport.ExcelSheetSelectionPage.";
    private String excelFilename;
    private String proposedFilename;
    private boolean openAfterSave;
    private final int dialogStyle;

    private static String getClassString(String key) {
        return Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public ExcelSheetSelectionPage(String pageName, int dialogStyle) {
        super(pageName);
        this.dialogStyle = dialogStyle;
        if (dialogStyle != 8192 && dialogStyle != 4096) {
            throw new IllegalArgumentException("DialogStyle only supports one of SWT.OPEN or SWT.SAVE.");
        }
    }

    public void createControl(Composite parent) {
        WizardPageValidator validator = new WizardPageValidator(this){

            protected String internalValidate() {
                if (ExcelSheetSelectionPage.this.dialogStyle == 8192) {
                    if (ExcelSheetSelectionPage.this.getExcelFilename() == null) {
                        return ExcelSheetSelectionPage.getClassString("error.excel.export");
                    }
                    File file = new File(ExcelSheetSelectionPage.this.getExcelFilename());
                    if (file.isDirectory()) {
                        return ExcelSheetSelectionPage.getClassString("error.excel.export");
                    }
                    File parentDirectory = file.getParentFile();
                    if (parentDirectory == null || !parentDirectory.isDirectory()) {
                        return ExcelSheetSelectionPage.getClassString("error.excel.export");
                    }
                } else if (!(ExcelSheetSelectionPage.this.dialogStyle != 4096 || ExcelSheetSelectionPage.this.getExcelFilename() != null && new File(ExcelSheetSelectionPage.this.getExcelFilename()).isFile())) {
                    return ExcelSheetSelectionPage.getClassString("error.excel.import");
                }
                return null;
            }
        };
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group excelGroup = new Group(container, 16);
        excelGroup.setText(ExcelSheetSelectionPage.getClassString("excelgroup"));
        excelGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        excelGroup.setLayout((Layout)new GridLayout(2, false));
        excelGroup.setFont(font);
        final Text excelText = new Text((Composite)excelGroup, 2048);
        excelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        excelText.setFont(font);
        excelText.setForeground(color);
        excelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExcelSheetSelectionPage.this.excelFilename = excelText.getText();
            }
        });
        excelText.addListener(24, (Listener)validator);
        Button button = new Button((Composite)excelGroup, 8);
        button.setFont(font);
        button.setForeground(color);
        button.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        button.setText(ExcelSheetSelectionPage.getClassString("select"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExcelSheetSelectionPage.this.getShell(), ExcelSheetSelectionPage.this.dialogStyle);
                dialog.setFilterExtensions(new String[]{"*.xlsx"});
                dialog.setFilterNames(new String[]{"Excel (*.xlsx)"});
                dialog.setFileName(ExcelSheetSelectionPage.this.getProposedFilename());
                dialog.setOverwrite(ExcelSheetSelectionPage.this.dialogStyle == 8192);
                String newFilename = dialog.open();
                if (newFilename != null) {
                    excelText.setText(newFilename);
                }
            }
        });
        if (this.dialogStyle == 8192) {
            final Button openAfterSave = new Button((Composite)excelGroup, 32);
            openAfterSave.setLayoutData((Object)GridDataCreator.normal());
            openAfterSave.setFont(font);
            openAfterSave.setForeground(color);
            openAfterSave.setText(ExcelSheetSelectionPage.getClassString("openAfterSave"));
            openAfterSave.setSelection(this.isOpenAfterSave());
            openAfterSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExcelSheetSelectionPage.this.setOpenAfterSave(openAfterSave.getSelection());
                }
            });
        }
        container.pack();
        this.setControl((Control)container);
        validator.validate();
        validator.setDisplayError(true);
    }

    public String getExcelFilename() {
        return this.excelFilename;
    }

    public void setOpenAfterSave(boolean openAfterSave) {
        this.openAfterSave = openAfterSave;
    }

    public boolean isOpenAfterSave() {
        return this.openAfterSave;
    }

    public void setProposedFilename(String proposedFilename) {
        this.proposedFilename = proposedFilename;
    }

    public String getProposedFilename() {
        return this.proposedFilename;
    }
}

