/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.license.NotLicensedPage;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.excel.Activator;
import com.savvytest.eclipse.excel.importexport.ExcelImportExportException;
import com.savvytest.eclipse.excel.importexport.ExcelSheetSelectionPage;
import com.savvytest.eclipse.excel.importexport.visitors.ImportCheckconditionsVisitor;
import com.savvytest.eclipse.excel.importexport.visitors.ImportVisitor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ExcelImportWizard
extends Wizard
implements IImportWizard {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.excel.importexport.ExcelImportWizard.";
    private ExcelSheetSelectionPage excelPage;
    private SavvytestFileSelectionPage testscenarioPage;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(Activator.INSTANCE.getImage("ExcelImportWiz")));
        if (License.getInstance().isOptionExcelIoLicensed()) {
            this.createPages();
            this.applySelection(selection);
        }
    }

    private void createPages() {
        this.excelPage = new ExcelSheetSelectionPage("ExcelPage", 4096);
        this.excelPage.setTitle(ExcelImportWizard.getClassString("excelPage.title", new Object[0]));
        this.excelPage.setDescription(ExcelImportWizard.getClassString("excelPage.description", new Object[0]));
        this.testscenarioPage = new SavvytestFileSelectionPage("TestscenarioPage", 4096);
        this.testscenarioPage.setTitle(ExcelImportWizard.getClassString("testscenarioPage.title", new Object[0]));
        this.testscenarioPage.setDescription(ExcelImportWizard.getClassString("testscenarioPage.description", new Object[0]));
        final SavvytestFileSelection fileSelectionComponent = this.testscenarioPage.getFileSelectionComponent();
        fileSelectionComponent.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.TESTSCENARIO});
        fileSelectionComponent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IFile file = fileSelectionComponent.getSelectedFile();
                if (file == null || !file.exists()) {
                    ExcelImportWizard.this.testscenarioPage.setMessage(ExcelImportWizard.getClassString("testscenarioPage.error.chooseFile", new Object[0]), 3);
                } else {
                    ExcelImportWizard.this.testscenarioPage.setMessage(null);
                }
                ExcelImportWizard.this.testscenarioPage.setPageComplete(ExcelImportWizard.this.testscenarioPage.getMessage() == null);
            }
        });
        this.testscenarioPage.setPageComplete(false);
    }

    private void applySelection(IStructuredSelection selection) {
        Object selectedElement;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IResource) {
            IResource resource = (IResource)selectedElement;
            this.testscenarioPage.getFileSelectionComponent().setInitialSelection(resource);
        }
    }

    public boolean performFinish() {
        Testscenario testscenario;
        AdapterFactoryEditingDomain editingDomain;
        XSSFWorkbook wb;
        if (!License.getInstance().isOptionExcelIoLicensed()) {
            return true;
        }
        IFile testscenarioFile = this.testscenarioPage.getFileSelectionComponent().getSelectedFile();
        String excelFile = this.excelPage.getExcelFilename();
        try {
            wb = new XSSFWorkbook((InputStream)new FileInputStream(excelFile));
        }
        catch (IOException e) {
            this.handleException(ExcelImportWizard.getClassString("error.excelfile", e.getLocalizedMessage(), excelFile), e);
            return false;
        }
        try {
            editingDomain = EditingUtility.createDefaultEditingDomain();
            testscenario = EditingUtility.loadTestscenario((IFile)testscenarioFile, (EditingDomain)editingDomain);
        }
        catch (Exception e) {
            this.handleException(ExcelImportWizard.getClassString("error.loadTestscenario", e.getLocalizedMessage(), testscenarioFile), e);
            return false;
        }
        if (testscenario.getTestcases().getTestcases().size() * 2 + 1 != wb.getNumberOfSheets()) {
            int testcaseNumber = testscenario.getTestcases().getTestcases().size();
            int worksheetNumber = wb.getNumberOfSheets();
            String testscenarioName = testscenario.getName();
            String technicalMessage = "The number of testcases (" + testcaseNumber + ") in the testscenario \"" + testscenarioName + "\" does not correspond to the number of sheets (" + worksheetNumber + ") in the workbook.";
            String userMessage = ExcelImportWizard.getClassString("error.sizeMismatchTestcasesSheets", testcaseNumber, worksheetNumber);
            SavvytestSettings.INSTANCE.getLogger().log(technicalMessage, LogLevel.ERROR, (Object)this);
            MessageBox box = new MessageBox(this.getShell(), 33);
            box.setMessage(userMessage);
            box.setText(Savvytest.getGlobalString((String)"error", (Object[])new Object[0]));
            box.open();
            return false;
        }
        wb.unLockStructure();
        int testcaseSize = testscenario.getTestcases().getTestcases().size();
        int i = testcaseSize - 1;
        while (i >= 0) {
            wb.setSheetOrder(wb.getSheetName(2 * i + 1), testcaseSize + i);
            --i;
        }
        try {
            ImportVisitor visitor = new ImportVisitor(testscenario, wb, 0);
            visitor.setEditingDomain((EditingDomain)editingDomain);
            visitor.visit();
            ImportCheckconditionsVisitor checkconditionVisitor = new ImportCheckconditionsVisitor(testscenario, wb, testcaseSize);
            checkconditionVisitor.setEditingDomain((EditingDomain)editingDomain);
            checkconditionVisitor.visit();
        }
        catch (ExcelImportExportException e) {
            this.handleException(e.getLocalizedMessage(), e);
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            this.handleException(ExcelImportWizard.getClassString("error.import", e.getLocalizedMessage()), e);
            return false;
        }
        try {
            EditingUtility.createTestscenario((IFile)testscenarioFile, (Testscenario)testscenario, (EditingDomain)editingDomain);
        }
        catch (Exception e) {
            this.handleException(ExcelImportWizard.getClassString("error.saveTestscenario", e.getLocalizedMessage(), testscenarioFile), e);
            return false;
        }
        return true;
    }

    private void handleException(String message, Exception e) {
        SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
        MessageDialog.openError((Shell)this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)message);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getShell()});
    }

    public void addPages() {
        if (!License.getInstance().isOptionExcelIoLicensed()) {
            this.addPage((IWizardPage)new NotLicensedPage("NotLicensedPage", 1));
            return;
        }
        this.addPage((IWizardPage)this.excelPage);
        this.addPage((IWizardPage)this.testscenarioPage);
    }
}

