/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport.visitors;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataFactory;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.provider.AddArrayCommand;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.excel.Activator;
import com.savvytest.eclipse.excel.importexport.ExcelImportExportException;
import com.savvytest.eclipse.excel.importexport.visitors.AbstractImportExportVisitor;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class ImportVisitor
extends AbstractImportExportVisitor {
    private static final java.lang.String TRANSLATION_PREFIX = "com.savvytest.eclipse.excel.importexport.visitors.ImportVisitor.";
    private final Testscenario testscenario;
    private final XSSFWorkbook workbook;
    private final int startingSheetIndex;
    private int readingRow;
    private int readingColumn;
    private int arrayLevel;
    private AbstractImportExportVisitor.ArrayInformation arrayInfo;
    private Map<java.lang.String, PersistentData> persistentDataMap;
    private List<PersistentData> persistentDataStorage;
    private boolean alreadyAskedForTestcase;

    private static java.lang.String getClassString(java.lang.String key, Object ... substitutes) {
        java.lang.String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public ImportVisitor(Testscenario testscenario, XSSFWorkbook workbook, int startingSheetIndex) {
        this.testscenario = testscenario;
        this.workbook = workbook;
        this.startingSheetIndex = startingSheetIndex;
        if (testscenario == null) {
            throw new IllegalArgumentException("Testscenario must not be null.");
        }
        if (workbook == null) {
            throw new IllegalArgumentException("Workbook must not be null.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object visit(Array array) throws Exception {
        oldWritingRow = this.readingRow;
        oldWritingColumn = this.readingColumn;
        info = new AbstractImportExportVisitor.ArrayInformation(array, this.readingColumn);
        if (this.arrayLevel == 0) {
            this.arrayInfo = info;
        } else {
            lastOfLevel = this.arrayInfo.getLastOfLevel(this.arrayLevel - 1);
            lastOfLevel.addInfo(info);
        }
        ++this.arrayLevel;
        elements = array.getElements();
        maxArraySize = ImportVisitor.getMaxArraySize(array);
        while (elements.size() < maxArraySize) {
            command = (AddArrayCommand)AddArrayCommand.createAddArrayCommand((EditingDomain)this.getEditingDomain(), (Array)array, (int)-1);
            command.setCreatePersistantData(false);
            command.execute();
        }
        iterator = elements.iterator();
        nextRow = oldWritingRow;
        afterArrayColumn = this.readingColumn + 1;
        firstUnusedArrayElementIndex = 0;
        while (iterator.hasNext()) {
            this.readingColumn = oldWritingColumn;
            indexValue = this.readStringValueOfCell(this.readingColumn, this.readingRow);
            if (indexValue == null || indexValue.isEmpty()) break;
            try {
                newIndex = Integer.parseInt(indexValue);
            }
            catch (NumberFormatException v0) {
                sheetName = this.getSheet().getSheetName();
                arrayName = array.getName();
                excelRow = this.readingRow + 1;
                technicalMessage = "The given index for the array '" + arrayName + "' in row " + excelRow + " in the excel-sheet '" + sheetName + "' is not a number: " + indexValue;
                userMessage = ImportVisitor.getClassString("error.indexNotANumber", new Object[]{indexValue, arrayName, excelRow, sheetName});
                throw new ExcelImportExportException(technicalMessage, userMessage);
            }
            if (newIndex <= 0 || newIndex > ImportVisitor.getMaxArraySize(array)) {
                sheetName = this.getSheet().getSheetName();
                arrayName = array.getName();
                excelRow = this.readingRow + 1;
                technicalMessage = "The given index for the array '" + arrayName + "' in row " + excelRow + " in the excel-sheet '" + sheetName + "' is out of bounds: " + newIndex;
                userMessage = ImportVisitor.getClassString("error.indexOutOfBounds", new Object[]{newIndex, ImportVisitor.getMaxArraySize(array), arrayName, excelRow, sheetName});
                throw new ExcelImportExportException(technicalMessage, userMessage);
            }
            if (!info.checkValidLevel(this.readingRow)) break;
            if (newIndex - 1 > info.getCurrentLevel()) ** GOTO lbl52
            sheetName = this.getSheet().getSheetName();
            arrayName = array.getName();
            excelRow = this.readingRow + 1;
            technicalMessage = "The given index for the array '" + arrayName + "' in row " + excelRow + " in the excel-sheet '" + sheetName + "' is not higher then the previous index.";
            userMessage = ImportVisitor.getClassString("error.indexMismatch", new Object[]{arrayName, excelRow, sheetName});
            throw new ExcelImportExportException(technicalMessage, userMessage);
lbl-1000:
            // 1 sources

            {
                info.createNewLevel();
                ++firstUnusedArrayElementIndex;
lbl52:
                // 2 sources

                ** while (info.getCurrentLevel() < newIndex - 1)
            }
lbl53:
            // 1 sources

            this.visit((FeatureMap.Entry)iterator.next());
            afterArrayColumn = ++this.readingColumn;
            this.readingRow = nextRow += info.getUsedSize(info.getCurrentLevel());
        }
        count = array.getElements().size();
        listIterator = array.getElements().listIterator(count);
        while (listIterator.hasPrevious() && count > firstUnusedArrayElementIndex) {
            entry = (FeatureMap.Entry)listIterator.previous();
            date = (Data)entry.getValue();
            id = "input." + date.calculateInputId();
            this.removePersistentDataElement(id);
            listIterator.remove();
            --count;
        }
        this.readingRow = oldWritingRow;
        this.readingColumn = afterArrayColumn;
        --this.arrayLevel;
        return null;
    }

    public Object visit(String string) throws Exception {
        this.ensureMatchName((Data)string, this.readingColumn);
        java.lang.String value = this.readStringValueOfCell(this.readingColumn, this.readingRow);
        string.setValue(value);
        java.lang.String calculateInputId = "input." + string.calculateInputId();
        this.storeValue(calculateInputId, value, string.getBaseType(), PropertiesUtils.PropertyEnum.VALUE_STRING);
        ++this.readingColumn;
        return null;
    }

    public Object visit(Number number) throws Exception {
        BigDecimal bigDecimal;
        java.lang.String value;
        block4: {
            this.ensureMatchName((Data)number, this.readingColumn);
            value = this.readStringValueOfCell(this.readingColumn, this.readingRow);
            bigDecimal = null;
            if (value != null) {
                try {
                    bigDecimal = new BigDecimal(value);
                }
                catch (NumberFormatException e) {
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                    if (this.alreadyAskedForTestcase) break block4;
                    MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 289);
                    box.setMessage(ImportVisitor.getClassString("error.numberNotANumber", value, number.getName(), this.readingRow, this.getTestcase().getName()));
                    box.setText(Savvytest.getGlobalString((java.lang.String)"error", (Object[])new Object[0]));
                    if (box.open() == 256) {
                        throw new OperationCanceledException();
                    }
                    this.alreadyAskedForTestcase = true;
                }
            }
        }
        number.setValue(bigDecimal);
        java.lang.String calculateInputId = "input." + number.calculateInputId();
        this.storeValue(calculateInputId, value, number.getBaseType(), PropertiesUtils.PropertyEnum.VALUE_NUMBER);
        ++this.readingColumn;
        return null;
    }

    public Object visit(Boolean number) throws Exception {
        this.ensureMatchName((Data)number, this.readingColumn);
        java.lang.String value = this.readStringValueOfCell(this.readingColumn, this.readingRow);
        number.setValue(java.lang.Boolean.valueOf(value));
        java.lang.String calculateInputId = "input." + number.calculateInputId();
        this.storeValue(calculateInputId, value, number.getBaseType(), PropertiesUtils.PropertyEnum.VALUE_NUMBER);
        ++this.readingColumn;
        return null;
    }

    public Object visit(FeatureMap.Entry entry) throws Exception {
        Data data = (Data)entry.getValue();
        UsageType usage = PropertiesUtils.getUsage((Properties)data.getBaseTypeExtension().getProperties());
        java.lang.Boolean filler = PropertiesUtils.getBooleanProperty((Properties)data.getBaseType().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER);
        if (!(usage != UsageType.IN && usage != UsageType.INOUT || filler != null && filler.booleanValue())) {
            return super.visit(entry);
        }
        return null;
    }

    public void visit() throws Exception {
        int index = this.startingSheetIndex;
        for (Testcase testcase : this.testscenario.getTestcases().getTestcases()) {
            this.setTestcase(testcase);
            this.setSheet(this.workbook.getSheetAt(index++));
            this.ensureMatchWorksheet(this.getSheet(), testcase);
            this.readingRow = 1;
            this.readingColumn = 0;
            this.alreadyAskedForTestcase = false;
            testcase.getCheckconditions().getSimpleCheckconditions().clear();
            EList persistentArguments = testcase.getInput();
            EList volatileArguments = testcase.getInputUi();
            int i = 0;
            while (i < persistentArguments.size()) {
                this.persistentDataStorage = ((com.savvytest.eclipse.core.model.xml.testcase.Argument)persistentArguments.get(i)).getDatas();
                this.persistentDataMap = this.getPersistentDataMap((com.savvytest.eclipse.core.model.xml.testcase.Argument)persistentArguments.get(i));
                FeatureMap parameters = ((Argument)volatileArguments.get(i)).getParameters().getParameters();
                this.visit(parameters);
                ++i;
            }
        }
    }

    private void storeValue(java.lang.String id, java.lang.String value, BaseType baseType, PropertiesUtils.PropertyEnum propertyEnum) {
        PersistentData data = this.persistentDataMap.get(id);
        if (data == null) {
            data = this.createDataElement(id, baseType, propertyEnum);
        }
        Property property = PropertiesUtils.getProperty((Properties)data.getProperties(), (PropertiesUtils.PropertyEnum)propertyEnum);
        property.setValue(value);
    }

    private PersistentData createDataElement(java.lang.String id, BaseType baseType, PropertiesUtils.PropertyEnum value) {
        PersistentData data = DataFactory.eINSTANCE.createPersistentData();
        data.setBaseType(baseType);
        data.setId(id);
        Properties props = PropertiesFactory.eINSTANCE.createProperties();
        props.getProperties().add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.INDEX, (java.lang.String)id));
        props.getProperties().add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)value, null));
        data.setProperties(props);
        this.persistentDataStorage.add(data);
        this.persistentDataMap.put(id, data);
        return data;
    }

    private void removePersistentDataElement(java.lang.String id) {
        Iterator<PersistentData> iterator = this.persistentDataStorage.iterator();
        while (iterator.hasNext()) {
            java.lang.String presistentID = iterator.next().getId();
            if (!presistentID.startsWith(id)) continue;
            iterator.remove();
            this.persistentDataMap.remove(presistentID);
        }
    }

    private Map<java.lang.String, PersistentData> getPersistentDataMap(com.savvytest.eclipse.core.model.xml.testcase.Argument argument) {
        EList data = argument.getDatas();
        HashMap<java.lang.String, PersistentData> persistentDataMap = new HashMap<java.lang.String, PersistentData>(data.size());
        for (PersistentData date : data) {
            persistentDataMap.put(date.getId(), date);
        }
        return persistentDataMap;
    }

    private void ensureMatchName(Data data, int columnIndex) throws ExcelImportExportException {
        java.lang.String dataName = data.getName();
        java.lang.String alias = PropertiesUtils.getStringProperty((Properties)data.getBaseTypeExtension().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
        if (alias != null) {
            dataName = alias;
        }
        java.lang.String cellName = this.readStringValueOfCell(columnIndex, 0);
        if (dataName == null || !dataName.equals(cellName)) {
            java.lang.String testcaseName = this.getTestcase().getName();
            java.lang.String technicalMessage = "The name of the data field \"" + dataName + "\" in the testcase \"" + testcaseName + "\" is not the same as the name of the cell \"" + cellName + "\" in the workbook.";
            java.lang.String userMessage = ImportVisitor.getClassString("error.nameMismatchDataExpected", dataName, cellName, testcaseName);
            throw new ExcelImportExportException(technicalMessage, userMessage);
        }
    }

    private void ensureMatchWorksheet(XSSFSheet sheet, Testcase testcase) throws ExcelImportExportException {
        java.lang.String sheetName = sheet.getSheetName();
        java.lang.String testcaseName = testcase.getName();
        if (testcaseName.length() > 31) {
            testcaseName = testcaseName.substring(0, 31);
        }
        if (!sheetName.equals(testcaseName)) {
            testcaseName = testcase.getName();
            java.lang.String testscenarioName = this.testscenario.getName();
            java.lang.String technicalMessage = "The name of testcase \"" + testcaseName + "\" in testscenario \"" + testscenarioName + "\" is not the same as the name of the sheet \"" + sheetName + "\" in the workbook.";
            java.lang.String userMessage = ImportVisitor.getClassString("error.nameMismatchTestcaseSheet", testcaseName, sheetName);
            throw new ExcelImportExportException(technicalMessage, userMessage);
        }
    }
}

