/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport.visitors;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.excel.importexport.visitors.AbstractImportExportVisitor;
import java.util.Iterator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.emf.ecore.util.FeatureMap;

public class ExportVisitor
extends AbstractImportExportVisitor {
    private final Testscenario testscenario;
    private final XSSFWorkbook wb;
    private int writingRow;
    private int writingColumn;
    private int arrayLevel;
    private AbstractImportExportVisitor.ArrayInformation arrayInfo;

    public ExportVisitor(Testscenario testscenario, XSSFWorkbook wb) {
        this.testscenario = testscenario;
        this.wb = wb;
        if (testscenario == null) {
            throw new IllegalArgumentException("TestscenarioFile must not be null.");
        }
        if (wb == null) {
            throw new IllegalArgumentException("Workbook must not be null.");
        }
    }

    public Object visit(Struct struct) throws Exception {
        this.visit(struct.getElements());
        return null;
    }

    public Object visit(Array array) throws Exception {
        this.writeHeader((Data)array);
        int oldWritingRow = this.writingRow;
        int oldWritingColumn = this.writingColumn;
        AbstractImportExportVisitor.ArrayInformation info = new AbstractImportExportVisitor.ArrayInformation(this, array, this.writingRow);
        if (this.arrayLevel == 0) {
            this.arrayInfo = info;
        } else {
            AbstractImportExportVisitor.ArrayInformation lastOfLevel = this.arrayInfo.getLastOfLevel(this.arrayLevel - 1);
            lastOfLevel.addInfo(info);
        }
        ++this.arrayLevel;
        Iterator iterator = array.getElements().iterator();
        int nextRow = oldWritingRow;
        int index = 0;
        while (iterator.hasNext()) {
            info.createNewLevel();
            this.writingColumn = oldWritingColumn;
            this.writeValue(index + 1);
            ++this.writingColumn;
            this.visit((FeatureMap.Entry)iterator.next());
            this.writingRow = nextRow += info.getUsedSize(index);
            ++index;
        }
        this.writingRow = oldWritingRow;
        --this.arrayLevel;
        return null;
    }

    public Object visit(String string) throws Exception {
        this.writeHeader((Data)string);
        java.lang.String value = string.getValue();
        if (value != null && value.length() > 0) {
            this.writeValue(value);
        }
        ++this.writingColumn;
        return null;
    }

    public Object visit(Number number) throws Exception {
        this.writeHeader((Data)number);
        if (number.getValue() != null) {
            this.writeValue(number.getValue().doubleValue());
        }
        ++this.writingColumn;
        return null;
    }

    public Object visit(Boolean bool) throws Exception {
        this.writeHeader((Data)bool);
        if (bool.getValue() != null) {
            this.writeValue(bool.getValue());
        }
        ++this.writingColumn;
        return null;
    }

    public Object visit(FeatureMap.Entry entry) throws Exception {
        Data data = (Data)entry.getValue();
        UsageType usage = PropertiesUtils.getUsage((Properties)data.getBaseTypeExtension().getProperties());
        java.lang.Boolean filler = PropertiesUtils.getBooleanProperty((Properties)data.getBaseType().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER);
        if (!(usage != UsageType.IN && usage != UsageType.INOUT || filler != null && filler.booleanValue())) {
            return super.visit(entry);
        }
        return null;
    }

    public void visit() throws Exception {
        for (Testcase testcase : this.testscenario.getTestcases().getTestcases()) {
            java.lang.String name = testcase.getName();
            if (name.length() > 31) {
                name = name.substring(0, 31);
            }
            XSSFSheet sheet = this.wb.createSheet(name);
            this.setSheet(sheet);
            sheet.createRow(0);
            this.writingRow = 1;
            this.writingColumn = 0;
            for (Argument arg : testcase.getInputUi()) {
                this.visit(arg.getParameters().getParameters());
            }
            this.adjustColumnSize(this.writingColumn);
            sheet.createFreezePane(0, 1);
        }
    }

    private void adjustColumnSize(int nrColumns) {
        XSSFSheet sheet = this.getSheet();
        int i = 0;
        while (i < nrColumns) {
            sheet.autoSizeColumn(i);
            ++i;
        }
    }

    private void writeHeader(Data data) {
        java.lang.String name = data.getName();
        java.lang.String alias = PropertiesUtils.getStringProperty((Properties)data.getBaseTypeExtension().getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
        if (alias != null) {
            name = alias;
        }
        if (data instanceof Array) {
            name = java.lang.String.valueOf(name) + "[" + ExportVisitor.getMaxArraySize((Array)data) + "]";
        }
        this.writeStringValueToCell(name, this.writingColumn, 0);
    }

    private void writeValue(java.lang.String value) {
        this.writeStringValueToCell(value, this.writingColumn, this.writingRow);
    }

    private void writeValue(double value) {
        this.writeNumberValueToCell(value, this.writingColumn, this.writingRow);
    }

    private void writeValue(boolean value) {
        this.writeBooleanValueToCell(value, this.writingColumn, this.writingRow);
    }
}

