/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.properties.util;

import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import java.math.BigDecimal;
import java.util.HashMap;

public class PropertiesUtils {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_BOOLEAN = "boolean";

    public static Property createProperty(PropertyEnum propertyEnum, String value) {
        Property property = PropertiesFactory.eINSTANCE.createProperty();
        property.setName(propertyEnum.getName());
        property.setType(propertyEnum.getType());
        property.setValue(value);
        return property;
    }

    public static Property createProperty(String name, String value, String type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null.");
        }
        Property property = PropertiesFactory.eINSTANCE.createProperty();
        property.setName(name);
        property.setValue(value);
        if (type != null) {
            property.setType(type);
        }
        return property;
    }

    public static boolean hasProperty(Properties properties, String key) {
        return PropertiesUtils.getProperty(properties, key) != null;
    }

    public static boolean hasProperty(Properties properties, PropertyEnum propertyEnum) {
        return PropertiesUtils.getProperty(properties, propertyEnum) != null;
    }

    public static Property getProperty(Properties properties, String key) {
        if (properties != null && key != null) {
            for (Property property : properties.getProperties()) {
                if (!key.equals(property.getName())) continue;
                return property;
            }
        }
        return null;
    }

    public static Property getProperty(Properties properties, PropertyEnum propertyEnum) {
        Property prop;
        if (propertyEnum != null && (prop = PropertiesUtils.getProperty(properties, propertyEnum.getName())) != null && (propertyEnum.getType() == null || propertyEnum.getType().equalsIgnoreCase(prop.getType()))) {
            return prop;
        }
        return null;
    }

    public static String getPropertyValue(Properties properties, String key) {
        Property prop = PropertiesUtils.getProperty(properties, key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public static String getPropertyValue(Properties properties, PropertyEnum propertyEnum) {
        Property prop = PropertiesUtils.getProperty(properties, propertyEnum);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public static String getStringProperty(Properties properties, String key) {
        Property prop = PropertiesUtils.getProperty(properties, key);
        if (prop != null && TYPE_STRING.equalsIgnoreCase(prop.getType())) {
            return prop.getValue();
        }
        return null;
    }

    public static String getStringProperty(Properties properties, PropertyEnum propertyEnum) {
        if (propertyEnum != null) {
            if (!TYPE_STRING.equalsIgnoreCase(propertyEnum.getType())) {
                throw new IllegalArgumentException("PropertyEnum is " + (Object)((Object)propertyEnum) + " with type '" + propertyEnum.getType() + "'. Expected type is '" + TYPE_STRING + "'");
            }
            Property prop = PropertiesUtils.getProperty(properties, propertyEnum);
            if (prop != null) {
                return prop.getValue();
            }
        }
        return null;
    }

    public static Boolean getBooleanProperty(Properties properties, String key) {
        String value;
        Property prop = PropertiesUtils.getProperty(properties, key);
        if (prop != null && TYPE_BOOLEAN.equalsIgnoreCase(prop.getType()) && (value = prop.getValue()) != null && value.length() > 0) {
            return Boolean.valueOf(prop.getValue());
        }
        return null;
    }

    public static Boolean getBooleanProperty(Properties properties, PropertyEnum propertyEnum) {
        if (propertyEnum != null) {
            String value;
            if (!TYPE_BOOLEAN.equalsIgnoreCase(propertyEnum.getType())) {
                throw new IllegalArgumentException("PropertyEnum is " + (Object)((Object)propertyEnum) + " with type '" + propertyEnum.getType() + "'. Expected type is '" + TYPE_BOOLEAN + "'");
            }
            Property prop = PropertiesUtils.getProperty(properties, propertyEnum);
            if (prop != null && (value = prop.getValue()) != null && value.length() > 0) {
                return Boolean.valueOf(prop.getValue());
            }
        }
        return null;
    }

    public static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        Boolean value = PropertiesUtils.getBooleanProperty(properties, key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(Properties properties, PropertyEnum propertyEnum, boolean defaultValue) {
        Boolean value = PropertiesUtils.getBooleanProperty(properties, propertyEnum);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static BigDecimal getNumberProperty(Properties properties, String key) {
        String value;
        Property prop = PropertiesUtils.getProperty(properties, key);
        if (prop != null && TYPE_NUMBER.equalsIgnoreCase(prop.getType()) && prop.getValue() != null && (value = prop.getValue()) != null && value.length() > 0) {
            return new BigDecimal(value);
        }
        return null;
    }

    public static BigDecimal getNumberProperty(Properties properties, PropertyEnum propertyEnum) {
        if (propertyEnum != null) {
            String value;
            if (!TYPE_NUMBER.equalsIgnoreCase(propertyEnum.getType())) {
                throw new IllegalArgumentException("PropertyEnum is " + (Object)((Object)propertyEnum) + " with type '" + propertyEnum.getType() + "'. Expected type is '" + TYPE_NUMBER + "'");
            }
            Property prop = PropertiesUtils.getProperty(properties, propertyEnum);
            if (prop != null && (value = prop.getValue()) != null && value.length() > 0) {
                return new BigDecimal(value);
            }
        }
        return null;
    }

    public static BigDecimal getNumberProperty(Properties properties, String key, BigDecimal defaultValue) {
        try {
            BigDecimal value = PropertiesUtils.getNumberProperty(properties, key);
            if (value != null) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public static BigDecimal getNumberProperty(Properties properties, PropertyEnum propertyEnum, BigDecimal defaultValue) {
        try {
            BigDecimal value = PropertiesUtils.getNumberProperty(properties, propertyEnum);
            if (value != null) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public static final UsageType getUsage(Properties properties) {
        String usageValue = PropertiesUtils.getPropertyValue(properties, PropertyEnum.USAGE);
        if (usageValue != null) {
            return UsageType.getByName(usageValue);
        }
        return UsageType.NONE;
    }

    public static String printProperties(Properties properties) {
        if (properties == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Property property : properties.getProperties()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("[").append(property.getName()).append(":").append(property.getValue());
            if (property.getType() != null && !TYPE_STRING.equalsIgnoreCase(property.getType())) {
                sb.append("<").append(property.getType()).append(">");
            }
            sb.append("]");
            first = false;
        }
        return sb.toString();
    }

    public static HashMap<String, String> getPropertiesMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties != null) {
            for (Property property : properties.getProperties()) {
                map.put(property.getName(), property.getValue());
            }
        }
        return map;
    }

    public static enum PropertyEnum {
        ALIAS("alias", "string"),
        ARCHIVE_TIMESTAMP("archiveTimestamp", "number"),
        ASSIGNATION("assignation", "string"),
        CPU_ID("CPU", "string"),
        DISPLAY_LENGTH("displayLength", "number"),
        FILLER("filler", "boolean"),
        HEX_ENCODING("hexEncoding", "string"),
        INDEX("index", "string"),
        LENGTH("length", "number"),
        LI_TYPE("liType", "string"),
        MASK("mask", "string"),
        MEDIA_TYPE("mediaType", "string"),
        OCCURS("occurs", "number"),
        PICTURE("picture", "string"),
        PLATFORM("platform", "string"),
        REDEFINED("redefined", "boolean"),
        REDEFINES("redefines", "string"),
        RUNNER_DATABASE_RESET("runnerDatabaseReset", "boolean"),
        RUNNER_FILLER("runnerFiller", "string"),
        RUNNER_REPEAT("runnerRepeat", "boolean"),
        RUNNER_USE_STUBS("runnerUseStubs", "boolean"),
        SCALE("scale", "number"),
        SIGN_SEPERATE("signSeparate", "boolean"),
        SIGNED("signed", "boolean"),
        STORAGE_LENGTH("storageLength", "number"),
        SYNCHRONIZED("synchronized", "boolean"),
        USAGE("usage", "string"),
        USAGE_TARGET("usageTarget", "string"),
        VALUE("value", null),
        VALUE_STRING("value", "string"),
        VALUE_NUMBER("value", "number"),
        VALUE_BOOLEAN("value", "boolean"),
        VERSION("version", "string");

        private final String name;
        private final String type;

        private PropertyEnum(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

