/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.rename;

import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import com.savvytest.eclipse.refactor.rename.AbstractSavvytestRenameParticipant;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class SavvytestFileRenameParticipant
extends AbstractSavvytestRenameParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.rename.SavvytestFileRenameParticipant.";
    private IFile oldFile;
    private IFile newFile;
    private Map<String, String> replacementMap;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestFileRenameParticipant(SavvytestTypeEnum renamedType, SavvytestTypeEnum ... changingTypes) {
        super(renamedType, changingTypes);
    }

    @Override
    protected Map<String, String> getIdReplacementMap() {
        if (this.replacementMap == null) {
            String oldFileString = URI.encodeOpaquePart((String)this.oldFile.getProjectRelativePath().toString(), (boolean)true);
            String newFileString = URI.encodeOpaquePart((String)this.newFile.getProjectRelativePath().toString(), (boolean)true);
            this.replacementMap = Collections.singletonMap(oldFileString, newFileString);
        }
        return this.replacementMap;
    }

    @Override
    protected IFile[] getFiles() {
        return new IFile[]{this.oldFile};
    }

    @Override
    protected IProject getProject() {
        return this.oldFile.getProject();
    }

    protected boolean initialize(Object element) {
        if (this.getArguments().getUpdateReferences() && element instanceof IFile) {
            this.oldFile = (IFile)element;
            if (this.renamedType.fileextension.equals(this.oldFile.getFileExtension())) {
                this.newFile = this.oldFile.getParent().getFile((IPath)new Path(this.getArguments().getNewName()));
                this.replacementMap = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.renamedType.fileextension.equals(this.newFile.getFileExtension())) {
            return RefactoringStatus.createFatalErrorStatus((String)SavvytestFileRenameParticipant.getClassString("error.fileending", this.renamedType.fileextension), (RefactoringStatusContext)new FileStatusContext(this.newFile, null));
        }
        return new RefactoringStatus();
    }
}

