/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.delete;

import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import com.savvytest.eclipse.refactor.delete.AbstractSavvytestDeleteParticipant;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class SavvytestFolderDeleteParticipant
extends AbstractSavvytestDeleteParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.delete.SavvytestFolderDeleteParticipant.";
    private IFolder folder;
    private IFile[] deletedFiles;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public SavvytestFolderDeleteParticipant(SavvytestTypeEnum deletedType, SavvytestTypeEnum ... changingTypes) {
        super(deletedType, changingTypes);
    }

    @Override
    protected IFile[] getFiles() {
        if (this.deletedFiles == null) {
            try {
                List<IFile> gatherFiles = this.gatherFiles(this.folder);
                this.deletedFiles = gatherFiles.toArray(new IFile[gatherFiles.size()]);
            }
            catch (CoreException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                return new IFile[0];
            }
        }
        return this.deletedFiles;
    }

    @Override
    protected IProject getProject() {
        return this.folder.getProject();
    }

    protected boolean initialize(Object element) {
        if (element instanceof IFolder) {
            this.folder = (IFolder)element;
            if (this.deletedType.foldername.equals(this.folder.getProjectRelativePath().segment(0))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.folder.getProjectRelativePath().lastSegment().equals(this.deletedType.foldername) && this.folder.getParent().getType() == 4) {
            return RefactoringStatus.createFatalErrorStatus((String)SavvytestFolderDeleteParticipant.getClassString("error.folder", new Object[0]), null);
        }
        return new RefactoringStatus();
    }

    private List<IFile> gatherFiles(IFolder folder) throws CoreException {
        IResource[] members = folder.members();
        ArrayList<IFile> files = new ArrayList<IFile>(members.length);
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 1 && this.deletedType.fileextension.equals(member.getFileExtension())) {
                files.add((IFile)member);
            } else if (member.getType() == 2) {
                files.addAll(this.gatherFiles((IFolder)member));
            }
            ++n2;
        }
        return files;
    }
}

