/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.move;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class AbstractSavvytestMoveParticipant
extends MoveParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.move.AbstractSavvytestMoveParticipant.";
    protected final SavvytestTypeEnum movedType;
    protected final SavvytestTypeEnum[] changingTypes;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    protected AbstractSavvytestMoveParticipant(SavvytestTypeEnum movedType, SavvytestTypeEnum[] changingTypes) {
        this.movedType = movedType;
        this.changingTypes = changingTypes;
    }

    public String getName() {
        return String.valueOf(this.movedType.fileextension) + " move participant.";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<IFile, TextFileChange> changes = new HashMap<IFile, TextFileChange>();
        this.updateIds(this.movedType, (IResource[])this.getFiles(), changes, pm);
        this.updateHierarchy(this.getFiles(), changes, pm);
        return this.wrapIntoCompositeChange(changes, AbstractSavvytestMoveParticipant.getClassString("internalLabel", new Object[0]));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<IFile, TextFileChange> changes = new HashMap<IFile, TextFileChange>();
        SavvytestTypeEnum[] savvytestTypeEnumArray = this.changingTypes;
        int n = this.changingTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SavvytestTypeEnum type = savvytestTypeEnumArray[n2];
            IResource[] defaultRoots = new IResource[]{type.getDefaultFolder((IResource)this.getProject())};
            this.updateIds(type, defaultRoots, changes, pm);
            ++n2;
        }
        return this.wrapIntoCompositeChange(changes, AbstractSavvytestMoveParticipant.getClassString("referenceLabel", new Object[0]));
    }

    private Change wrapIntoCompositeChange(Map<IFile, TextFileChange> changes, String label) {
        if (changes.isEmpty()) {
            return null;
        }
        Iterator<TextFileChange> iter = changes.values().iterator();
        while (iter.hasNext()) {
            if (iter.next().getParent() == null) continue;
            iter.remove();
        }
        return new CompositeChange(label, changes.values().toArray(new Change[changes.size()]));
    }

    private void updateIds(SavvytestTypeEnum type, IResource[] roots, Map<IFile, TextFileChange> changes, IProgressMonitor monitor) {
        final Map<String, String> replacementMap = this.getIdReplacementMap();
        String[] fileNamePatterns = new String[]{"*." + type.fileextension};
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
        Pattern searchPattern = this.createSearchPattern(replacementMap.keySet());
        TextFileChangeRequestor requestor = new TextFileChangeRequestor(this, changes){

            @Override
            protected boolean handleChange(TextFileChange change, TextSearchMatchAccess matchAccess) {
                String replacementString = (String)replacementMap.get(matchAccess.getFileContent(matchAccess.getMatchOffset(), matchAccess.getMatchLength()));
                ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), replacementString);
                change.addEdit((TextEdit)edit);
                change.addTextEditGroup(new TextEditGroup(AbstractSavvytestMoveParticipant.getClassString("updateLabel", new Object[0]), (TextEdit)edit));
                return true;
            }
        };
        TextSearchEngine.create().search((TextSearchScope)searchScope, (TextSearchRequestor)requestor, searchPattern, monitor);
    }

    private void updateHierarchy(IFile[] files, Map<IFile, TextFileChange> changes, IProgressMonitor monitor) {
        int difference = this.getHierarchyDifference();
        if (difference == 0) {
            return;
        }
        String[] fileNamePatterns = new String[]{"*"};
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])files, (String[])fileNamePatterns, (boolean)false);
        if (difference > 0) {
            Pattern searchPattern = Pattern.compile("\\.\\.\\/(?!\\.)");
            StringBuilder builder = new StringBuilder(3 * difference);
            int i = 0;
            while (i < difference) {
                builder.append("../");
                ++i;
            }
            final String insert = builder.toString();
            TextFileChangeRequestor requestor = new TextFileChangeRequestor(this, changes){

                @Override
                protected boolean handleChange(TextFileChange change, TextSearchMatchAccess matchAccess) {
                    InsertEdit edit = new InsertEdit(matchAccess.getMatchOffset(), insert);
                    change.addEdit((TextEdit)edit);
                    change.addTextEditGroup(new TextEditGroup(AbstractSavvytestMoveParticipant.getClassString("updateLabel", new Object[0]), (TextEdit)edit));
                    return true;
                }
            };
            TextSearchEngine.create().search((TextSearchScope)searchScope, (TextSearchRequestor)requestor, searchPattern, monitor);
        } else {
            StringBuilder builder = new StringBuilder(6 * -difference + 10);
            int i = 0;
            while (i > difference) {
                builder.append("\\.\\.\\/");
                --i;
            }
            builder.append("(?!\\.)");
            Pattern searchPattern = Pattern.compile(builder.toString());
            TextFileChangeRequestor requestor = new TextFileChangeRequestor(this, changes){

                @Override
                protected boolean handleChange(TextFileChange change, TextSearchMatchAccess matchAccess) {
                    DeleteEdit edit = new DeleteEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength());
                    change.addEdit((TextEdit)edit);
                    change.addTextEditGroup(new TextEditGroup(AbstractSavvytestMoveParticipant.getClassString("updateLabel", new Object[0]), (TextEdit)edit));
                    return true;
                }
            };
            TextSearchEngine.create().search((TextSearchScope)searchScope, (TextSearchRequestor)requestor, searchPattern, monitor);
        }
    }

    private Pattern createSearchPattern(Collection<String> searchFor) {
        StringBuilder builder = new StringBuilder(searchFor.size() * 50);
        Iterator<String> iter = searchFor.iterator();
        while (iter.hasNext()) {
            builder.append('(');
            builder.append(Pattern.quote(iter.next()));
            builder.append(')');
            if (!iter.hasNext()) continue;
            builder.append('|');
        }
        return Pattern.compile(builder.toString());
    }

    protected abstract Map<String, String> getIdReplacementMap();

    protected abstract IFile[] getFiles();

    protected abstract IProject getProject();

    protected abstract int getHierarchyDifference();

    private abstract class TextFileChangeRequestor
    extends TextSearchRequestor {
        private final Map<IFile, TextFileChange> changes;

        private TextFileChangeRequestor(Map<IFile, TextFileChange> changes) {
            this.changes = changes;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
            IFile file = matchAccess.getFile();
            TextFileChange change = this.changes.get(file);
            if (change == null) {
                TextChange previousChanges = AbstractSavvytestMoveParticipant.this.getTextChange(file);
                if (previousChanges == null) {
                    change = new TextFileChange(file.getName(), file);
                    change.setEdit((TextEdit)new MultiTextEdit());
                } else if (previousChanges instanceof TextFileChange) {
                    change = (TextFileChange)previousChanges;
                } else {
                    SavvytestSettings.INSTANCE.getLogger().log("Unknown change type (" + previousChanges.getClass().getSimpleName() + ") to handle for file: " + file, LogLevel.WARNING, (Object)this);
                    return false;
                }
                this.changes.put(file, change);
            }
            return this.handleChange(change, matchAccess);
        }

        protected abstract boolean handleChange(TextFileChange var1, TextSearchMatchAccess var2);
    }
}

